/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.cpp.core.projectModel;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.rider.cpp.core.projectModel.RadLanguageUtilsKt;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.rider.cpp.fileType.CppFileType;
import com.jetbrains.rider.cpp.fileType.CppLanguage;
import com.jetbrains.rider.cpp.fileType.CppSourceFileType;
import com.jetbrains.rider.cpp.fileType.psi.CppFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\rH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/rider/cpp/core/projectModel/RadLanguageUtils;", "Lcom/jetbrains/cidr/lang/LanguageUtils;", "<init>", "()V", "isCppSupportDisabled", "", "project", "Lcom/intellij/openapi/project/Project;", "getConfigLanguage", "Lcom/intellij/lang/Language;", "getLightLanguage", "getSlowLanguage", "getBaseFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "isSupportedFile", "psiFile", "Lcom/intellij/psi/PsiFile;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isSupportedFileType", "fileType", "intellij.rider.cpp.core.projectModel"})
public final class RadLanguageUtils
implements LanguageUtils {
    public boolean isCppSupportDisabled(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    @NotNull
    public Language getConfigLanguage() {
        return (Language)CppLanguage.INSTANCE;
    }

    @NotNull
    public Language getLightLanguage() {
        return (Language)CppLanguage.INSTANCE;
    }

    @NotNull
    public Language getSlowLanguage() {
        return (Language)CppLanguage.INSTANCE;
    }

    @NotNull
    public FileType getBaseFileType() {
        return (FileType)CppSourceFileType.INSTANCE;
    }

    public boolean isSupportedFile(@Nullable PsiFile psiFile) {
        return psiFile instanceof CppFile;
    }

    public boolean isSupportedFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        FileType fileType = virtualFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        return this.isSupportedFileType(fileType);
    }

    public boolean isSupportedFileType(@NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        return fileType instanceof CppFileType && !RadLanguageUtilsKt.access$isHlslFileType(fileType);
    }
}

