/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.worker;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.aspire.dashboard.AspireMainServiceViewContributor;
import com.jetbrains.rider.aspire.dashboard.AspireWorker;
import com.jetbrains.rider.aspire.run.AspireHostConfiguration;
import com.jetbrains.rider.aspire.run.AspireHostConfigurationParameters;
import com.jetbrains.rider.aspire.run.AspireHostConfigurationType;
import com.jetbrains.rider.aspire.worker.AspireWorkerManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/aspire/worker/AspireWorkerManager;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "aspireWorker", "Lcom/jetbrains/rider/aspire/dashboard/AspireWorker;", "getAspireWorker", "()Lcom/jetbrains/rider/aspire/dashboard/AspireWorker;", "startAspireWorker", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopAspireWorker", "", "addAspireHost", "projectFilePath", "", "removeAspireHost", "sendServiceResetEvent", "Companion", "RunListener", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nAspireWorkerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspireWorkerManager.kt\ncom/jetbrains/rider/aspire/worker/AspireWorkerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,102:1\n774#2:103\n865#2,2:104\n13#3:106\n*S KotlinDebug\n*F\n+ 1 AspireWorkerManager.kt\ncom/jetbrains/rider/aspire/worker/AspireWorkerManager\n*L\n71#1:103\n71#1:104,2\n31#1:106\n*E\n"})
public final class AspireWorkerManager
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AspireWorker aspireWorker;
    @NotNull
    private static final Logger LOG;

    public AspireWorkerManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.aspireWorker = new AspireWorker((Lifetime)this.getServiceLifetime().createNested(), this.project);
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.aspireWorker);
    }

    @NotNull
    public final AspireWorker getAspireWorker() {
        return this.aspireWorker;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object startAspireWorker(@NotNull Continuation<? super AspireWorker> $completion) {
        if (!($completion instanceof startAspireWorker.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ AspireWorkerManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startAspireWorker((Continuation<? super AspireWorker>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                AspireWorkerManager.LOG.trace("Starting Aspire worker");
                $continuation.label = 1;
                v0 = this.aspireWorker.start((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                return this.aspireWorker;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object stopAspireWorker(@NotNull Continuation<? super Unit> $completion) {
        LOG.trace("Stopping Aspire worker");
        Object object = this.aspireWorker.stop($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void addAspireHost(String projectFilePath) {
        boolean hasAspireHosts = this.aspireWorker.getHasAspireHosts();
        Path path = Paths.get(projectFilePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.aspireWorker.addAspireHostProject(path);
        if (!hasAspireHosts) {
            this.sendServiceResetEvent();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeAspireHost(String projectFilePath) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        AspireHostConfigurationType configurationType = (AspireHostConfigurationType)ConfigurationTypeUtil.findConfigurationType(AspireHostConfigurationType.class);
        Iterable iterable = RunManager.Companion.getInstance(this.project).getConfigurationsList((ConfigurationType)configurationType);
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RunConfiguration it = (RunConfiguration)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof AspireHostConfiguration && Intrinsics.areEqual((Object)((AspireHostConfiguration)it).getParameters().getProjectFilePath(), (Object)projectFilePath))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List configurations = (List)destination$iv$iv;
        if (!((Collection)configurations).isEmpty()) {
            return;
        }
        Path path = Paths.get(projectFilePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.aspireWorker.removeAspireHostProject(path);
        if (!this.aspireWorker.getHasAspireHosts()) {
            this.sendServiceResetEvent();
        }
    }

    private final void sendServiceResetEvent() {
        ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createResetEvent(AspireMainServiceViewContributor.class);
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = ServiceEventListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(event);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AspireWorkerManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/aspire/worker/AspireWorkerManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/aspire/worker/AspireWorkerManager;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nAspireWorkerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspireWorkerManager.kt\ncom/jetbrains/rider/aspire/worker/AspireWorkerManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,102:1\n30#2,2:103\n*S KotlinDebug\n*F\n+ 1 AspireWorkerManager.kt\ncom/jetbrains/rider/aspire/worker/AspireWorkerManager$Companion\n*L\n29#1:103,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AspireWorkerManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<AspireWorkerManager> serviceClass$iv = AspireWorkerManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AspireWorkerManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/aspire/worker/AspireWorkerManager$RunListener;", "Lcom/intellij/execution/RunManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "runConfigurationAdded", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runConfigurationRemoved", "aspire-plugin"})
    public static final class RunListener
    implements RunManagerListener {
        @NotNull
        private final Project project;

        public RunListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            RunConfiguration configuration = runConfiguration;
            if (!(configuration instanceof AspireHostConfiguration)) {
                return;
            }
            AspireHostConfigurationParameters params = ((AspireHostConfiguration)configuration).getParameters();
            Companion.getInstance(this.project).addAspireHost(params.getProjectFilePath());
        }

        public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            RunConfiguration configuration = runConfiguration;
            if (!(configuration instanceof AspireHostConfiguration)) {
                return;
            }
            AspireHostConfigurationParameters params = ((AspireHostConfiguration)configuration).getParameters();
            Companion.getInstance(this.project).removeAspireHost(params.getProjectFilePath());
        }
    }
}

