/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.worker;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.NetCoreRuntime;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.aspire.util.AnsiEscapeDecoderUtilsKt;
import com.jetbrains.rider.aspire.worker.AspireWorkerConfig;
import com.jetbrains.rider.aspire.worker.AspireWorkerLauncher;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/aspire/worker/AspireWorkerLauncher;", "", "<init>", "()V", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "hostAssemblyPath", "Ljava/nio/file/Path;", "launchWorker", "", "config", "Lcom/jetbrains/rider/aspire/worker/AspireWorkerConfig;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "dotnetCliPath", "", "getLogFile", "Companion", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nAspireWorkerLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspireWorkerLauncher.kt\ncom/jetbrains/rider/aspire/worker/AspireWorkerLauncher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,132:1\n67#2,4:133\n13#2:137\n*S KotlinDebug\n*F\n+ 1 AspireWorkerLauncher.kt\ncom/jetbrains/rider/aspire/worker/AspireWorkerLauncher\n*L\n71#1:133,4\n43#1:137\n*E\n"})
public final class AspireWorkerLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginId pluginId = PluginId.Companion.getId("me.rafaelldi.aspire");
    @NotNull
    private final Path hostAssemblyPath;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String RIDER_PARENT_PROCESS_ID = "RIDER_PARENT_PROCESS_ID";
    @NotNull
    private static final String RIDER_DCP_SESSION_TOKEN = "RIDER_DCP_SESSION__Token";
    @NotNull
    private static final String RIDER_RD_PORT = "RIDER_CONNECTION__RdPort";
    @NotNull
    private static final String SERILOG_FILE_PATH = "Serilog__WriteTo__0__Args__configure__0__Args__path";

    /*
     * WARNING - void declaration
     */
    public AspireWorkerLauncher() {
        void $this$hostAssemblyPath_u24lambda_u240;
        AspireWorkerLauncher aspireWorkerLauncher = this;
        AspireWorkerLauncher aspireWorkerLauncher2 = this;
        boolean bl = false;
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)$this$hostAssemblyPath_u24lambda_u240.pluginId);
        if (ideaPluginDescriptor == null) {
            throw new IllegalStateException(("Plugin " + $this$hostAssemblyPath_u24lambda_u240.pluginId + " could not be found.").toString());
        }
        IdeaPluginDescriptor plugin = ideaPluginDescriptor;
        Path path = plugin.getPluginPath();
        if (path == null) {
            throw new IllegalStateException(("Could not detect path of plugin " + plugin + " on disk.").toString());
        }
        Path basePath = path;
        Path path2 = basePath.resolve("AspireWorker");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = path2.resolve("AspireWorker.dll");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        aspireWorkerLauncher2.hostAssemblyPath = path3;
    }

    public final void launchWorker(@NotNull AspireWorkerConfig config, @NotNull LifetimeDefinition lifetime) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        LOG.info("Starting Aspire worker");
        String dotnetCliPath = (String)NetCoreRuntime.INSTANCE.getCliPath().getValue();
        GeneralCommandLine commandLine = this.getCommandLine(dotnetCliPath, config);
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Host command line: " + commandLine.getCommandLineString());
        }
        KillableColoredProcessHandler.Silent processHandler2 = new KillableColoredProcessHandler.Silent(commandLine);
        lifetime.onTermination(() -> AspireWorkerLauncher.launchWorker$lambda$1(processHandler2));
        processHandler2.addProcessListener(new ProcessListener(lifetime){
            final /* synthetic */ LifetimeDefinition $lifetime;
            {
                this.$lifetime = $lifetime;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType2) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType2, (String)"outputType");
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String text = ((Object)StringsKt.trim((CharSequence)AnsiEscapeDecoderUtilsKt.decodeAnsiCommandsToString(string, outputType2))).toString();
                if (Intrinsics.areEqual(outputType2, (Object)ProcessOutputType.STDERR)) {
                    AspireWorkerLauncher.access$getLOG$cp().warn(text);
                } else {
                    AspireWorkerLauncher.access$getLOG$cp().debug(text);
                }
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$lifetime.executeIfAlive(() -> launchWorker.3.processTerminated$lambda$0(this.$lifetime));
            }

            private static final boolean processTerminated$lambda$0(LifetimeDefinition $lifetime) {
                AspireWorkerLauncher.access$getLOG$cp().info("Aspire worker process was terminated; terminating the lifetime");
                return $lifetime.terminate(true);
            }
        }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)lifetime), null, (int)1, null));
        processHandler2.startNotify();
        LOG.trace("Aspire worker started");
    }

    /*
     * WARNING - void declaration
     */
    private final GeneralCommandLine getCommandLine(String dotnetCliPath, AspireWorkerConfig config) {
        void $this$getCommandLine_u24lambda_u240;
        Path logFile = this.getLogFile();
        Object object = new String[]{((Object)this.hostAssemblyPath).toString()};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(dotnetCliPath).withCharset(StandardCharsets.UTF_8).withParameters(object).withWorkDirectory(this.hostAssemblyPath.getParent().toFile());
        Object object2 = object = MapsKt.createMapBuilder();
        GeneralCommandLine generalCommandLine2 = generalCommandLine;
        boolean bl = false;
        String string = config.getUseHttps() ? (String)((Object)$this$getCommandLine_u24lambda_u240.put("Kestrel__Endpoints__Https__Url", "https://localhost:" + config.getDebugSessionPort() + "/")) : (String)((Object)$this$getCommandLine_u24lambda_u240.put("Kestrel__Endpoints__Http__Url", "http://localhost:" + config.getDebugSessionPort() + "/"));
        $this$getCommandLine_u24lambda_u240.put(RIDER_RD_PORT, String.valueOf(config.getRdPort()));
        $this$getCommandLine_u24lambda_u240.put(RIDER_PARENT_PROCESS_ID, String.valueOf(ProcessHandle.current().pid()));
        $this$getCommandLine_u24lambda_u240.put(RIDER_DCP_SESSION_TOKEN, config.getDebugSessionToken());
        $this$getCommandLine_u24lambda_u240.put(SERILOG_FILE_PATH, ((Object)logFile.toAbsolutePath()).toString());
        GeneralCommandLine generalCommandLine3 = generalCommandLine2.withEnvironment(MapsKt.build((Map)object));
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine3, (String)"withEnvironment(...)");
        GeneralCommandLine commandLine = generalCommandLine3;
        return commandLine;
    }

    private final Path getLogFile() {
        Path aspireWorkerLogFolder = RiderEnvironment.INSTANCE.getLogDirectory().toPath().resolve("AspireWorker");
        SimpleDateFormat format = new SimpleDateFormat("yyyy_M_dd_HH_mm_ss");
        String currentTimeString = format.format(new Date());
        String logFileName = currentTimeString + ".log";
        Path path = aspireWorkerLogFolder.resolve(logFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final Unit launchWorker$lambda$1(KillableColoredProcessHandler.Silent $processHandler) {
        if (!$processHandler.isProcessTerminating() && !$processHandler.isProcessTerminated()) {
            LOG.info("Aspire worker lifetime was terminated; killing the process");
            $processHandler.destroyProcess();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AspireWorkerLauncher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/aspire/worker/AspireWorkerLauncher$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/aspire/worker/AspireWorkerLauncher;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "RIDER_PARENT_PROCESS_ID", "", "RIDER_DCP_SESSION_TOKEN", "RIDER_RD_PORT", "SERILOG_FILE_PATH", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nAspireWorkerLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspireWorkerLauncher.kt\ncom/jetbrains/rider/aspire/worker/AspireWorkerLauncher$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,132:1\n30#2,2:133\n*S KotlinDebug\n*F\n+ 1 AspireWorkerLauncher.kt\ncom/jetbrains/rider/aspire/worker/AspireWorkerLauncher$Companion\n*L\n41#1:133,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AspireWorkerLauncher getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<AspireWorkerLauncher> serviceClass$iv = AspireWorkerLauncher.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AspireWorkerLauncher)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

