/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.util;

import com.intellij.docker.DockerIcons;
import com.intellij.icons.AllIcons;
import com.intellij.ui.BadgeIconSupplier;
import com.jetbrains.rider.aspire.dashboard.AspireResource;
import com.jetbrains.rider.aspire.generated.ResourceHealthStatus;
import com.jetbrains.rider.aspire.generated.ResourceState;
import com.jetbrains.rider.aspire.generated.ResourceType;
import icons.ReSharperIcons;
import icons.RiderIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001f\u0010\u0004\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u00a8\u0006\n"}, d2={"getIcon", "Ljavax/swing/Icon;", "aspireResource", "Lcom/jetbrains/rider/aspire/dashboard/AspireResource;", "getBaseIcon", "Lorg/jetbrains/annotations/NotNull;", "type", "Lcom/jetbrains/rider/aspire/generated/ResourceType;", "containerImage", "", "aspire-plugin"})
public final class AspireResourceUtilsKt {
    @NotNull
    public static final Icon getIcon(@NotNull AspireResource aspireResource) {
        Intrinsics.checkNotNullParameter((Object)aspireResource, (String)"aspireResource");
        AspireResource.AspireResourceProperty<String> aspireResourceProperty = aspireResource.getContainerImage();
        Icon baseIcon = AspireResourceUtilsKt.getBaseIcon(aspireResource.getType(), aspireResourceProperty != null ? aspireResourceProperty.getValue() : null);
        ResourceState resourceState = aspireResource.getState();
        Icon icon = switch (resourceState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[resourceState.ordinal()]) {
            case 1 -> new BadgeIconSupplier(baseIcon).getErrorIcon();
            case 2 -> new BadgeIconSupplier(baseIcon).getErrorIcon();
            case 3 -> new BadgeIconSupplier(baseIcon).getWarningIcon();
            case 4 -> {
                if (aspireResource.getHealthStatus() == ResourceHealthStatus.Healthy || aspireResource.getHealthStatus() == null) {
                    yield new BadgeIconSupplier(baseIcon).getLiveIndicatorIcon();
                }
                yield new BadgeIconSupplier(baseIcon).getWarningIcon();
            }
            default -> baseIcon;
        };
        return icon;
    }

    @NotNull
    public static final Icon getBaseIcon(@NotNull ResourceType type, @Nullable String containerImage) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Icon icon = switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1 -> RiderIcons.RunConfigurations.DotNetProject;
            case 2 -> AllIcons.Nodes.Console;
            case 3 -> ReSharperIcons.PsiSymbols.Parameter;
            case 4 -> AllIcons.General.Web;
            case 5 -> {
                String v1 = containerImage;
                boolean v2 = v1 != null ? StringsKt.contains$default((CharSequence)v1, (CharSequence)"postgres", (boolean)false, (int)2, null) : false;
                if (v2) {
                    yield AllIcons.Providers.Postgresql;
                }
                String v3 = containerImage;
                boolean v4 = v3 != null ? StringsKt.contains$default((CharSequence)v3, (CharSequence)"mssql", (boolean)false, (int)2, null) : false;
                if (v4) {
                    yield AllIcons.Providers.SqlServer;
                }
                String v5 = containerImage;
                boolean v6 = v5 != null ? StringsKt.contains$default((CharSequence)v5, (CharSequence)"mysql", (boolean)false, (int)2, null) : false;
                if (v6) {
                    yield AllIcons.Providers.Mysql;
                }
                String v7 = containerImage;
                boolean v8 = v7 != null ? StringsKt.contains$default((CharSequence)v7, (CharSequence)"mongo", (boolean)false, (int)2, null) : false;
                if (v8) {
                    yield AllIcons.Providers.MongoDB;
                }
                String v9 = containerImage;
                boolean v10 = v9 != null ? StringsKt.contains$default((CharSequence)v9, (CharSequence)"elasticsearch", (boolean)false, (int)2, null) : false;
                if (v10) {
                    yield AllIcons.Providers.Elasticsearch;
                }
                String v11 = containerImage;
                boolean v12 = v11 != null ? StringsKt.contains$default((CharSequence)v11, (CharSequence)"redis", (boolean)false, (int)2, null) : false;
                if (v12) {
                    yield AllIcons.Providers.Redis;
                }
                String v13 = containerImage;
                boolean v14 = v13 != null ? StringsKt.contains$default((CharSequence)v13, (CharSequence)"rabbitmq", (boolean)false, (int)2, null) : false;
                if (v14) {
                    yield AllIcons.Providers.RabbitMQ;
                }
                String v15 = containerImage;
                boolean v16 = v15 != null ? StringsKt.contains$default((CharSequence)v15, (CharSequence)"confluent", (boolean)false, (int)2, null) : false;
                if (v16) {
                    yield AllIcons.Providers.Kafka;
                }
                yield DockerIcons.Docker;
            }
            case 6 -> AllIcons.Providers.Postgresql;
            case 7 -> AllIcons.Providers.SqlServer;
            case 8 -> AllIcons.Providers.Mysql;
            case 9 -> AllIcons.Providers.MongoDB;
            case 10 -> AllIcons.FileTypes.Unknown;
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)icon);
        return icon;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ResourceState.values().length];
            try {
                nArray[ResourceState.FailedToStart.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceState.RuntimeUnhealthy.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceState.Waiting.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceState.Running.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ResourceType.values().length];
            try {
                nArray[ResourceType.Project.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.Executable.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.Parameter.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.ExternalService.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.Container.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.Postgres.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.SqlServer.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.MySql.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.MongoDB.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.Unknown.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

