/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.sessions;

import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.aspire.generated.CreateSessionRequest;
import com.jetbrains.rider.aspire.sessions.SessionLaunchMode;
import com.jetbrains.rider.aspire.sessions.SessionLaunchPreferenceService;
import com.jetbrains.rider.aspire.sessions.SessionProcessLauncher;
import com.jetbrains.rider.aspire.sessions.projectLaunchers.SessionProcessLauncherExtension;
import java.util.Comparator;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0086@\u00a2\u0006\u0002\u0010\u0011J8\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0082@\u00a2\u0006\u0002\u0010\u0011J8\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0082@\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0082@\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/aspire/sessions/SessionProcessLauncher;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "launchSessionProcess", "", "sessionId", "", "sessionModel", "Lcom/jetbrains/rider/aspire/generated/CreateSessionRequest;", "sessionProcessEventListener", "Lcom/intellij/execution/process/ProcessListener;", "sessionProcessLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "aspireHostRunConfigName", "(Ljava/lang/String;Lcom/jetbrains/rider/aspire/generated/CreateSessionRequest;Lcom/intellij/execution/process/ProcessListener;Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "launchDebugProcess", "launchRunProcess", "getSessionProcessLauncher", "Lcom/jetbrains/rider/aspire/sessions/projectLaunchers/SessionProcessLauncherExtension;", "projectPath", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nSessionProcessLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionProcessLauncher.kt\ncom/jetbrains/rider/aspire/sessions/SessionProcessLauncher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,130:1\n1056#2:131\n13#3:132\n*S KotlinDebug\n*F\n+ 1 SessionProcessLauncher.kt\ncom/jetbrains/rider/aspire/sessions/SessionProcessLauncher\n*L\n123#1:131\n24#1:132\n*E\n"})
public final class SessionProcessLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public SessionProcessLauncher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final Object launchSessionProcess(@NotNull String sessionId, @NotNull CreateSessionRequest sessionModel, @NotNull ProcessListener sessionProcessEventListener, @NotNull Lifetime sessionProcessLifetime, @Nullable String aspireHostRunConfigName, @NotNull Continuation<? super Unit> $completion) {
        SessionLaunchMode preferred;
        LOG.info("Starting a session process for the project " + sessionModel.getProjectPath());
        if (RLifetimeKt.isNotAlive((Lifetime)sessionProcessLifetime)) {
            LOG.warn("Unable to run project " + sessionModel.getProjectPath() + " because lifetimes are not alive");
            return Unit.INSTANCE;
        }
        SessionLaunchMode sessionLaunchMode = preferred = SessionLaunchPreferenceService.Companion.getInstance(this.project).getPreferredLaunchMode(sessionModel.getProjectPath());
        boolean shouldDebug = switch (sessionLaunchMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[sessionLaunchMode.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case -1 -> sessionModel.getDebug();
            default -> throw new NoWhenBranchMatchedException();
        };
        if (shouldDebug) {
            Object object = this.launchDebugProcess(sessionId, sessionModel, sessionProcessEventListener, sessionProcessLifetime, aspireHostRunConfigName, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = this.launchRunProcess(sessionId, sessionModel, sessionProcessEventListener, sessionProcessLifetime, aspireHostRunConfigName, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object launchDebugProcess(String sessionId, CreateSessionRequest sessionModel, ProcessListener sessionProcessEventListener, Lifetime sessionProcessLifetime, String aspireHostRunConfigName, Continuation<? super Unit> $completion) {
        if (!($completion instanceof launchDebugProcess.1)) ** GOTO lbl-1000
        var9_7 = $completion;
        if ((var9_7.label & -2147483648) != 0) {
            var9_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ SessionProcessLauncher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SessionProcessLauncher.access$launchDebugProcess(this.this$0, null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = sessionId;
                $continuation.L$1 = sessionModel;
                $continuation.L$2 = sessionProcessEventListener;
                $continuation.L$3 = sessionProcessLifetime;
                $continuation.L$4 = aspireHostRunConfigName;
                $continuation.label = 1;
                v0 = this.getSessionProcessLauncher(sessionModel.getProjectPath(), (Continuation<? super SessionProcessLauncherExtension>)$continuation);
                if (v0 == var10_9) {
                    return var10_9;
                }
                ** GOTO lbl30
            }
            case 1: {
                aspireHostRunConfigName = (String)$continuation.L$4;
                sessionProcessLifetime = (Lifetime)$continuation.L$3;
                sessionProcessEventListener = (ProcessListener)$continuation.L$2;
                sessionModel = (CreateSessionRequest)$continuation.L$1;
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                if ((processLauncher = (SessionProcessLauncherExtension)v0) == null) {
                    SessionProcessLauncher.LOG.warn("Unable to find appropriate process launcher for the project " + sessionModel.getProjectPath());
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)sessionId);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)sessionModel);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)sessionProcessEventListener);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)sessionProcessLifetime);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)aspireHostRunConfigName);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)processLauncher);
                $continuation.label = 2;
                v1 = processLauncher.launchDebugProcess(sessionId, sessionModel, sessionProcessEventListener, sessionProcessLifetime, aspireHostRunConfigName, this.project, (Continuation<? super Unit>)$continuation);
                if (v1 == var10_9) {
                    return var10_9;
                }
                ** GOTO lbl53
            }
            case 2: {
                processLauncher = (SessionProcessLauncherExtension)$continuation.L$5;
                aspireHostRunConfigName = (String)$continuation.L$4;
                sessionProcessLifetime = (Lifetime)$continuation.L$3;
                sessionProcessEventListener = (ProcessListener)$continuation.L$2;
                sessionModel = (CreateSessionRequest)$continuation.L$1;
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl53:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object launchRunProcess(String sessionId, CreateSessionRequest sessionModel, ProcessListener sessionProcessEventListener, Lifetime sessionProcessLifetime, String aspireHostRunConfigName, Continuation<? super Unit> $completion) {
        if (!($completion instanceof launchRunProcess.1)) ** GOTO lbl-1000
        var9_7 = $completion;
        if ((var9_7.label & -2147483648) != 0) {
            var9_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ SessionProcessLauncher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SessionProcessLauncher.access$launchRunProcess(this.this$0, null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = sessionId;
                $continuation.L$1 = sessionModel;
                $continuation.L$2 = sessionProcessEventListener;
                $continuation.L$3 = sessionProcessLifetime;
                $continuation.L$4 = aspireHostRunConfigName;
                $continuation.label = 1;
                v0 = this.getSessionProcessLauncher(sessionModel.getProjectPath(), (Continuation<? super SessionProcessLauncherExtension>)$continuation);
                if (v0 == var10_9) {
                    return var10_9;
                }
                ** GOTO lbl30
            }
            case 1: {
                aspireHostRunConfigName = (String)$continuation.L$4;
                sessionProcessLifetime = (Lifetime)$continuation.L$3;
                sessionProcessEventListener = (ProcessListener)$continuation.L$2;
                sessionModel = (CreateSessionRequest)$continuation.L$1;
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                if ((processLauncher = (SessionProcessLauncherExtension)v0) == null) {
                    SessionProcessLauncher.LOG.warn("Unable to find appropriate process launcher for the project " + sessionModel.getProjectPath());
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)sessionId);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)sessionModel);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)sessionProcessEventListener);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)sessionProcessLifetime);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)aspireHostRunConfigName);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)processLauncher);
                $continuation.label = 2;
                v1 = processLauncher.launchRunProcess(sessionId, sessionModel, sessionProcessEventListener, sessionProcessLifetime, aspireHostRunConfigName, this.project, (Continuation<? super Unit>)$continuation);
                if (v1 == var10_9) {
                    return var10_9;
                }
                ** GOTO lbl53
            }
            case 2: {
                processLauncher = (SessionProcessLauncherExtension)$continuation.L$5;
                aspireHostRunConfigName = (String)$continuation.L$4;
                sessionProcessLifetime = (Lifetime)$continuation.L$3;
                sessionProcessEventListener = (ProcessListener)$continuation.L$2;
                sessionModel = (CreateSessionRequest)$continuation.L$1;
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl53:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getSessionProcessLauncher(String projectPath, Continuation<? super SessionProcessLauncherExtension> $completion) {
        if (!($completion instanceof getSessionProcessLauncher.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ SessionProcessLauncher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SessionProcessLauncher.access$getSessionProcessLauncher(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$sortedBy$iv = SessionProcessLauncherExtension.Companion.getEP_NAME().getExtensionList();
                $i$f$sortedBy = false;
                var3_8 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        SessionProcessLauncherExtension it = (SessionProcessLauncherExtension)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getPriority());
                        it = (SessionProcessLauncherExtension)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
                    }
                }).iterator();
lbl15:
                // 2 sources

                while (var3_8.hasNext()) {
                    launcher = (SessionProcessLauncherExtension)var3_8.next();
                    $continuation.L$0 = projectPath;
                    $continuation.L$1 = var3_8;
                    $continuation.L$2 = launcher;
                    $continuation.label = 1;
                    v0 = launcher.isApplicable(projectPath, this.project, (Continuation<? super Boolean>)$continuation);
                    if (v0 == var8_5) {
                        return var8_5;
                    }
                    ** GOTO lbl32
                }
                break;
            }
            case 1: {
                launcher = (SessionProcessLauncherExtension)$continuation.L$2;
                var3_8 = (Iterator<E>)$continuation.L$1;
                projectPath = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) ** GOTO lbl15
                return launcher;
            }
        }
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$launchDebugProcess(SessionProcessLauncher $this, String sessionId, CreateSessionRequest sessionModel, ProcessListener sessionProcessEventListener, Lifetime sessionProcessLifetime, String aspireHostRunConfigName, Continuation $completion) {
        return $this.launchDebugProcess(sessionId, sessionModel, sessionProcessEventListener, sessionProcessLifetime, aspireHostRunConfigName, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$launchRunProcess(SessionProcessLauncher $this, String sessionId, CreateSessionRequest sessionModel, ProcessListener sessionProcessEventListener, Lifetime sessionProcessLifetime, String aspireHostRunConfigName, Continuation $completion) {
        return $this.launchRunProcess(sessionId, sessionModel, sessionProcessEventListener, sessionProcessLifetime, aspireHostRunConfigName, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$getSessionProcessLauncher(SessionProcessLauncher $this, String projectPath, Continuation $completion) {
        return $this.getSessionProcessLauncher(projectPath, (Continuation<? super SessionProcessLauncherExtension>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SessionProcessLauncher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/aspire/sessions/SessionProcessLauncher$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/aspire/sessions/SessionProcessLauncher;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nSessionProcessLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionProcessLauncher.kt\ncom/jetbrains/rider/aspire/sessions/SessionProcessLauncher$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,130:1\n30#2,2:131\n*S KotlinDebug\n*F\n+ 1 SessionProcessLauncher.kt\ncom/jetbrains/rider/aspire/sessions/SessionProcessLauncher$Companion\n*L\n22#1:131,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SessionProcessLauncher getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SessionProcessLauncher> serviceClass$iv = SessionProcessLauncher.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SessionProcessLauncher)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SessionLaunchMode.values().length];
            try {
                nArray[SessionLaunchMode.DEBUG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SessionLaunchMode.RUN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

