/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.sessions;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rider.aspire.generated.CreateSessionRequest;
import com.jetbrains.rider.aspire.generated.SessionEnvironmentVariable;
import com.jetbrains.rider.aspire.sessions.RunnableProjectsModelExtensionsKt;
import com.jetbrains.rider.aspire.sessions.SessionEvent;
import com.jetbrains.rider.aspire.sessions.SessionLogReceived;
import com.jetbrains.rider.aspire.sessions.SessionManager;
import com.jetbrains.rider.aspire.sessions.SessionProcessLauncher;
import com.jetbrains.rider.aspire.sessions.SessionStarted;
import com.jetbrains.rider.aspire.sessions.SessionTerminated;
import com.jetbrains.rider.aspire.util.DotNetBuildService;
import com.jetbrains.rider.build.BuildParameters;
import com.jetbrains.rider.build.tasks.BuildTaskThrottler;
import com.jetbrains.rider.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.rider.model.BuildTarget;
import com.jetbrains.rider.model.BuildTargetBase;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.run.ProcessHandlerExKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 &2\u00020\u0001:\u0004&'()B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eJ\u0016\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001aH\u0082@\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0082@\u00a2\u0006\u0002\u0010\u001fJ&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\n2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\r2\u0006\u0010%\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/rider/aspire/sessions/SessionManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "sessionLifetimes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "commands", "Lkotlinx/coroutines/channels/Channel;", "Lcom/jetbrains/rider/aspire/sessions/SessionManager$LaunchSessionCommand;", "submitCommand", "", "command", "handleCommand", "(Lcom/jetbrains/rider/aspire/sessions/SessionManager$LaunchSessionCommand;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleCreateCommand", "Lcom/jetbrains/rider/aspire/sessions/SessionManager$CreateSessionCommand;", "logCreateSessionRequest", "createSessionRequest", "Lcom/jetbrains/rider/aspire/generated/CreateSessionRequest;", "handleDeleteCommand", "Lcom/jetbrains/rider/aspire/sessions/SessionManager$DeleteSessionCommand;", "(Lcom/jetbrains/rider/aspire/sessions/SessionManager$DeleteSessionCommand;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildProject", "projectPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createSessionProcessEventListener", "Lcom/intellij/execution/process/ProcessListener;", "sessionId", "sessionEvents", "Lcom/jetbrains/rider/aspire/sessions/SessionEvent;", "processLifetimeDefinition", "Companion", "LaunchSessionCommand", "CreateSessionCommand", "DeleteSessionCommand", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionManager.kt\ncom/jetbrains/rider/aspire/sessions/SessionManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,216:1\n67#2,4:217\n67#2,4:221\n67#2,4:225\n67#2,4:229\n67#2,4:233\n67#2,4:237\n13#2:241\n*S KotlinDebug\n*F\n+ 1 SessionManager.kt\ncom/jetbrains/rider/aspire/sessions/SessionManager\n*L\n105#1:217,4\n106#1:221,4\n107#1:225,4\n108#1:229,4\n109#1:233,4\n110#1:237,4\n49#1:241\n*E\n"})
public final class SessionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<String, LifetimeDefinition> sessionLifetimes;
    @NotNull
    private final Channel<LaunchSessionCommand> commands;
    @NotNull
    private static final Logger LOG;

    public SessionManager(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.sessionLifetimes = new ConcurrentHashMap();
        this.commands = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ SessionManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = SessionManager.access$getCommands$p(this.this$0).iterator();
lbl6:
                        // 2 sources

                        while (true) {
                            this.L$0 = var2_3;
                            this.L$1 = null;
                            this.label = 1;
                            v0 = var2_3.hasNext((Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl18
                            break;
                        }
                    }
                    case 1: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) break;
                        command = (LaunchSessionCommand)var2_3.next();
                        this.L$0 = var2_3;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)command);
                        this.label = 2;
                        v1 = SessionManager.access$handleCommand(this.this$0, command, (Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        command = (LaunchSessionCommand)this.L$1;
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl32:
                        // 2 sources

                        ** continue;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void submitCommand(@NotNull LaunchSessionCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.commands.trySend-JP2dKIU((Object)command);
    }

    private final Object handleCommand(LaunchSessionCommand command, Continuation<? super Unit> $completion) {
        LaunchSessionCommand launchSessionCommand = command;
        if (launchSessionCommand instanceof CreateSessionCommand) {
            this.handleCreateCommand((CreateSessionCommand)command);
        } else if (launchSessionCommand instanceof DeleteSessionCommand) {
            Object object = this.handleDeleteCommand((DeleteSessionCommand)command, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final void handleCreateCommand(CreateSessionCommand command) {
        LOG.info("Creating session " + command.getSessionId());
        this.logCreateSessionRequest(command.getCreateSessionRequest());
        LifetimeDefinition sessionLifetimeDefinition = command.getAspireHostLifetime().createNested();
        CollectionExKt.put((Map)this.sessionLifetimes, (Lifetime)sessionLifetimeDefinition.getLifetime(), (Object)command.getSessionId(), (Object)sessionLifetimeDefinition);
        LifetimeCoroutineUtilKt.launch$default((Lifetime)sessionLifetimeDefinition.getLifetime(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, command, sessionLifetimeDefinition, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ SessionManager this$0;
            final /* synthetic */ CreateSessionCommand $command;
            final /* synthetic */ LifetimeDefinition $sessionLifetimeDefinition;
            {
                this.this$0 = $receiver;
                this.$command = $command;
                this.$sessionLifetimeDefinition = $sessionLifetimeDefinition;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = Paths.get(this.$command.getCreateSessionRequest().getProjectPath(), new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"get(...)");
                        this.label = 1;
                        v1 = SessionManager.access$buildProject(this.this$0, v0, (Continuation)this);
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        processLauncher = SessionProcessLauncher.Companion.getInstance(SessionManager.access$getProject$p(this.this$0));
                        processLifetimeDefinition = this.$sessionLifetimeDefinition.getLifetime().createNested();
                        sessionProcessListener = SessionManager.access$createSessionProcessEventListener(this.this$0, this.$command.getSessionId(), this.$command.getSessionEvents(), processLifetimeDefinition);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)processLauncher);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)processLifetimeDefinition);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)sessionProcessListener);
                        this.label = 2;
                        v2 = processLauncher.launchSessionProcess(this.$command.getSessionId(), this.$command.getCreateSessionRequest(), sessionProcessListener, processLifetimeDefinition.getLifetime(), this.$command.getAspireHostRunConfigName(), (Continuation<? super Unit>)((Continuation)this));
                        if (v2 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        sessionProcessListener = (ProcessListener)this.L$2;
                        processLifetimeDefinition = (LifetimeDefinition)this.L$1;
                        processLauncher = (SessionProcessLauncher)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl32:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void logCreateSessionRequest(CreateSessionRequest createSessionRequest) {
        Logger logger;
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Session project path: " + createSessionRequest.getProjectPath());
        }
        $this$trace$iv = LOG;
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Session debug flag: " + createSessionRequest.getDebug());
        }
        $this$trace$iv = LOG;
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Session launch profile: " + createSessionRequest.getLaunchProfile());
        }
        $this$trace$iv = LOG;
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Session disable launch profile flag: " + createSessionRequest.getDisableLaunchProfile());
        }
        $this$trace$iv = LOG;
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            Object[] objectArray = createSessionRequest.getArgs();
            logger.trace("Session args: " + (objectArray != null ? ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : null));
        }
        $this$trace$iv = LOG;
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            Object[] objectArray = createSessionRequest.getEnvs();
            logger.trace("Session env keys: " + (objectArray != null ? ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)", ", null, null, (int)0, null, SessionManager::logCreateSessionRequest$lambda$5$0, (int)30, null) : null));
        }
    }

    private final Object handleDeleteCommand(DeleteSessionCommand command, Continuation<? super Unit> $completion) {
        LOG.info("Deleting session " + command.getSessionId());
        LifetimeDefinition sessionLifetimeDefinition = this.sessionLifetimes.remove(command.getSessionId());
        if (sessionLifetimeDefinition == null) {
            LOG.warn("Unable to find session " + command.getSessionId() + " lifetime");
            return Unit.INSTANCE;
        }
        if (RLifetimeKt.isAlive((Lifetime)((Lifetime)sessionLifetimeDefinition))) {
            Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(sessionLifetimeDefinition, command, null){
                int label;
                final /* synthetic */ LifetimeDefinition $sessionLifetimeDefinition;
                final /* synthetic */ DeleteSessionCommand $command;
                {
                    this.$sessionLifetimeDefinition = $sessionLifetimeDefinition;
                    this.$command = $command;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$trace$iv;
                            ResultKt.throwOnFailure((Object)$result);
                            Logger logger = SessionManager.access$getLOG$cp();
                            DeleteSessionCommand deleteSessionCommand = this.$command;
                            boolean $i$f$trace = false;
                            if ($this$trace$iv.isTraceEnabled()) {
                                void var6_5 = $this$trace$iv;
                                boolean bl = false;
                                var6_5.trace("Terminating session " + deleteSessionCommand.getSessionId() + " lifetime");
                            }
                            return Boxing.boxBoolean((boolean)LifetimeDefinition.terminate$default((LifetimeDefinition)this.$sessionLifetimeDefinition, (boolean)false, (int)1, null));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final Object buildProject(Path projectPath, Continuation<? super Unit> $completion) {
        RunnableProject runnableProject = RunnableProjectsModelExtensionsKt.findRunnableProjectByPath$default(projectPath, this.project, null, 4, null);
        if (runnableProject != null) {
            BuildParameters buildParameters = new BuildParameters((BuildTargetBase)new BuildTarget(), CollectionsKt.listOf((Object)((Object)projectPath.toAbsolutePath()).toString()), false, true, false, false, false, 116, null);
            Object object = BuildTaskThrottler.buildSequentially$default((BuildTaskThrottler)BuildTaskThrottler.Companion.getInstance(this.project), (BuildParameters)buildParameters, null, $completion, (int)2, null);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        DotNetBuildService buildService = DotNetBuildService.Companion.getInstance(this.project);
        Object object = buildService.buildProject(projectPath, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final ProcessListener createSessionProcessEventListener(String sessionId, Channel<SessionEvent> sessionEvents, LifetimeDefinition processLifetimeDefinition) {
        return new ProcessListener(sessionId, sessionEvents, processLifetimeDefinition){
            final /* synthetic */ String $sessionId;
            final /* synthetic */ Channel<SessionEvent> $sessionEvents;
            final /* synthetic */ LifetimeDefinition $processLifetimeDefinition;
            {
                this.$sessionId = $sessionId;
                this.$sessionEvents = $sessionEvents;
                this.$processLifetimeDefinition = $processLifetimeDefinition;
            }

            /*
             * WARNING - void declaration
             */
            public void startNotified(ProcessEvent event) {
                Long pid;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                SessionManager.access$getLOG$cp().info("Session " + this.$sessionId + " process was started");
                ProcessHandler processHandler2 = event.getProcessHandler();
                if (processHandler2 instanceof DebuggerWorkerProcessHandler) {
                    v0 = ProcessHandlerExKt.pid((ProcessHandler)((DebuggerWorkerProcessHandler)processHandler2).getDebuggerWorkerRealHandler());
                } else if (processHandler2 != null) {
                    ProcessHandler processHandler3 = event.getProcessHandler();
                    Intrinsics.checkNotNullExpressionValue((Object)processHandler3, (String)"getProcessHandler(...)");
                    v0 = ProcessHandlerExKt.pid((ProcessHandler)processHandler3);
                } else {
                    v0 = pid = null;
                }
                if (pid == null) {
                    SessionManager.access$getLOG$cp().warn("Unable to determine process id for the session " + this.$sessionId);
                    this.terminateSession(-1);
                } else {
                    void $this$trace$iv;
                    processHandler2 = SessionManager.access$getLOG$cp();
                    String string = this.$sessionId;
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        void var7_6 = $this$trace$iv;
                        boolean bl = false;
                        var7_6.trace("Session " + string + " process id = " + pid);
                    }
                    Object eventSendingResult = this.$sessionEvents.trySend-JP2dKIU((Object)new SessionStarted(this.$sessionId, pid));
                    if (!ChannelResult.isSuccess-impl((Object)eventSendingResult)) {
                        SessionManager.access$getLOG$cp().warn("Unable to send an event for session " + this.$sessionId + " start");
                    }
                }
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType2) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType2, (String)"outputType");
                boolean isStdErr = Intrinsics.areEqual(outputType2, (Object)ProcessOutputType.STDERR);
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                Object eventSendingResult = this.$sessionEvents.trySend-JP2dKIU((Object)new SessionLogReceived(this.$sessionId, isStdErr, string));
                if (!ChannelResult.isSuccess-impl((Object)eventSendingResult)) {
                    SessionManager.access$getLOG$cp().warn("Unable to send an event for session " + this.$sessionId + " log");
                }
            }

            public void processNotStarted() {
                SessionManager.access$getLOG$cp().warn("Session " + this.$sessionId + " process is not started");
                this.terminateSession(-1);
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                SessionManager.access$getLOG$cp().info("Session " + this.$sessionId + " process was terminated (" + event.getExitCode() + ", " + event.getText() + ")");
                this.terminateSession(event.getExitCode());
            }

            /*
             * WARNING - void declaration
             */
            private final void terminateSession(int exitCode) {
                void $this$trace$iv;
                Logger logger = SessionManager.access$getLOG$cp();
                String string = this.$sessionId;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    void var6_5 = $this$trace$iv;
                    boolean bl = false;
                    var6_5.trace("Terminating session " + string + " with exitCode " + exitCode);
                }
                Object eventSendingResult = this.$sessionEvents.trySend-JP2dKIU((Object)new SessionTerminated(this.$sessionId, exitCode));
                if (!ChannelResult.isSuccess-impl((Object)eventSendingResult)) {
                    SessionManager.access$getLOG$cp().warn("Unable to send an event for session " + this.$sessionId + " termination");
                }
                if (RLifetimeKt.isAlive((Lifetime)((Lifetime)this.$processLifetimeDefinition))) {
                    ApplicationKt.getApplication().invokeLater(() -> createSessionProcessEventListener.1.terminateSession$lambda$2(this.$processLifetimeDefinition, this.$sessionId));
                }
            }

            private static final void terminateSession$lambda$2(LifetimeDefinition $processLifetimeDefinition, String $sessionId) {
                Logger $this$trace$iv = SessionManager.access$getLOG$cp();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Terminating session " + $sessionId + " lifetime");
                }
                LifetimeDefinition.terminate$default((LifetimeDefinition)$processLifetimeDefinition, (boolean)false, (int)1, null);
            }
        };
    }

    private static final CharSequence logCreateSessionRequest$lambda$5$0(SessionEnvironmentVariable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey();
    }

    public static final /* synthetic */ Object access$handleCommand(SessionManager $this, LaunchSessionCommand command, Continuation $completion) {
        return $this.handleCommand(command, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$buildProject(SessionManager $this, Path projectPath, Continuation $completion) {
        return $this.buildProject(projectPath, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Project access$getProject$p(SessionManager $this) {
        return $this.project;
    }

    public static final /* synthetic */ ProcessListener access$createSessionProcessEventListener(SessionManager $this, String sessionId, Channel sessionEvents, LifetimeDefinition processLifetimeDefinition) {
        return $this.createSessionProcessEventListener(sessionId, (Channel<SessionEvent>)sessionEvents, processLifetimeDefinition);
    }

    public static final /* synthetic */ Object access$handleDeleteCommand(SessionManager $this, DeleteSessionCommand command, Continuation $completion) {
        return $this.handleDeleteCommand(command, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Channel access$getCommands$p(SessionManager $this) {
        return $this.commands;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SessionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/aspire/sessions/SessionManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/aspire/sessions/SessionManager;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionManager.kt\ncom/jetbrains/rider/aspire/sessions/SessionManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,216:1\n30#2,2:217\n*S KotlinDebug\n*F\n+ 1 SessionManager.kt\ncom/jetbrains/rider/aspire/sessions/SessionManager$Companion\n*L\n47#1:217,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SessionManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SessionManager> serviceClass$iv = SessionManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SessionManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u000bH\u00c6\u0003JC\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/aspire/sessions/SessionManager$CreateSessionCommand;", "Lcom/jetbrains/rider/aspire/sessions/SessionManager$LaunchSessionCommand;", "sessionId", "", "createSessionRequest", "Lcom/jetbrains/rider/aspire/generated/CreateSessionRequest;", "sessionEvents", "Lkotlinx/coroutines/channels/Channel;", "Lcom/jetbrains/rider/aspire/sessions/SessionEvent;", "aspireHostRunConfigName", "aspireHostLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rider/aspire/generated/CreateSessionRequest;Lkotlinx/coroutines/channels/Channel;Ljava/lang/String;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getSessionId", "()Ljava/lang/String;", "getCreateSessionRequest", "()Lcom/jetbrains/rider/aspire/generated/CreateSessionRequest;", "getSessionEvents", "()Lkotlinx/coroutines/channels/Channel;", "getAspireHostRunConfigName", "getAspireHostLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "aspire-plugin"})
    public static final class CreateSessionCommand
    implements LaunchSessionCommand {
        @NotNull
        private final String sessionId;
        @NotNull
        private final CreateSessionRequest createSessionRequest;
        @NotNull
        private final Channel<SessionEvent> sessionEvents;
        @Nullable
        private final String aspireHostRunConfigName;
        @NotNull
        private final Lifetime aspireHostLifetime;

        public CreateSessionCommand(@NotNull String sessionId, @NotNull CreateSessionRequest createSessionRequest, @NotNull Channel<SessionEvent> sessionEvents, @Nullable String aspireHostRunConfigName, @NotNull Lifetime aspireHostLifetime) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)createSessionRequest, (String)"createSessionRequest");
            Intrinsics.checkNotNullParameter(sessionEvents, (String)"sessionEvents");
            Intrinsics.checkNotNullParameter((Object)aspireHostLifetime, (String)"aspireHostLifetime");
            this.sessionId = sessionId;
            this.createSessionRequest = createSessionRequest;
            this.sessionEvents = sessionEvents;
            this.aspireHostRunConfigName = aspireHostRunConfigName;
            this.aspireHostLifetime = aspireHostLifetime;
        }

        @NotNull
        public final String getSessionId() {
            return this.sessionId;
        }

        @NotNull
        public final CreateSessionRequest getCreateSessionRequest() {
            return this.createSessionRequest;
        }

        @NotNull
        public final Channel<SessionEvent> getSessionEvents() {
            return this.sessionEvents;
        }

        @Nullable
        public final String getAspireHostRunConfigName() {
            return this.aspireHostRunConfigName;
        }

        @NotNull
        public final Lifetime getAspireHostLifetime() {
            return this.aspireHostLifetime;
        }

        @NotNull
        public final String component1() {
            return this.sessionId;
        }

        @NotNull
        public final CreateSessionRequest component2() {
            return this.createSessionRequest;
        }

        @NotNull
        public final Channel<SessionEvent> component3() {
            return this.sessionEvents;
        }

        @Nullable
        public final String component4() {
            return this.aspireHostRunConfigName;
        }

        @NotNull
        public final Lifetime component5() {
            return this.aspireHostLifetime;
        }

        @NotNull
        public final CreateSessionCommand copy(@NotNull String sessionId, @NotNull CreateSessionRequest createSessionRequest, @NotNull Channel<SessionEvent> sessionEvents, @Nullable String aspireHostRunConfigName, @NotNull Lifetime aspireHostLifetime) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)createSessionRequest, (String)"createSessionRequest");
            Intrinsics.checkNotNullParameter(sessionEvents, (String)"sessionEvents");
            Intrinsics.checkNotNullParameter((Object)aspireHostLifetime, (String)"aspireHostLifetime");
            return new CreateSessionCommand(sessionId, createSessionRequest, sessionEvents, aspireHostRunConfigName, aspireHostLifetime);
        }

        public static /* synthetic */ CreateSessionCommand copy$default(CreateSessionCommand createSessionCommand, String string, CreateSessionRequest createSessionRequest, Channel channel, String string2, Lifetime lifetime, int n, Object object) {
            if ((n & 1) != 0) {
                string = createSessionCommand.sessionId;
            }
            if ((n & 2) != 0) {
                createSessionRequest = createSessionCommand.createSessionRequest;
            }
            if ((n & 4) != 0) {
                channel = createSessionCommand.sessionEvents;
            }
            if ((n & 8) != 0) {
                string2 = createSessionCommand.aspireHostRunConfigName;
            }
            if ((n & 0x10) != 0) {
                lifetime = createSessionCommand.aspireHostLifetime;
            }
            return createSessionCommand.copy(string, createSessionRequest, channel, string2, lifetime);
        }

        @NotNull
        public String toString() {
            return "CreateSessionCommand(sessionId=" + this.sessionId + ", createSessionRequest=" + this.createSessionRequest + ", sessionEvents=" + this.sessionEvents + ", aspireHostRunConfigName=" + this.aspireHostRunConfigName + ", aspireHostLifetime=" + this.aspireHostLifetime + ")";
        }

        public int hashCode() {
            int result = this.sessionId.hashCode();
            result = result * 31 + this.createSessionRequest.hashCode();
            result = result * 31 + this.sessionEvents.hashCode();
            result = result * 31 + (this.aspireHostRunConfigName == null ? 0 : this.aspireHostRunConfigName.hashCode());
            result = result * 31 + this.aspireHostLifetime.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CreateSessionCommand)) {
                return false;
            }
            CreateSessionCommand createSessionCommand = (CreateSessionCommand)other;
            if (!Intrinsics.areEqual((Object)this.sessionId, (Object)createSessionCommand.sessionId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.createSessionRequest, (Object)createSessionCommand.createSessionRequest)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.sessionEvents, createSessionCommand.sessionEvents)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.aspireHostRunConfigName, (Object)createSessionCommand.aspireHostRunConfigName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.aspireHostLifetime, (Object)createSessionCommand.aspireHostLifetime);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/aspire/sessions/SessionManager$DeleteSessionCommand;", "Lcom/jetbrains/rider/aspire/sessions/SessionManager$LaunchSessionCommand;", "sessionId", "", "<init>", "(Ljava/lang/String;)V", "getSessionId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "aspire-plugin"})
    public static final class DeleteSessionCommand
    implements LaunchSessionCommand {
        @NotNull
        private final String sessionId;

        public DeleteSessionCommand(@NotNull String sessionId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            this.sessionId = sessionId;
        }

        @NotNull
        public final String getSessionId() {
            return this.sessionId;
        }

        @NotNull
        public final String component1() {
            return this.sessionId;
        }

        @NotNull
        public final DeleteSessionCommand copy(@NotNull String sessionId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            return new DeleteSessionCommand(sessionId);
        }

        public static /* synthetic */ DeleteSessionCommand copy$default(DeleteSessionCommand deleteSessionCommand, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = deleteSessionCommand.sessionId;
            }
            return deleteSessionCommand.copy(string);
        }

        @NotNull
        public String toString() {
            return "DeleteSessionCommand(sessionId=" + this.sessionId + ")";
        }

        public int hashCode() {
            return this.sessionId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeleteSessionCommand)) {
                return false;
            }
            DeleteSessionCommand deleteSessionCommand = (DeleteSessionCommand)other;
            return Intrinsics.areEqual((Object)this.sessionId, (Object)deleteSessionCommand.sessionId);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002\u00c0\u0006\u0003"}, d2={"Lcom/jetbrains/rider/aspire/sessions/SessionManager$LaunchSessionCommand;", "", "aspire-plugin"})
    public static interface LaunchSessionCommand {
    }
}

