/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.run.states;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.aspire.run.states.AspireHostProfileState;
import com.jetbrains.rider.aspire.run.states.AspireHostProfileStateUtilsKt;
import com.jetbrains.rider.run.ConsoleKind;
import com.jetbrains.rider.run.DotNetProcessRunProfileStateKt;
import com.jetbrains.rider.run.TerminalProcessHandler;
import com.jetbrains.rider.runtime.DotNetExecutable;
import com.jetbrains.rider.runtime.DotNetRuntime;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/aspire/run/states/AspireHostRunProfileState;", "Lcom/intellij/execution/configurations/RunProfileState;", "Lcom/jetbrains/rider/aspire/run/states/AspireHostProfileState;", "dotnetExecutable", "Lcom/jetbrains/rider/runtime/DotNetExecutable;", "dotnetRuntime", "Lcom/jetbrains/rider/runtime/dotNetCore/DotNetCoreRuntime;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "<init>", "(Lcom/jetbrains/rider/runtime/DotNetExecutable;Lcom/jetbrains/rider/runtime/dotNetCore/DotNetCoreRuntime;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "environmentVariables", "", "", "getEnvironmentVariables", "()Ljava/util/Map;", "containerRuntimeNotificationCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "execute", "Lcom/intellij/execution/ExecutionResult;", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "aspire-plugin"})
public final class AspireHostRunProfileState
implements RunProfileState,
AspireHostProfileState {
    @NotNull
    private final DotNetExecutable dotnetExecutable;
    @NotNull
    private final DotNetCoreRuntime dotnetRuntime;
    @NotNull
    private final ExecutionEnvironment environment;
    @NotNull
    private final Map<String, String> environmentVariables;
    @NotNull
    private final AtomicInteger containerRuntimeNotificationCount;

    public AspireHostRunProfileState(@NotNull DotNetExecutable dotnetExecutable, @NotNull DotNetCoreRuntime dotnetRuntime, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)dotnetExecutable, (String)"dotnetExecutable");
        Intrinsics.checkNotNullParameter((Object)dotnetRuntime, (String)"dotnetRuntime");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.dotnetExecutable = dotnetExecutable;
        this.dotnetRuntime = dotnetRuntime;
        this.environment = environment;
        this.environmentVariables = this.dotnetExecutable.getEnvironmentVariables();
        this.containerRuntimeNotificationCount = new AtomicInteger();
    }

    @Override
    @NotNull
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @NotNull
    public ExecutionResult execute(@Nullable Executor executor, @NotNull ProgramRunner<?> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        this.dotnetExecutable.validate();
        GeneralCommandLine commandLine = DotNetProcessRunProfileStateKt.createRunCommandLine((DotNetExecutable)this.dotnetExecutable, (DotNetRuntime)((DotNetRuntime)this.dotnetRuntime));
        String string = commandLine.getExePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path originalExecutable = path;
        Project project = this.environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TerminalProcessHandler processHandler2 = new TerminalProcessHandler(project, commandLine, commandLine.getCommandLineString(), false, null, originalExecutable, 24, null);
        ProcessHandler processHandler3 = (ProcessHandler)processHandler2;
        Project project2 = this.environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        AspireHostProfileStateUtilsKt.addStoppedContainerRuntimeProcessListener(processHandler3, this.containerRuntimeNotificationCount, project2);
        ProcessHandler processHandler4 = (ProcessHandler)processHandler2;
        Project project3 = this.environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        ConsoleView console = DotNetProcessRunProfileStateKt.createConsole$default((ConsoleKind)ConsoleKind.Normal, (ProcessHandler)processHandler4, (Project)project3, null, (int)8, null);
        Function3 function3 = this.dotnetExecutable.getOnBeforeProcessStarted();
        RunProfile runProfile = this.environment.getRunProfile();
        Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
        function3.invoke((Object)this.environment, (Object)runProfile, (Object)processHandler2);
        return (ExecutionResult)new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler2);
    }
}

