/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.run;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.aspire.run.AspireHostConfigurationParameters;
import com.jetbrains.rider.aspire.run.AspireHostExecutorFactory;
import com.jetbrains.rider.aspire.run.AspireHostSettingsEditor;
import com.jetbrains.rider.run.configurations.AsyncExecutorFactory;
import com.jetbrains.rider.run.configurations.IAutoSelectableRunConfiguration;
import com.jetbrains.rider.run.configurations.IProjectBasedRunConfiguration;
import com.jetbrains.rider.run.configurations.RiderAsyncRunConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\tH\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/aspire/run/AspireHostConfiguration;", "Lcom/jetbrains/rider/run/configurations/RiderAsyncRunConfiguration;", "Lcom/jetbrains/rider/run/configurations/IProjectBasedRunConfiguration;", "Lcom/jetbrains/rider/run/configurations/IAutoSelectableRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "parameters", "Lcom/jetbrains/rider/aspire/run/AspireHostConfigurationParameters;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;Lcom/jetbrains/rider/aspire/run/AspireHostConfigurationParameters;)V", "getParameters", "()Lcom/jetbrains/rider/aspire/run/AspireHostConfigurationParameters;", "checkConfiguration", "", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "clone", "Lcom/intellij/execution/configurations/RunConfiguration;", "getAutoSelectPriority", "", "getProjectFilePath", "setProjectFilePath", "path", "aspire-plugin"})
public final class AspireHostConfiguration
extends RiderAsyncRunConfiguration
implements IProjectBasedRunConfiguration,
IAutoSelectableRunConfiguration {
    @NotNull
    private final AspireHostConfigurationParameters parameters;

    public AspireHostConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name, @NotNull AspireHostConfigurationParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        super(name, project, factory, AspireHostConfiguration::_init_$lambda$0, (AsyncExecutorFactory)new AspireHostExecutorFactory(project, parameters));
        this.parameters = parameters;
    }

    @NotNull
    public final AspireHostConfigurationParameters getParameters() {
        return this.parameters;
    }

    public void checkConfiguration() {
        this.parameters.validate();
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        this.parameters.readExternal(element);
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        this.parameters.writeExternal(element);
    }

    @NotNull
    public RunConfiguration clone() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ConfigurationFactory configurationFactory = this.getFactory();
        if (configurationFactory == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        AspireHostConfiguration newConfiguration = new AspireHostConfiguration(project, configurationFactory, string, this.parameters.copy());
        newConfiguration.doCopyOptionsFrom((RunConfigurationBase)this);
        return (RunConfiguration)newConfiguration;
    }

    public int getAutoSelectPriority() {
        return 10;
    }

    @NotNull
    public String getProjectFilePath() {
        return this.parameters.getProjectFilePath();
    }

    public void setProjectFilePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.parameters.setProjectFilePath(path);
    }

    private static final SettingsEditor _init_$lambda$0(Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (SettingsEditor)new AspireHostSettingsEditor(it);
    }
}

