/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.orchestration;

import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.jetbrains.rider.aspire.util.RdProjectDescriptorExtensionsKt;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectType;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"supportedProjectTypes", "", "Lcom/jetbrains/rider/model/RdProjectType;", "isAspireOrchestrationSupported", "", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "aspire-plugin"})
public final class AspireOrchestrationUtilsKt {
    @NotNull
    private static final List<RdProjectType> supportedProjectTypes;

    public static final boolean isAspireOrchestrationSupported(@NotNull ProjectModelEntity $this$isAspireOrchestrationSupported) {
        Intrinsics.checkNotNullParameter((Object)$this$isAspireOrchestrationSupported, (String)"<this>");
        if (RdProjectDescriptorExtensionsKt.isAspireHostProject($this$isAspireOrchestrationSupported) || RdProjectDescriptorExtensionsKt.isAspireSharedProject($this$isAspireOrchestrationSupported)) {
            return false;
        }
        RdProjectModelItemDescriptor entityDescriptor = $this$isAspireOrchestrationSupported.getDescriptor();
        if (!(entityDescriptor instanceof RdProjectDescriptor)) {
            return false;
        }
        Object object = $this$isAspireOrchestrationSupported.getUrl();
        if (object == null || (object = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object)) == null || (object = object.getExtension()) == null) {
            return false;
        }
        Object extension = object;
        if (!Intrinsics.areEqual((Object)extension, (Object)"csproj") && !Intrinsics.areEqual((Object)extension, (Object)"fsproj")) {
            return false;
        }
        RdProjectType type = ((RdProjectDescriptor)entityDescriptor).getSpecificType();
        if (!supportedProjectTypes.contains(type)) {
            return false;
        }
        return ((RdProjectDescriptor)entityDescriptor).isDotNetCore();
    }

    static {
        Object[] objectArray = new RdProjectType[]{RdProjectType.Default, RdProjectType.Web, RdProjectType.XamlProject, RdProjectType.MAUI};
        supportedProjectTypes = CollectionsKt.listOf((Object[])objectArray);
    }
}

