/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.orchestration;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rider.aspire.AspireBundle;
import com.jetbrains.rider.aspire.orchestration.AspireDefaultFileModificationService;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.IndenterRulesSet;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.IndentingLogger;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.TextContent;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.TreeWalker;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.PsiTreeWalker;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.RiderTextContent;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.session.CsIndentingNaiveRulesSetKt;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.session.RiderIndentingEditorSettings;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.session.RiderIndentingEditorSettingsKt;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectType;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0086@\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u0002J*\u0010\u0012\u001a\u00020\u00072\u001a\u0010\u0002\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00130\u000bH\u0086@\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0007H\u0082@\u00a2\u0006\u0002\u0010\u0019J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J \u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/rider/aspire/orchestration/AspireDefaultFileModificationService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "insertProjectsIntoAppHostFile", "", "hostProjectPath", "Ljava/nio/file/Path;", "projects", "", "(Ljava/nio/file/Path;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAppHostFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createAddProjectMethodsToInsert", "", "projectNames", "insertAspireDefaultMethodsIntoProjects", "Lkotlin/Pair;", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertAspireDefaultMethodsIntoProgramFile", "programFile", "isWebProject", "(Lcom/intellij/openapi/vfs/VirtualFile;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findSemicolonIndexAfterMethod", "", "text", "methodToInsert", "insertAfterMethod", "calculateIndent", "psiFile", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "Companion", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nAspireDefaultFileModificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspireDefaultFileModificationService.kt\ncom/jetbrains/rider/aspire/orchestration/AspireDefaultFileModificationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,285:1\n1563#2:286\n1634#2,3:287\n13#3:290\n*S KotlinDebug\n*F\n+ 1 AspireDefaultFileModificationService.kt\ncom/jetbrains/rider/aspire/orchestration/AspireDefaultFileModificationService\n*L\n71#1:286\n71#1:287,3\n42#1:290\n*E\n"})
public final class AspireDefaultFileModificationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String APP_HOST_FILE = "AppHost.cs";
    @NotNull
    private static final String PROGRAM_FILE = "Program.cs";
    @NotNull
    private static final String MAUI_PROGRAM_FILE = "MauiProgram.cs";
    @NotNull
    private static final String ADD_PROJECT_METHOD = ".AddProject(";
    @NotNull
    private static final String CREATE_BUILDER_METHOD = ".CreateBuilder(";
    @NotNull
    private static final String CREATE_APPLICATION_BUILDER_METHOD = ".CreateApplicationBuilder(";
    @NotNull
    private static final String BUILD_METHOD = ".Build(";
    @NotNull
    private static final String ADD_SERVICE_DEFAULTS_METHOD = "builder.AddServiceDefaults();";
    @NotNull
    private static final String MAP_DEFAULT_ENDPOINTS = "app.MapDefaultEndpoints();";

    public AspireDefaultFileModificationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object insertProjectsIntoAppHostFile(@NotNull Path hostProjectPath, @NotNull List<? extends Path> projects, @NotNull Continuation<? super Boolean> $completion) {
        void $this$mapTo$iv$iv;
        if (projects.isEmpty()) {
            return Boxing.boxBoolean((boolean)false);
        }
        VirtualFile appHostFile = this.findAppHostFile(hostProjectPath);
        if (appHostFile == null) {
            LOG.warn("Unable to find AppHost.cs (or Program.cs) file in the host project");
            return Boxing.boxBoolean((boolean)false);
        }
        Iterable $this$map$iv = projects;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PathsKt.getNameWithoutExtension((Path)it));
        }
        List projectNames = (List)destination$iv$iv;
        List<String> methodsToInsert = this.createAddProjectMethodsToInsert(projectNames);
        if (methodsToInsert.isEmpty()) {
            return Boxing.boxBoolean((boolean)false);
        }
        return CoroutinesKt.readAndEdtWriteAction(arg_0 -> AspireDefaultFileModificationService.insertProjectsIntoAppHostFile$lambda$1(appHostFile, this, methodsToInsert, arg_0), $completion);
    }

    private final VirtualFile findAppHostFile(Path hostProjectPath) {
        Path appHostFilePath = hostProjectPath.getParent().resolve(APP_HOST_FILE);
        Intrinsics.checkNotNull((Object)appHostFilePath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(appHostFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return VirtualFileManager.getInstance().findFileByNioPath(appHostFilePath);
        }
        Path programFilePath = hostProjectPath.getParent().resolve(PROGRAM_FILE);
        Intrinsics.checkNotNull((Object)programFilePath);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.exists(programFilePath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            return VirtualFileManager.getInstance().findFileByNioPath(programFilePath);
        }
        return null;
    }

    private final List<String> createAddProjectMethodsToInsert(List<String> projectNames) {
        List list;
        List $this$createAddProjectMethodsToInsert_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (String projectName : CollectionsKt.sorted((Iterable)projectNames)) {
            String projectResourceName;
            StringBuilder stringBuilder;
            String projectType = StringsKt.replace$default((String)projectName, (char)'.', (char)'_', (boolean)false, (int)4, null);
            Intrinsics.checkNotNullExpressionValue((Object)StringsKt.replace$default((String)projectName, (char)'.', (char)'-', (boolean)false, (int)4, null).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            StringBuilder $this$createAddProjectMethodsToInsert_u24lambda_u240_u240 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$createAddProjectMethodsToInsert_u24lambda_u240_u240.append("builder.AddProject<Projects.");
            $this$createAddProjectMethodsToInsert_u24lambda_u240_u240.append(projectType);
            $this$createAddProjectMethodsToInsert_u24lambda_u240_u240.append(">(\"");
            $this$createAddProjectMethodsToInsert_u24lambda_u240_u240.append(projectResourceName);
            $this$createAddProjectMethodsToInsert_u24lambda_u240_u240.append("\");");
            String methodToInsert = stringBuilder.toString();
            $this$createAddProjectMethodsToInsert_u24lambda_u240.add(methodToInsert);
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object insertAspireDefaultMethodsIntoProjects(@NotNull List<? extends Pair<? extends Path, ? extends ProjectModelEntity>> project, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof insertAspireDefaultMethodsIntoProjects.1)) ** GOTO lbl-1000
        var16_3 = $completion;
        if ((var16_3.label & -2147483648) != 0) {
            var16_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                final /* synthetic */ AspireDefaultFileModificationService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.insertAspireDefaultMethodsIntoProjects(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (project.isEmpty()) {
                    return Boxing.boxBoolean((boolean)false);
                }
                methodsWereInserted = 0;
                var4_7 = project.iterator();
lbl16:
                // 4 sources

                while (var4_7.hasNext()) {
                    var5_8 = var4_7.next();
                    projectFilePath = (Path)var5_8.component1();
                    v0 = projectEntity = (ProjectModelEntity)var5_8.component2();
                    descriptor = v0 != null ? v0.getDescriptor() : null;
                    v1 = descriptor instanceof RdProjectDescriptor != false ? (RdProjectDescriptor)descriptor : null;
                    projectType = v1 != null ? v1.getSpecificType() : null;
                    isWebProject = projectType == RdProjectType.Web ? 1 : 0;
                    isMauiProject = projectType == RdProjectType.MAUI ? 1 : 0;
                    projectProgramFilePath = isMauiProject == 0 ? projectFilePath.getParent().resolve("Program.cs") : projectFilePath.getParent().resolve("MauiProgram.cs");
                    Intrinsics.checkNotNull((Object)projectProgramFilePath);
                    v2 = new LinkOption[]{};
                    if (!Files.exists(projectProgramFilePath, Arrays.copyOf(v2, v2.length))) {
                        AspireDefaultFileModificationService.LOG.info("Unable to find Program.cs file for a project " + PathsKt.getName((Path)projectFilePath));
                        continue;
                    }
                    projectProgramFile = VirtualFileManager.getInstance().findFileByNioPath(projectProgramFilePath);
                    if (projectProgramFile == null) {
                        AspireDefaultFileModificationService.LOG.warn("Unable to find Program.cs virtual file for a project " + PathsKt.getName((Path)projectFilePath));
                        continue;
                    }
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = var4_7;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)projectFilePath);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)projectEntity);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)descriptor);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)projectType);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)projectProgramFilePath);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)projectProgramFile);
                    $continuation.I$0 = methodsWereInserted;
                    $continuation.I$1 = isWebProject;
                    $continuation.I$2 = isMauiProject;
                    $continuation.label = 1;
                    v3 = this.insertAspireDefaultMethodsIntoProgramFile(projectProgramFile, isWebProject != 0, (Continuation<? super Boolean>)$continuation);
                    if (v3 == var17_5) {
                        return var17_5;
                    }
                    ** GOTO lbl66
                }
                break;
            }
            case 1: {
                isMauiProject = $continuation.I$2;
                isWebProject = $continuation.I$1;
                methodsWereInserted = $continuation.I$0;
                projectProgramFile = (VirtualFile)$continuation.L$7;
                projectProgramFilePath = (Path)$continuation.L$6;
                projectType = (RdProjectType)$continuation.L$5;
                descriptor = (RdProjectModelItemDescriptor)$continuation.L$4;
                projectEntity = (ProjectModelEntity)$continuation.L$3;
                projectFilePath = (Path)$continuation.L$2;
                var4_7 = (Iterator)$continuation.L$1;
                project = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl66:
                // 2 sources

                insertionResult = (Boolean)v3;
                methodsWereInserted = methodsWereInserted != 0 || insertionResult != false ? 1 : 0;
                ** GOTO lbl16
            }
        }
        return Boxing.boxBoolean((boolean)(methodsWereInserted != 0));
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object insertAspireDefaultMethodsIntoProgramFile(VirtualFile programFile, boolean isWebProject, Continuation<? super Boolean> $completion) {
        return CoroutinesKt.readAndEdtWriteAction(arg_0 -> AspireDefaultFileModificationService.insertAspireDefaultMethodsIntoProgramFile$lambda$0(programFile, this, isWebProject, arg_0), $completion);
    }

    private final int findSemicolonIndexAfterMethod(String text, String methodToInsert, String insertAfterMethod) {
        if (StringsKt.contains$default((CharSequence)text, (CharSequence)methodToInsert, (boolean)false, (int)2, null)) {
            return -1;
        }
        int methodIndex = StringsKt.indexOf$default((CharSequence)text, (String)insertAfterMethod, (int)0, (boolean)false, (int)6, null);
        if (methodIndex == -1) {
            LOG.warn("Unable to find " + insertAfterMethod + " method in the `Porgram.cs` file");
            return -1;
        }
        return StringsKt.indexOf$default((CharSequence)text, (char)';', (int)methodIndex, (boolean)false, (int)4, null);
    }

    private final String calculateIndent(PsiFile psiFile, Document document, int offset) {
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.project);
        manager.commitDocument(document);
        PsiTreeWalker treeWalker = new PsiTreeWalker((PsiElement)psiFile);
        RiderTextContent riderTextContent = new RiderTextContent(document);
        RiderIndentingEditorSettings indentSettings = RiderIndentingEditorSettings.Companion.getUserDefinedSettings(psiFile, psiFile.getLanguage());
        List indents = RiderIndentingEditorSettingsKt.calculateCsIndent((IndenterRulesSet)CsIndentingNaiveRulesSetKt.getCsIndentingNaiveRulesSet(), (TreeWalker)((TreeWalker)treeWalker), (TextContent)((TextContent)riderTextContent), (long)offset, (long)((long)offset + 1L), (RiderIndentingEditorSettings)indentSettings, (IndentingLogger)((IndentingLogger)new VerboseIndentingLogger()));
        Object object = indents;
        if (object == null || (object = (String)CollectionsKt.firstOrNull((List)object)) == null) {
            object = "";
        }
        return object;
    }

    private static final ReadResult insertProjectsIntoAppHostFile$lambda$1(VirtualFile $appHostFile, AspireDefaultFileModificationService this$0, List $methodsToInsert, ReadAndWriteScope $this$readAndEdtWriteAction) {
        Intrinsics.checkNotNullParameter((Object)$this$readAndEdtWriteAction, (String)"$this$readAndEdtWriteAction");
        Document document = VirtualFileUtil.findDocument((VirtualFile)$appHostFile);
        if (document == null) {
            LOG.warn("Unable to find AppHost.cs (or Program.cs) file document");
            return $this$readAndEdtWriteAction.value((Object)false);
        }
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        int lastAddProjectIndex = StringsKt.lastIndexOf$default((CharSequence)text, (String)ADD_PROJECT_METHOD, (int)0, (boolean)false, (int)6, null);
        Ref.IntRef semicolonIndex = new Ref.IntRef();
        if (lastAddProjectIndex == -1) {
            int builderIndex = StringsKt.indexOf$default((CharSequence)text, (String)CREATE_BUILDER_METHOD, (int)0, (boolean)false, (int)6, null);
            if (builderIndex == -1) {
                LOG.info("Unable to find a method for creating a distributed builder");
                return $this$readAndEdtWriteAction.value((Object)false);
            }
            v1 = StringsKt.indexOf$default((CharSequence)text, (char)';', (int)builderIndex, (boolean)false, (int)4, null);
        } else {
            v1 = semicolonIndex.element = StringsKt.indexOf$default((CharSequence)text, (char)';', (int)lastAddProjectIndex, (boolean)false, (int)4, null);
        }
        if (semicolonIndex.element == -1) {
            LOG.info("Unable to find an index to insert an `AddProject` method");
            return $this$readAndEdtWriteAction.value((Object)false);
        }
        PsiFile psiFile = VirtualFileUtil.findPsiFile((VirtualFile)$appHostFile, (Project)this$0.project);
        return com.intellij.openapi.command.CoroutinesKt.writeCommandAction((ReadAndWriteScope)$this$readAndEdtWriteAction, (Project)this$0.project, (String)AspireBundle.message("write.command.insert.into.app.host", new Object[0]), () -> AspireDefaultFileModificationService.insertProjectsIntoAppHostFile$lambda$1$0(psiFile, this$0, document, semicolonIndex, $methodsToInsert, text));
    }

    private static final boolean insertProjectsIntoAppHostFile$lambda$1$0(PsiFile $psiFile, AspireDefaultFileModificationService this$0, Document $document, Ref.IntRef $semicolonIndex, List $methodsToInsert, String $text) {
        PsiFile psiFile = $psiFile;
        String indent = psiFile != null ? this$0.calculateIndent(psiFile, $document, $semicolonIndex.element) : "";
        boolean methodsWereInserted = false;
        for (String methodToInsert : $methodsToInsert) {
            StringBuilder stringBuilder;
            if (StringsKt.contains$default((CharSequence)$text, (CharSequence)methodToInsert, (boolean)false, (int)2, null)) continue;
            StringBuilder $this$insertProjectsIntoAppHostFile_u24lambda_u241_u240_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$insertProjectsIntoAppHostFile_u24lambda_u241_u240_u240.append('\n');
            $this$insertProjectsIntoAppHostFile_u24lambda_u241_u240_u240.append('\n');
            $this$insertProjectsIntoAppHostFile_u24lambda_u241_u240_u240.append(indent);
            $this$insertProjectsIntoAppHostFile_u24lambda_u241_u240_u240.append(methodToInsert);
            String textToInsert = stringBuilder.toString();
            $document.insertString($semicolonIndex.element + 1, (CharSequence)textToInsert);
            $semicolonIndex.element += textToInsert.length();
            methodsWereInserted = true;
        }
        return methodsWereInserted;
    }

    private static final ReadResult insertAspireDefaultMethodsIntoProgramFile$lambda$0(VirtualFile $programFile, AspireDefaultFileModificationService this$0, boolean $isWebProject, ReadAndWriteScope $this$readAndEdtWriteAction) {
        int defaultEndpointsIndex;
        Intrinsics.checkNotNullParameter((Object)$this$readAndEdtWriteAction, (String)"$this$readAndEdtWriteAction");
        Document document = VirtualFileUtil.findDocument((VirtualFile)$programFile);
        if (document == null) {
            LOG.warn("Unable to find Program.cs file document");
            return $this$readAndEdtWriteAction.value((Object)false);
        }
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        Ref.IntRef serviceDefaultsIndex = new Ref.IntRef();
        serviceDefaultsIndex.element = this$0.findSemicolonIndexAfterMethod(text, ADD_SERVICE_DEFAULTS_METHOD, CREATE_BUILDER_METHOD);
        if (serviceDefaultsIndex.element == -1) {
            serviceDefaultsIndex.element = this$0.findSemicolonIndexAfterMethod(text, ADD_SERVICE_DEFAULTS_METHOD, CREATE_APPLICATION_BUILDER_METHOD);
        }
        int n = defaultEndpointsIndex = $isWebProject ? this$0.findSemicolonIndexAfterMethod(text, MAP_DEFAULT_ENDPOINTS, BUILD_METHOD) : -1;
        if (serviceDefaultsIndex.element == -1 && defaultEndpointsIndex == -1) {
            LOG.warn("Unable to find a place for the default methods in `Program.cs` file");
            return $this$readAndEdtWriteAction.value((Object)false);
        }
        PsiFile psiFile = VirtualFileUtil.findPsiFile((VirtualFile)$programFile, (Project)this$0.project);
        return com.intellij.openapi.command.CoroutinesKt.writeCommandAction((ReadAndWriteScope)$this$readAndEdtWriteAction, (Project)this$0.project, (String)AspireBundle.message("write.command.insert.default.methods", new Object[0]), () -> AspireDefaultFileModificationService.insertAspireDefaultMethodsIntoProgramFile$lambda$0$0(defaultEndpointsIndex, psiFile, this$0, document, serviceDefaultsIndex));
    }

    private static final boolean insertAspireDefaultMethodsIntoProgramFile$lambda$0$0(int $defaultEndpointsIndex, PsiFile $psiFile, AspireDefaultFileModificationService this$0, Document $document, Ref.IntRef $serviceDefaultsIndex) {
        String textToInsert;
        StringBuilder stringBuilder;
        String indent;
        if ($defaultEndpointsIndex != -1) {
            PsiFile psiFile = $psiFile;
            indent = psiFile != null ? this$0.calculateIndent(psiFile, $document, $defaultEndpointsIndex) : "";
            StringBuilder $this$insertAspireDefaultMethodsIntoProgramFile_u24lambda_u240_u240_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$insertAspireDefaultMethodsIntoProgramFile_u24lambda_u240_u240_u240.append('\n');
            $this$insertAspireDefaultMethodsIntoProgramFile_u24lambda_u240_u240_u240.append('\n');
            $this$insertAspireDefaultMethodsIntoProgramFile_u24lambda_u240_u240_u240.append(indent);
            $this$insertAspireDefaultMethodsIntoProgramFile_u24lambda_u240_u240_u240.append(MAP_DEFAULT_ENDPOINTS);
            textToInsert = stringBuilder.toString();
            $document.insertString($defaultEndpointsIndex + 1, (CharSequence)textToInsert);
        }
        if ($serviceDefaultsIndex.element != -1) {
            PsiFile psiFile = $psiFile;
            indent = psiFile != null ? this$0.calculateIndent(psiFile, $document, $serviceDefaultsIndex.element) : "";
            StringBuilder $this$insertAspireDefaultMethodsIntoProgramFile_u24lambda_u240_u240_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$insertAspireDefaultMethodsIntoProgramFile_u24lambda_u240_u240_u241.append('\n');
            $this$insertAspireDefaultMethodsIntoProgramFile_u24lambda_u240_u240_u241.append('\n');
            $this$insertAspireDefaultMethodsIntoProgramFile_u24lambda_u240_u240_u241.append(indent);
            $this$insertAspireDefaultMethodsIntoProgramFile_u24lambda_u240_u240_u241.append(ADD_SERVICE_DEFAULTS_METHOD);
            textToInsert = stringBuilder.toString();
            $document.insertString($serviceDefaultsIndex.element + 1, (CharSequence)textToInsert);
        }
        return true;
    }

    public static final /* synthetic */ Object access$insertAspireDefaultMethodsIntoProgramFile(AspireDefaultFileModificationService $this, VirtualFile programFile, boolean isWebProject, Continuation $completion) {
        return $this.insertAspireDefaultMethodsIntoProgramFile(programFile, isWebProject, (Continuation<? super Boolean>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AspireDefaultFileModificationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/aspire/orchestration/AspireDefaultFileModificationService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/aspire/orchestration/AspireDefaultFileModificationService;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "APP_HOST_FILE", "", "PROGRAM_FILE", "MAUI_PROGRAM_FILE", "ADD_PROJECT_METHOD", "CREATE_BUILDER_METHOD", "CREATE_APPLICATION_BUILDER_METHOD", "BUILD_METHOD", "ADD_SERVICE_DEFAULTS_METHOD", "MAP_DEFAULT_ENDPOINTS", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nAspireDefaultFileModificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspireDefaultFileModificationService.kt\ncom/jetbrains/rider/aspire/orchestration/AspireDefaultFileModificationService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,285:1\n30#2,2:286\n*S KotlinDebug\n*F\n+ 1 AspireDefaultFileModificationService.kt\ncom/jetbrains/rider/aspire/orchestration/AspireDefaultFileModificationService$Companion\n*L\n41#1:286,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AspireDefaultFileModificationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<AspireDefaultFileModificationService> serviceClass$iv = AspireDefaultFileModificationService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AspireDefaultFileModificationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

