/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.graph;

import com.intellij.diagram.v2.GraphChartConfiguration;
import com.intellij.diagram.v2.GraphChartFactory;
import com.intellij.diagram.v2.dsl.GraphChartEdgePainterKtBuilder;
import com.intellij.diagram.v2.dsl.GraphChartEdgeStyleKtBuilder;
import com.intellij.diagram.v2.dsl.GraphChartEdgeStyleKtBuilderFactory;
import com.intellij.diagram.v2.dsl.GraphChartKtConfigurator;
import com.intellij.diagram.v2.dsl.GraphChartNodePainterKtBuilder;
import com.intellij.diagram.v2.dsl.GraphChartViewSettingKtBuilder;
import com.intellij.diagram.v2.handles.GraphChartHandle;
import com.intellij.diagram.v2.layout.GraphChartLayoutOrientation;
import com.intellij.diagram.v2.layout.GraphChartLayoutService;
import com.intellij.diagram.v2.layout.GraphChartLayouter;
import com.intellij.diagram.v2.painting.GraphChartEdgePainter;
import com.intellij.diagram.v2.painting.GraphChartPainterService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.graph.GraphFactory;
import com.intellij.util.graph.MutableNetwork;
import com.intellij.util.graph.Network;
import com.jetbrains.rider.aspire.AspireBundle;
import com.jetbrains.rider.aspire.dashboard.AspireHost;
import com.jetbrains.rider.aspire.dashboard.AspireResource;
import com.jetbrains.rider.aspire.generated.ResourceRelationship;
import com.jetbrains.rider.aspire.graph.ResourceGraphEdge;
import com.jetbrains.rider.aspire.graph.ResourceGraphNode;
import com.jetbrains.rider.aspire.util.AspireResourceUtilsKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u0007*\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/aspire/graph/ResourceGraphService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "showResourceGraph", "", "aspireHost", "Lcom/jetbrains/rider/aspire/dashboard/AspireHost;", "createResourceGraphNode", "Lcom/jetbrains/rider/aspire/graph/ResourceGraphNode;", "resource", "Lcom/jetbrains/rider/aspire/dashboard/AspireResource;", "calculateResourceNodeEdges", "", "Lcom/jetbrains/rider/aspire/graph/ResourceGraphEdge;", "resources", "resourceNodes", "", "", "resourceGraphConfigurator", "Lcom/intellij/diagram/v2/dsl/GraphChartKtConfigurator;", "Companion", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nResourceGraphService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceGraphService.kt\ncom/jetbrains/rider/aspire/graph/ResourceGraphService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,111:1\n1193#2,2:112\n1267#2,4:114\n1869#2,2:120\n1491#2:125\n1516#2,3:126\n1519#2,3:136\n216#3,2:118\n3919#4:122\n4434#4,2:123\n382#5,7:129\n*S KotlinDebug\n*F\n+ 1 ResourceGraphService.kt\ncom/jetbrains/rider/aspire/graph/ResourceGraphService\n*L\n36#1:112,2\n36#1:114,4\n45#1:120,2\n77#1:125\n77#1:126,3\n77#1:136,3\n44#1:118,2\n76#1:122\n76#1:123,2\n77#1:129,7\n*E\n"})
public final class ResourceGraphService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public ResourceGraphService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    public final void showResourceGraph(@NotNull AspireHost aspireHost) {
        MutableNetwork mutableNetwork;
        Object it;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)aspireHost, (String)"aspireHost");
        List<AspireResource> resources = aspireHost.getResources();
        Iterable $this$associate$iv = resources;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            it = (AspireResource)element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to((Object)((AspireResource)it).getDisplayName(), (Object)this.createResourceGraphNode((AspireResource)it));
            map.put(it.getFirst(), it.getSecond());
        }
        Map resourceNodes = destination$iv$iv;
        List<ResourceGraphEdge> resourceNodeEdges = this.calculateResourceNodeEdges(resources, resourceNodes);
        MutableNetwork $this$showResourceGraph_u24lambda_u241 = mutableNetwork = GraphFactory.getInstance().directedNetwork().allowsParallelEdges(true).build();
        boolean bl = false;
        Object $this$forEach$iv = resourceNodes;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            it = element$iv;
            boolean bl2 = false;
            $this$showResourceGraph_u24lambda_u241.addNode(it.getValue());
        }
        $this$forEach$iv = resourceNodeEdges;
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            element$iv = iterator.next();
            it = (ResourceGraphEdge)((Object)element$iv);
            boolean bl3 = false;
            $this$showResourceGraph_u24lambda_u241.addEdge((Object)((ResourceGraphEdge)it).getSource(), (Object)((ResourceGraphEdge)it).getTarget(), it);
        }
        MutableNetwork graph = mutableNetwork;
        MutableNetwork $this$showResourceGraph_u24lambda_u242 = mutableNetwork = GraphChartFactory.Companion.getInstance();
        boolean bl4 = false;
        Intrinsics.checkNotNull((Object)graph);
        GraphChartConfiguration configuration = $this$showResourceGraph_u24lambda_u242.graphChart(this.project, (Network)graph, arg_0 -> ResourceGraphService.showResourceGraph$lambda$2$0(this, arg_0));
        $this$showResourceGraph_u24lambda_u242.instantiateAndShowInEditor(configuration, true, ResourceGraphService::showResourceGraph$lambda$2$1);
    }

    private final ResourceGraphNode createResourceGraphNode(AspireResource resource) {
        AspireResource.AspireResourceProperty<String> aspireResourceProperty = resource.getContainerImage();
        return new ResourceGraphNode(resource.getUid(), resource.getDisplayName(), AspireResourceUtilsKt.getBaseIcon(resource.getType(), aspireResourceProperty != null ? aspireResourceProperty.getValue() : null));
    }

    /*
     * Could not resolve type clashes
     * WARNING - void declaration
     */
    private final List<ResourceGraphEdge> calculateResourceNodeEdges(List<AspireResource> resources, Map<String, ResourceGraphNode> resourceNodes) {
        List list;
        List $this$calculateResourceNodeEdges_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (AspireResource resource : resources) {
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            if (resourceNodes.get(resource.getDisplayName()) == null) continue;
            ResourceRelationship[] resourceRelationshipArray = resource.getRelationships();
            boolean $i$f$filter = false;
            void var11_12 = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it.getResourceName(), (Object)resource.getDisplayName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                void $this$getOrPut$iv$iv$iv;
                ResourceRelationship it = (ResourceRelationship)element$iv$iv;
                boolean bl3 = false;
                String key$iv$iv = it.getResourceName();
                Object object2 = destination$iv$iv;
                String key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Object relationships = destination$iv$iv;
            for (Map.Entry relationship : relationships.entrySet()) {
                ResourceGraphNode targetNode;
                ResourceGraphNode sourceNode;
                if (resourceNodes.get(relationship.getKey()) == null) continue;
                $this$calculateResourceNodeEdges_u24lambda_u240.add(new ResourceGraphEdge(sourceNode, targetNode));
            }
        }
        return CollectionsKt.build((List)list);
    }

    private final void resourceGraphConfigurator(GraphChartKtConfigurator<ResourceGraphNode, ResourceGraphEdge> $this$resourceGraphConfigurator) {
        $this$resourceGraphConfigurator.setChartTitle(AspireBundle.message("resource.graph.title", new Object[0]));
        $this$resourceGraphConfigurator.initialViewSettings(ResourceGraphService::resourceGraphConfigurator$lambda$0);
        $this$resourceGraphConfigurator.nodePainter(ResourceGraphService::resourceGraphConfigurator$lambda$1);
        $this$resourceGraphConfigurator.edgePainter(ResourceGraphService::resourceGraphConfigurator$lambda$2);
    }

    private static final Unit showResourceGraph$lambda$2$0(ResourceGraphService this$0, GraphChartKtConfigurator $this$graphChart) {
        Intrinsics.checkNotNullParameter((Object)$this$graphChart, (String)"$this$graphChart");
        this$0.resourceGraphConfigurator((GraphChartKtConfigurator<ResourceGraphNode, ResourceGraphEdge>)$this$graphChart);
        return Unit.INSTANCE;
    }

    private static final Unit showResourceGraph$lambda$2$1(GraphChartHandle it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit resourceGraphConfigurator$lambda$0(GraphChartViewSettingKtBuilder $this$initialViewSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$initialViewSettings, (String)"$this$initialViewSettings");
        $this$initialViewSettings.setMergeEdgeBySources(false);
        $this$initialViewSettings.setMergeEdgeByTargets(false);
        GraphChartLayouter graphChartLayouter = GraphChartLayoutService.getInstance().getHierarchicLayouter();
        Intrinsics.checkNotNullExpressionValue((Object)graphChartLayouter, (String)"getHierarchicLayouter(...)");
        $this$initialViewSettings.setCurrentLayouter(graphChartLayouter);
        $this$initialViewSettings.setCurrentLayoutOrientation(GraphChartLayoutOrientation.LEFT_TO_RIGHT);
        return Unit.INSTANCE;
    }

    private static final Unit resourceGraphConfigurator$lambda$1(GraphChartNodePainterKtBuilder $this$nodePainter) {
        Intrinsics.checkNotNullParameter((Object)$this$nodePainter, (String)"$this$nodePainter");
        $this$nodePainter.labelWithIconNodePainter(ResourceGraphService::resourceGraphConfigurator$lambda$1$0);
        return Unit.INSTANCE;
    }

    private static final GraphChartPainterService.LabelWithIconNodeStyleProvider.LabelWithIcon resourceGraphConfigurator$lambda$1$0(GraphChartHandle graphChartHandle, ResourceGraphNode node) {
        Intrinsics.checkNotNullParameter((Object)graphChartHandle, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return new GraphChartPainterService.LabelWithIconNodeStyleProvider.LabelWithIcon(node.getIcon(), node.getDisplayName(), null);
    }

    private static final Unit resourceGraphConfigurator$lambda$2(GraphChartEdgePainterKtBuilder $this$edgePainter) {
        Intrinsics.checkNotNullParameter((Object)$this$edgePainter, (String)"$this$edgePainter");
        $this$edgePainter.defaultEdgePainter(ResourceGraphService::resourceGraphConfigurator$lambda$2$0);
        return Unit.INSTANCE;
    }

    private static final GraphChartEdgePainter.EdgeStyle resourceGraphConfigurator$lambda$2$0(GraphChartHandle graphChartHandle, ResourceGraphEdge resourceGraphEdge) {
        Intrinsics.checkNotNullParameter((Object)graphChartHandle, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)resourceGraphEdge, (String)"<unused var>");
        return GraphChartEdgeStyleKtBuilderFactory.Companion.getInstance().edgeStyle(ResourceGraphService::resourceGraphConfigurator$lambda$2$0$0);
    }

    private static final Unit resourceGraphConfigurator$lambda$2$0$0(GraphChartEdgeStyleKtBuilder $this$edgeStyle) {
        Intrinsics.checkNotNullParameter((Object)$this$edgeStyle, (String)"$this$edgeStyle");
        $this$edgeStyle.setTargetArrow(GraphChartEdgeStyleKtBuilder.arrow$default((GraphChartEdgeStyleKtBuilder)$this$edgeStyle, (GraphChartEdgePainter.EdgeArrowType)GraphChartEdgePainter.EdgeArrowType.STANDARD, (int)0, (int)2, null));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/aspire/graph/ResourceGraphService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/aspire/graph/ResourceGraphService;", "project", "Lcom/intellij/openapi/project/Project;", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nResourceGraphService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceGraphService.kt\ncom/jetbrains/rider/aspire/graph/ResourceGraphService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,111:1\n30#2,2:112\n*S KotlinDebug\n*F\n+ 1 ResourceGraphService.kt\ncom/jetbrains/rider/aspire/graph/ResourceGraphService$Companion\n*L\n30#1:112,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceGraphService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ResourceGraphService> serviceClass$iv = ResourceGraphService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ResourceGraphService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

