/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.databases;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.aspire.dashboard.AspireResource;
import com.jetbrains.rider.aspire.dashboard.ResourceListener;
import com.jetbrains.rider.aspire.databases.DatabaseResource;
import com.jetbrains.rider.aspire.databases.DatabaseResourceConnectionService;
import com.jetbrains.rider.aspire.databases.DatabaseType;
import com.jetbrains.rider.aspire.generated.ResourceState;
import com.jetbrains.rider.aspire.generated.ResourceType;
import com.jetbrains.rider.aspire.generated.ResourceUrl;
import com.jetbrains.rider.aspire.settings.AspireSettings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/aspire/databases/DatabaseResourceListener;", "Lcom/jetbrains/rider/aspire/dashboard/ResourceListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "resourceCreated", "", "resource", "Lcom/jetbrains/rider/aspire/dashboard/AspireResource;", "resourceUpdated", "applyChanges", "findDatabaseType", "Lcom/jetbrains/rider/aspire/databases/DatabaseType;", "resourceName", "", "resourceImage", "value", "Companion", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nDatabaseResourceListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseResourceListener.kt\ncom/jetbrains/rider/aspire/databases/DatabaseResourceListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,84:1\n11879#2,9:85\n13805#2:94\n13806#2:97\n11888#2:98\n1#3:95\n1#3:96\n67#4,4:99\n13#4:103\n*S KotlinDebug\n*F\n+ 1 DatabaseResourceListener.kt\ncom/jetbrains/rider/aspire/databases/DatabaseResourceListener\n*L\n41#1:85,9\n41#1:94\n41#1:97\n41#1:98\n41#1:96\n56#1:99,4\n15#1:103\n*E\n"})
public final class DatabaseResourceListener
implements ResourceListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String POSTGRES = "postgres";
    @NotNull
    private static final String MYSQL = "mysql";
    @NotNull
    private static final String MSSQL = "mssql";
    @NotNull
    private static final String ORACLE = "oracle";
    @NotNull
    private static final String MONGO = "mongo";
    @NotNull
    private static final String REDIS = "redis";

    public DatabaseResourceListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public void resourceCreated(@NotNull AspireResource resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.applyChanges(resource);
    }

    @Override
    public void resourceUpdated(@NotNull AspireResource resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.applyChanges(resource);
    }

    /*
     * WARNING - void declaration
     */
    private final void applyChanges(AspireResource resource) {
        if (!AspireSettings.Companion.getInstance().getConnectToDatabase()) {
            return;
        }
        if (resource.getType() != ResourceType.Container) {
            return;
        }
        AspireResource.AspireResourceProperty<String> aspireResourceProperty = resource.getConnectionString();
        if (aspireResourceProperty == null || (aspireResourceProperty = aspireResourceProperty.getValue()) == null) {
            return;
        }
        AspireResource.AspireResourceProperty<String> connectionString = aspireResourceProperty;
        if (resource.getState() == ResourceState.Running) {
            void $this$mapNotNullTo$iv$iv;
            AspireResource.AspireResourceProperty<String> aspireResourceProperty2 = resource.getContainerId();
            if (aspireResourceProperty2 == null || (aspireResourceProperty2 = aspireResourceProperty2.getValue()) == null) {
                return;
            }
            AspireResource.AspireResourceProperty<String> containerId = aspireResourceProperty2;
            AspireResource.AspireResourceProperty<String> aspireResourceProperty3 = resource.getContainerImage();
            DatabaseType databaseType = this.findDatabaseType(resource.getName(), aspireResourceProperty3 != null ? aspireResourceProperty3.getValue() : null);
            if (databaseType == null) {
                return;
            }
            DatabaseType resourceType = databaseType;
            ResourceUrl[] $this$mapNotNull$iv = resource.getUrls();
            boolean $i$f$mapNotNull = false;
            ResourceUrl[] resourceUrlArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                URI it$iv$iv;
                Object object;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void url = element$iv$iv;
                boolean bl2 = false;
                Object object2 = this;
                try {
                    DatabaseResourceListener $this$applyChanges_u24lambda_u240_u240 = object2;
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)new URI(url.getFullUrl()));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                if ((URI)(Result.isFailure-impl((Object)object2) ? null : object2) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List urls = (List)destination$iv$iv;
            if (urls.isEmpty()) {
                return;
            }
            AspireResource.AspireResourceProperty<String> aspireResourceProperty4 = resource.getContainerLifetime();
            boolean isPersistent = StringsKt.equals((String)(aspireResourceProperty4 != null ? aspireResourceProperty4.getValue() : null), (String)"persistent", (boolean)true);
            AspireResource.AspireResourceProperty<String> aspireResourceProperty5 = resource.getContainerPorts();
            DatabaseResource databaseResource = new DatabaseResource(resource.getDisplayName(), (String)((Object)containerId), resourceType, (String)((Object)connectionString), urls, aspireResourceProperty5 != null ? aspireResourceProperty5.getValue() : null, isPersistent, resource.getLifetime());
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Created database resource: " + databaseResource.getName());
            }
            DatabaseResourceConnectionService.AddDatabaseResourceConnection command = new DatabaseResourceConnectionService.AddDatabaseResourceConnection(databaseResource);
            DatabaseResourceConnectionService.Companion.getInstance(this.project).sendConnectionCommand(command);
        }
    }

    private final DatabaseType findDatabaseType(String resourceName, String resourceImage) {
        DatabaseType databaseTypeByImage;
        if (resourceImage != null && (databaseTypeByImage = this.findDatabaseType(resourceImage)) != null) {
            return databaseTypeByImage;
        }
        return AspireSettings.Companion.getInstance().getCheckResourceNameForDatabase() ? this.findDatabaseType(resourceName) : null;
    }

    private final DatabaseType findDatabaseType(String value) {
        if (StringsKt.contains$default((CharSequence)value, (CharSequence)POSTGRES, (boolean)false, (int)2, null)) {
            return DatabaseType.POSTGRES;
        }
        if (StringsKt.contains$default((CharSequence)value, (CharSequence)MYSQL, (boolean)false, (int)2, null)) {
            return DatabaseType.MYSQL;
        }
        if (StringsKt.contains$default((CharSequence)value, (CharSequence)MSSQL, (boolean)false, (int)2, null)) {
            return DatabaseType.MSSQL;
        }
        if (StringsKt.contains$default((CharSequence)value, (CharSequence)ORACLE, (boolean)false, (int)2, null)) {
            return DatabaseType.ORACLE;
        }
        if (StringsKt.contains$default((CharSequence)value, (CharSequence)MONGO, (boolean)false, (int)2, null)) {
            return DatabaseType.MONGO;
        }
        if (StringsKt.contains$default((CharSequence)value, (CharSequence)REDIS, (boolean)false, (int)2, null)) {
            return DatabaseType.REDIS;
        }
        return null;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DatabaseResourceListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/aspire/databases/DatabaseResourceListener$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "POSTGRES", "", "MYSQL", "MSSQL", "ORACLE", "MONGO", "REDIS", "aspire-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

