/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.databases;

import com.github.dockerjava.api.model.ContainerPort;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.util.DataSourceUtilKt;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.docker.DockerServerRuntimesManager;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerPhysicalRuntime;
import com.intellij.docker.runtimes.DockerServerRuntime;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.aspire.AspireBundle;
import com.jetbrains.rider.aspire.databases.DatabaseResource;
import com.jetbrains.rider.aspire.databases.DatabaseResourceConnectionService;
import com.jetbrains.rider.aspire.databases.DatabaseType;
import com.jetbrains.rider.aspire.databases.DummyMongoDataProvider;
import com.jetbrains.rider.aspire.databases.DummyRedisDataProvider;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.connection.ConnectionManager;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.connection.TestConnectionExecutionResult;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.converters.ConnectionStringToJdbcUrlConverter;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.DotnetDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.MySqlClientDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.NpgsqlDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.OracleClientDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.SqlClientDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.factories.ConnectionStringsFactory;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.connectionStrings.ConnectionString;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u0001\u0018\u0000 ;2\u00020\u0001:\u0004;<=>B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0014J\u0016\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0082@\u00a2\u0006\u0002\u0010\u001cJ&\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0082@\u00a2\u0006\u0002\u0010!J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0082@\u00a2\u0006\u0004\b$\u0010\u001cJ,\u0010%\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010'\u0012\u0006\u0012\u0004\u0018\u00010'0&0\t2\u0006\u0010(\u001a\u00020\rH\u0082@\u00a2\u0006\u0002\u0010)J\u0017\u0010*\u001a\u0004\u0018\u00010'2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\nH\u0002J0\u0010/\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00100\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0082@\u00a2\u0006\u0002\u00103J\u0012\u00104\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u0016\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u00107J\u0016\u00108\u001a\u00020 2\u0006\u00106\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u00107J\u0012\u00109\u001a\u00020\u000e2\b\u0010:\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/jetbrains/rider/aspire/databases/DatabaseResourceConnectionService;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "rawConnectionStringTypes", "", "Lcom/jetbrains/rider/aspire/databases/DatabaseType;", "connectionStrings", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "urlToConnectionString", "connectionManager", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/connection/ConnectionManager;", "connectionCommands", "Lkotlinx/coroutines/channels/Channel;", "Lcom/jetbrains/rider/aspire/databases/DatabaseResourceConnectionService$DatabaseResourceConnectionCommand;", "createdDataSources", "Lcom/intellij/database/dataSource/LocalDataSource;", "sendConnectionCommand", "command", "addConnection", "databaseResource", "Lcom/jetbrains/rider/aspire/databases/DatabaseResource;", "(Lcom/jetbrains/rider/aspire/databases/DatabaseResource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createDataSource", "connectionString", "connectionStringWasModified", "", "(Ljava/lang/String;ZLcom/jetbrains/rider/aspire/databases/DatabaseResource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "modifyConnectionString", "Lkotlin/Result;", "modifyConnectionString-gIAlu-s", "getContainerPorts", "Lkotlin/Pair;", "", "containerId", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getResourcePort", "(Lcom/jetbrains/rider/aspire/databases/DatabaseResource;)Ljava/lang/Integer;", "getDataProvider", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/dataProviders/DotnetDataProvider;", "type", "getConnectionUrl", "dataProvider", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "(Ljava/lang/String;Lcom/jetbrains/rider/aspire/databases/DatabaseResource;Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/dataProviders/DotnetDataProvider;Lcom/intellij/database/dataSource/DatabaseDriver;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "convertRedisConnectionString", "connectToDataSource", "dataSource", "(Lcom/intellij/database/dataSource/LocalDataSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitForConnection", "removeConnectionStringByUrl", "url", "Companion", "DatabaseResourceConnectionCommand", "AddDatabaseResourceConnection", "DataSourceListener", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nDatabaseResourceConnectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseResourceConnectionService.kt\ncom/jetbrains/rider/aspire/databases/DatabaseResourceConnectionService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 dockerUtils.kt\ncom/intellij/docker/utils/DockerUtils\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,344:1\n67#2,4:345\n67#2,4:349\n67#2,4:353\n67#2,4:360\n67#2,4:364\n67#2,4:368\n67#2,4:372\n67#2,4:391\n60#2,5:401\n67#2,4:407\n13#2:411\n1761#3,3:357\n295#3,2:376\n808#3,11:379\n1869#3:400\n1870#3:406\n100#4:378\n1#5:390\n1#5:399\n11561#6:395\n11896#6,3:396\n*S KotlinDebug\n*F\n+ 1 DatabaseResourceConnectionService.kt\ncom/jetbrains/rider/aspire/databases/DatabaseResourceConnectionService\n*L\n97#1:345,4\n100#1:349,4\n108#1:353,4\n140#1:360,4\n144#1:364,4\n185#1:368,4\n192#1:372,4\n212#1:391,4\n319#1:401,5\n158#1:407,4\n53#1:411\n139#1:357,3\n194#1:376,2\n210#1:379,11\n311#1:400\n311#1:406\n210#1:378\n210#1:390\n216#1:395\n216#1:396,3\n*E\n"})
public final class DatabaseResourceConnectionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<DatabaseType> rawConnectionStringTypes;
    @NotNull
    private final ConcurrentHashMap<String, Unit> connectionStrings;
    @NotNull
    private final ConcurrentHashMap<String, String> urlToConnectionString;
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final Channel<DatabaseResourceConnectionCommand> connectionCommands;
    @NotNull
    private final Channel<LocalDataSource> createdDataSources;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String REDIS_CONNECTION_STRING_PATTERN = "(?<host>\\w*):(?<port>\\d*)(,user=(?<user>\\w*))?(,password=(?<password>\\w*))?";
    @NotNull
    private static final Regex REDIS_REGEX;

    public DatabaseResourceConnectionService(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        DatabaseType[] databaseTypeArray = new DatabaseType[]{DatabaseType.MSSQL, DatabaseType.MONGO};
        this.rawConnectionStringTypes = CollectionsKt.listOf((Object[])databaseTypeArray);
        this.connectionStrings = new ConcurrentHashMap();
        this.urlToConnectionString = new ConcurrentHashMap();
        this.connectionManager = new ConnectionManager(this.project);
        this.connectionCommands = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.createdDataSources = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ DatabaseResourceConnectionService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block8: {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            var2_3 = DatabaseResourceConnectionService.access$getConnectionCommands$p(this.this$0).iterator();
lbl6:
                            // 2 sources

                            while (true) {
                                this.L$0 = var2_3;
                                this.L$1 = null;
                                this.label = 1;
                                v0 = var2_3.hasNext((Continuation)this);
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl18
                                break;
                            }
                        }
                        case 1: {
                            var2_3 = (ChannelIterator)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl18:
                            // 2 sources

                            if (!((Boolean)v0).booleanValue()) break block8;
                            command = (DatabaseResourceConnectionCommand)var2_3.next();
                            if (!(command instanceof AddDatabaseResourceConnection)) break;
                            this.L$0 = var2_3;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)command);
                            this.label = 2;
                            v1 = DatabaseResourceConnectionService.access$addConnection(this.this$0, ((AddDatabaseResourceConnection)command).getResource(), (Continuation)this);
                            if (v1 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl33
                        }
                        case 2: {
                            command = (DatabaseResourceConnectionCommand)this.L$1;
                            var2_3 = (ChannelIterator)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl33:
                            // 2 sources

                            ** continue;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ DatabaseResourceConnectionService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = DatabaseResourceConnectionService.access$getCreatedDataSources$p(this.this$0).iterator();
lbl6:
                        // 2 sources

                        while (true) {
                            this.L$0 = var2_3;
                            this.L$1 = null;
                            this.label = 1;
                            v0 = var2_3.hasNext((Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl18
                            break;
                        }
                    }
                    case 1: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) break;
                        ds = (LocalDataSource)var2_3.next();
                        this.L$0 = var2_3;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)ds);
                        this.label = 2;
                        v1 = DatabaseResourceConnectionService.access$connectToDataSource(this.this$0, ds, (Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        ds = (LocalDataSource)this.L$1;
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl32:
                        // 2 sources

                        ** continue;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void sendConnectionCommand(@NotNull DatabaseResourceConnectionCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.connectionCommands.trySend-JP2dKIU((Object)command);
    }

    /*
     * Unable to fully structure code
     */
    private final Object addConnection(DatabaseResource databaseResource, Continuation<? super Unit> $completion) {
        if (!($completion instanceof addConnection.1)) ** GOTO lbl-1000
        var12_3 = $completion;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DatabaseResourceConnectionService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DatabaseResourceConnectionService.access$addConnection(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (RLifetimeKt.isNotAlive((Lifetime)databaseResource.getResourceLifetime())) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = databaseResource;
                $continuation.label = 1;
                v0 = this.modifyConnectionString-gIAlu-s(databaseResource, (Continuation<? super Result<String>>)$continuation);
                if (v0 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                databaseResource = (DatabaseResource)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = ((Result)$result).unbox-impl();
lbl24:
                // 2 sources

                var5_8 = modifyConnectionStringResult = v0;
                var6_9 = databaseResource.getConnectionString();
                connectionString = (String)(Result.isFailure-impl((Object)var5_8) != false ? var6_9 : var5_8);
                $this$trace$iv = DatabaseResourceConnectionService.LOG;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var10_14 = $this$trace$iv;
                    $i$a$-trace-DatabaseResourceConnectionService$addConnection$2 = false;
                    var10_14.trace("Processing connection string for " + databaseResource.getName());
                }
                if (this.connectionStrings.putIfAbsent(connectionString, Unit.INSTANCE) != null) {
                    $this$trace$iv = DatabaseResourceConnectionService.LOG;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var10_14 = $this$trace$iv;
                        $i$a$-trace-DatabaseResourceConnectionService$addConnection$3 = false;
                        var10_14.trace("Connection string for " + databaseResource.getName() + " is already in use");
                    }
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = databaseResource;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)modifyConnectionStringResult);
                $continuation.L$2 = connectionString;
                $continuation.label = 2;
                v1 = this.createDataSource(connectionString, Result.isSuccess-impl((Object)modifyConnectionStringResult), databaseResource, (Continuation<? super Unit>)$continuation);
                ** if (v1 != var13_5) goto lbl52
lbl51:
                // 1 sources

                return var13_5;
lbl52:
                // 1 sources

                ** GOTO lbl77
            }
            case 2: {
                connectionString = (String)$continuation.L$2;
                modifyConnectionStringResult = $continuation.L$1;
                databaseResource = (DatabaseResource)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (CancellationException ce) {
                    this.connectionStrings.remove(connectionString);
                    $this$trace$iv = DatabaseResourceConnectionService.LOG;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var10_14 = $this$trace$iv;
                        $i$a$-trace-DatabaseResourceConnectionService$addConnection$4 = false;
                        var10_14.trace("Connecting with to database resource " + databaseResource.getName() + " was cancelled");
                    }
                    throw ce;
                }
                catch (Exception e) {
                    DatabaseResourceConnectionService.LOG.warn("Unable to connect to database " + databaseResource.getName(), (Throwable)e);
                    this.connectionStrings.remove(connectionString);
                }
lbl77:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object createDataSource(String connectionString, boolean connectionStringWasModified, DatabaseResource databaseResource, Continuation<? super Unit> $completion) {
        if (!($completion instanceof createDataSource.1)) ** GOTO lbl-1000
        var17_5 = $completion;
        if ((var17_5.label & -2147483648) != 0) {
            var17_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ DatabaseResourceConnectionService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DatabaseResourceConnectionService.access$createDataSource(this.this$0, null, false, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var18_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                dataProvider = this.getDataProvider(databaseResource.getType());
                driver = DbImplUtil.guessDatabaseDriver((Dbms)((Dbms)CollectionsKt.first((Iterable)dataProvider.getDbms())));
                if (driver == null) {
                    DatabaseResourceConnectionService.LOG.info("Unable to guess database driver for " + databaseResource.getName());
                    this.connectionStrings.remove(connectionString);
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = connectionString;
                $continuation.L$1 = databaseResource;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)dataProvider);
                $continuation.L$3 = driver;
                $continuation.Z$0 = connectionStringWasModified;
                $continuation.label = 1;
                v0 = this.getConnectionUrl(connectionString, databaseResource, dataProvider, driver, (Continuation<? super String>)$continuation);
                if (v0 == var18_7) {
                    return var18_7;
                }
                ** GOTO lbl37
            }
            case 1: {
                connectionStringWasModified = $continuation.Z$0;
                driver = (DatabaseDriver)$continuation.L$3;
                dataProvider = (DotnetDataProvider)$continuation.L$2;
                databaseResource = (DatabaseResource)$continuation.L$1;
                connectionString = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 2 sources

                if ((url = (String)v0) == null) {
                    DatabaseResourceConnectionService.LOG.info("Unable to convert a connection string to an url for " + databaseResource.getName());
                    this.connectionStrings.remove(connectionString);
                    return Unit.INSTANCE;
                }
                ((Map)this.urlToConnectionString).put(url, connectionString);
                v1 = LocalDataSourceManager.getInstance((Project)this.project);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                dataSourceManager = v1;
                v2 = dataSourceManager.getDataSources();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getDataSources(...)");
                $this$any$iv = v2;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl54
                v3 = false;
                ** GOTO lbl63
lbl54:
                // 1 sources

                var11_17 = $this$any$iv.iterator();
                while (var11_17.hasNext()) {
                    element$iv = var11_17.next();
                    it = (LocalDataSource)element$iv;
                    $i$a$-any-DatabaseResourceConnectionService$createDataSource$2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)url)) continue;
                    v3 = true;
                    ** GOTO lbl63
                }
                v3 = false;
lbl63:
                // 3 sources

                if (v3) {
                    $this$trace$iv = DatabaseResourceConnectionService.LOG;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var15_24 = $this$trace$iv;
                        $i$a$-trace-DatabaseResourceConnectionService$createDataSource$3 = false;
                        var15_24.trace("Data source for " + databaseResource.getName() + " is already in use");
                    }
                    return Unit.INSTANCE;
                }
                $this$trace$iv = DatabaseResourceConnectionService.LOG;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var15_25 = $this$trace$iv;
                    $i$a$-trace-DatabaseResourceConnectionService$createDataSource$4 = false;
                    var15_25.trace("Creating a new data source for " + databaseResource.getName());
                }
                $this$createDataSource_u24lambda_u243 = var11_17 = LocalDataSource.fromDriver((DatabaseDriver)driver, (String)url, (boolean)true);
                $i$a$-apply-DatabaseResourceConnectionService$createDataSource$createdDataSource$1 = false;
                $this$createDataSource_u24lambda_u243.setName(databaseResource.getName());
                $this$createDataSource_u24lambda_u243.setAutoSynchronize(true);
                v4 = var11_17;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"apply(...)");
                createdDataSource = v4;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)connectionString);
                $continuation.L$1 = databaseResource;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)dataProvider);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)driver);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)url);
                $continuation.L$5 = dataSourceManager;
                $continuation.L$6 = createdDataSource;
                $continuation.Z$0 = connectionStringWasModified;
                $continuation.label = 2;
                v5 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(dataSourceManager, createdDataSource, null){
                    int label;
                    final /* synthetic */ LocalDataSourceManager $dataSourceManager;
                    final /* synthetic */ LocalDataSource $createdDataSource;
                    {
                        this.$dataSourceManager = $dataSourceManager;
                        this.$createdDataSource = $createdDataSource;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.$dataSourceManager.addDataSource(this.$createdDataSource);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v5 == var18_7) {
                    return var18_7;
                }
                ** GOTO lbl111
            }
            case 2: {
                connectionStringWasModified = $continuation.Z$0;
                createdDataSource = (LocalDataSource)$continuation.L$6;
                dataSourceManager = (LocalDataSourceManager)$continuation.L$5;
                url = (String)$continuation.L$4;
                driver = (DatabaseDriver)$continuation.L$3;
                dataProvider = (DotnetDataProvider)$continuation.L$2;
                databaseResource = (DatabaseResource)$continuation.L$1;
                connectionString = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl111:
                // 2 sources

                if (!connectionStringWasModified || !databaseResource.isPersistent()) {
                    databaseResource.getResourceLifetime().onTerminationIfAlive((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, createDataSource$lambda$4(com.jetbrains.rider.aspire.databases.DatabaseResource com.intellij.database.dataSource.LocalDataSourceManager com.intellij.database.dataSource.LocalDataSource ), ()Lkotlin/Unit;)((DatabaseResource)databaseResource, (LocalDataSourceManager)dataSourceManager, (LocalDataSource)createdDataSource));
                }
                this.createdDataSources.trySend-JP2dKIU((Object)createdDataSource);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object modifyConnectionString-gIAlu-s(DatabaseResource databaseResource, Continuation<? super Result<String>> $completion) {
        if (!($completion instanceof modifyConnectionString.1)) ** GOTO lbl-1000
        var17_3 = $completion;
        if ((var17_3.label & -2147483648) != 0) {
            var17_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DatabaseResourceConnectionService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    Object object = DatabaseResourceConnectionService.access$modifyConnectionString-gIAlu-s(this.this$0, null, (Continuation)this);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Result.box-impl((Object)object);
                }
            };
        }
        $result = $continuation.result;
        var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_6 = databaseResource.getUrls();
                for (T var7_10 : var5_6) {
                    url = (URI)var7_10;
                    $i$a$-find-DatabaseResourceConnectionService$modifyConnectionString$resourceUrl$1 = false;
                    if (!StringsKt.contains$default((CharSequence)databaseResource.getConnectionString(), (CharSequence)String.valueOf(url.getPort()), (boolean)false, (int)2, null)) continue;
                    v0 = var7_10;
                    ** GOTO lbl20
                }
                v0 = null;
lbl20:
                // 2 sources

                resourceUrl = v0;
                if (resourceUrl == null) {
                    DatabaseResourceConnectionService.LOG.warn("Unable to find resource url for " + databaseResource.getName());
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalStateException()));
                }
                $continuation.L$0 = databaseResource;
                $continuation.L$1 = resourceUrl;
                $continuation.label = 1;
                v1 = this.getContainerPorts(databaseResource.getContainerId(), (Continuation<? super List<Pair<Integer, Integer>>>)$continuation);
                if (v1 == var18_5) {
                    return var18_5;
                }
                ** GOTO lbl37
            }
            case 1: {
                resourceUrl = (URI)$continuation.L$1;
                databaseResource = (DatabaseResource)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                if ((containerPorts = (List)v1).isEmpty()) {
                    DatabaseResourceConnectionService.LOG.info("Unable to get container ports for " + databaseResource.getContainerId());
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalStateException()));
                }
                $this$trace$iv = DatabaseResourceConnectionService.LOG;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var15_19 = $this$trace$iv;
                    $i$a$-trace-DatabaseResourceConnectionService$modifyConnectionString$2 = false;
                    var15_19.trace("Found container ports for " + CollectionsKt.joinToString$default((Iterable)containerPorts, null, null, null, (int)0, null, null, (int)63, null));
                }
                resourcePort = this.getResourcePort(databaseResource);
                if (resourcePort == null) {
                    DatabaseResourceConnectionService.LOG.info("Unable to find resource port for " + databaseResource.getContainerId());
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalStateException()));
                }
                $this$trace$iv = DatabaseResourceConnectionService.LOG;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var15_19 = $this$trace$iv;
                    $i$a$-trace-DatabaseResourceConnectionService$modifyConnectionString$3 = false;
                    var15_19.trace("Found resource port " + resourcePort);
                }
                $this$firstOrNull$iv = containerPorts;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Pair)element$iv;
                    $i$a$-firstOrNull-DatabaseResourceConnectionService$modifyConnectionString$targetPort$1 = false;
                    v2 = (Integer)it.getSecond();
                    var14_24 = resourcePort;
                    if (!(v2 != null && v2 == var14_24)) continue;
                    v3 = element$iv;
                    ** GOTO lbl71
                }
                v3 = null;
lbl71:
                // 2 sources

                v4 = (v5 = (Pair)v3) != null && (v5 = (Integer)v5.getFirst()) != null ? String.valueOf(v5.intValue()) : (targetPort = null);
                if (targetPort == null) {
                    DatabaseResourceConnectionService.LOG.warn("Unable to find a corresponding resource port " + resourcePort + " from container ports");
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalStateException()));
                }
                sourcePort = String.valueOf(resourceUrl.getPort());
                return Result.constructor-impl((Object)StringsKt.replace$default((String)databaseResource.getConnectionString(), (String)sourcePort, (String)targetPort, (boolean)false, (int)4, null));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getContainerPorts(String containerId, Continuation<? super List<Pair<Integer, Integer>>> $completion) {
        if (!($completion instanceof getContainerPorts.1)) ** GOTO lbl-1000
        var19_3 = $completion;
        if ((var19_3.label & -2147483648) != 0) {
            var19_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DatabaseResourceConnectionService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DatabaseResourceConnectionService.access$getContainerPorts(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var20_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                localServer = DockerUtils.getOrCreateDockerLocalServer();
                manager = DockerServerRuntimesManager.Companion.getInstance(this.project);
                $continuation.L$0 = containerId;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)localServer);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)manager);
                $continuation.label = 1;
                v0 = FutureKt.await((CompletionStage)manager.getOrCreateConnection(localServer), (Continuation)$continuation);
                ** if (v0 != var20_5) goto lbl23
lbl22:
                // 1 sources

                return var20_5;
lbl23:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                manager = (DockerServerRuntimesManager)$continuation.L$2;
                localServer = (RemoteServer)$continuation.L$1;
                containerId = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl32:
                    // 2 sources

                    serverRuntime = (DockerServerRuntime)v0;
                    var7_11 = serverRuntime.getRuntimesManager();
                    id$iv = containerId;
                    $i$f$findRuntimeById = false;
                    $this$filterIsInstance$iv$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus($this$findRuntimeById$iv.getContainers().values(), (Iterable)$this$findRuntimeById$iv.getImages().values()), (Iterable)$this$findRuntimeById$iv.getNetworks().values()), (Iterable)$this$findRuntimeById$iv.getVolumes().values());
                    $i$f$filterIsInstance = false;
                    var12_19 = $this$filterIsInstance$iv$iv;
                    destination$iv$iv$iv = new ArrayList<E>();
                    $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                        if (!(element$iv$iv$iv instanceof DockerApplicationRuntime)) continue;
                        destination$iv$iv$iv.add(element$iv$iv$iv);
                    }
                    for (E var13_21 : (Iterable)((List)destination$iv$iv$iv)) {
                        it$iv = (DockerPhysicalRuntime)var13_21;
                        $i$a$-find-DockerUtils$findRuntimeById$1$iv = false;
                        if (!Intrinsics.areEqual((Object)it$iv.getId(), (Object)id$iv)) continue;
                        v1 = var13_21;
                        ** GOTO lbl54
                    }
                    v1 = null;
lbl54:
                    // 2 sources

                    if ((container = (DockerApplicationRuntime)((DockerPhysicalRuntime)v1)) == null) {
                        $this$trace$iv = DatabaseResourceConnectionService.LOG;
                        $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            var17_32 = $this$trace$iv;
                            $i$a$-trace-DatabaseResourceConnectionService$getContainerPorts$2 = false;
                            var17_32.trace("Unable to find container runtime with id " + containerId);
                        }
                        return CollectionsKt.emptyList();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)container.getAgentContainer().getContainer().ports, (String)"ports");
                    $this$map$iv = container.getAgentContainer().getContainer().ports;
                    $i$f$map = false;
                    $i$a$-trace-DatabaseResourceConnectionService$getContainerPorts$2 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                    $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        $i$a$-find-DockerUtils$findRuntimeById$1$iv = (ContainerPort)item$iv$iv;
                        var17_33 = destination$iv$iv;
                        $i$a$-map-DatabaseResourceConnectionService$getContainerPorts$3 = false;
                        var17_33.add(TuplesKt.to((Object)it.getPublicPort(), (Object)it.getPrivatePort()));
                    }
                    return (List)destination$iv$iv;
                }
                catch (CancellationException ce) {
                    throw ce;
                }
                catch (Exception e) {
                    DatabaseResourceConnectionService.LOG.warn("Unable to get container port for " + containerId, (Throwable)e);
                    return CollectionsKt.emptyList();
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Integer getResourcePort(DatabaseResource databaseResource) {
        Integer n;
        block2: {
            String string = databaseResource.getContainerPorts();
            if (string == null) {
                return null;
            }
            String portString = string;
            String[] stringArray = new String[]{","};
            for (String it : (Iterable)StringsKt.split$default((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)portString, (CharSequence)"["), (CharSequence)"]"), (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
                boolean bl = false;
                Integer n2 = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)it)).toString());
                if (n2 == null) continue;
                n = n2;
                break block2;
            }
            n = null;
        }
        return n;
    }

    private final DotnetDataProvider getDataProvider(DatabaseType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> (DotnetDataProvider)NpgsqlDataProvider.Companion.getInstance(this.project);
            case 2 -> (DotnetDataProvider)MySqlClientDataProvider.Companion.getInstance(this.project);
            case 3 -> (DotnetDataProvider)SqlClientDataProvider.Companion.getInstance(this.project);
            case 4 -> (DotnetDataProvider)OracleClientDataProvider.Companion.getInstance(this.project);
            case 5 -> DummyMongoDataProvider.Companion.getInstance(this.project);
            case 6 -> DummyRedisDataProvider.Companion.getInstance(this.project);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * Unable to fully structure code
     */
    private final Object getConnectionUrl(String connectionString, DatabaseResource databaseResource, DotnetDataProvider dataProvider, DatabaseDriver driver, Continuation<? super String> $completion) {
        block11: {
            if (!($completion instanceof getConnectionUrl.1)) ** GOTO lbl-1000
            var11_6 = $completion;
            if ((var11_6.label & -2147483648) != 0) {
                var11_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    /* synthetic */ Object result;
                    final /* synthetic */ DatabaseResourceConnectionService this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return DatabaseResourceConnectionService.access$getConnectionUrl(this.this$0, null, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var12_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (databaseResource.getType() != DatabaseType.REDIS) ** GOTO lbl15
                    v0 = this.convertRedisConnectionString(connectionString);
                    break block11;
lbl15:
                    // 1 sources

                    if (!this.rawConnectionStringTypes.contains((Object)databaseResource.getType())) ** GOTO lbl18
                    v0 = connectionString;
                    break block11;
lbl18:
                    // 1 sources

                    factory = ConnectionStringsFactory.Companion.get(dataProvider, this.project);
                    if (factory == null) {
                        DatabaseResourceConnectionService.LOG.warn("Unable to find connection string factory");
                        return null;
                    }
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)connectionString);
                    $continuation.L$1 = databaseResource;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)dataProvider);
                    $continuation.L$3 = driver;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)factory);
                    $continuation.label = 1;
                    v1 = factory.create-0E7RQCE(connectionString, dataProvider, (Continuation)$continuation);
                    if (v1 == var12_8) {
                        return var12_8;
                    }
                    ** GOTO lbl40
                }
                case 1: {
                    factory = (ConnectionStringsFactory)$continuation.L$4;
                    driver = (DatabaseDriver)$continuation.L$3;
                    dataProvider = (DotnetDataProvider)$continuation.L$2;
                    databaseResource = (DatabaseResource)$continuation.L$1;
                    connectionString = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = ((Result)$result).unbox-impl();
lbl40:
                    // 2 sources

                    if ((parsedConnectionString = (ConnectionString)(Result.isFailure-impl((Object)(var8_11 = v1)) != false ? null : var8_11)) == null) {
                        DatabaseResourceConnectionService.LOG.warn("Unable to parse connection string for " + databaseResource.getName());
                        return null;
                    }
                    var8_11 = ConnectionStringToJdbcUrlConverter.Companion.convert(parsedConnectionString, driver, this.project);
                    if (var8_11 == null) break;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)connectionString);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)databaseResource);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)dataProvider);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)driver);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)factory);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)parsedConnectionString);
                    $continuation.label = 2;
                    v2 = var8_11.build-IoAF18A((Continuation)$continuation);
                    if (v2 == var12_8) {
                        return var12_8;
                    }
                    ** GOTO lbl66
                }
                case 2: {
                    parsedConnectionString = (ConnectionString)$continuation.L$5;
                    factory = (ConnectionStringsFactory)$continuation.L$4;
                    driver = (DatabaseDriver)$continuation.L$3;
                    dataProvider = (DotnetDataProvider)$continuation.L$2;
                    databaseResource = (DatabaseResource)$continuation.L$1;
                    connectionString = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = ((Result)$result).unbox-impl();
lbl66:
                    // 2 sources

                    var9_14 = v2;
                    v0 = (String)(Result.isFailure-impl((Object)var9_14) != false ? null : var9_14);
                    break block11;
                }
            }
            v0 = null;
        }
        return v0;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String convertRedisConnectionString(String connectionString) {
        StringBuilder sb;
        block4: {
            String it;
            MatchResult matchResult = REDIS_REGEX.matchEntire((CharSequence)connectionString);
            if (matchResult == null) {
                return null;
            }
            MatchResult matchResult2 = matchResult;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"host");
            String host = matchGroup != null ? matchGroup.getValue() : null;
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"port");
            String port = matchGroup2 != null ? matchGroup2.getValue() : null;
            MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"user");
            String user = matchGroup3 != null ? matchGroup3.getValue() : null;
            MatchGroup matchGroup4 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"password");
            String password = matchGroup4 != null ? matchGroup4.getValue() : null;
            sb = new StringBuilder("jdbc:redis://");
            String string = user;
            if (string != null) {
                it = string;
                boolean bl = false;
                sb.append(it).append(":");
            }
            String string2 = password;
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                sb.append(it).append("@");
            }
            String string3 = host;
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                sb.append(it);
            }
            String string4 = port;
            if (string4 == null) break block4;
            it = string4;
            boolean bl = false;
            sb.append(":").append(it);
        }
        return sb.toString();
    }

    private final Object connectToDataSource(LocalDataSource dataSource, Continuation<? super Unit> $completion) {
        Object object = TasksKt.withBackgroundProgress((Project)this.project, (String)AspireBundle.message("progress.connecting.to.database", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, dataSource, null){
            boolean Z$0;
            int label;
            final /* synthetic */ DatabaseResourceConnectionService this$0;
            final /* synthetic */ LocalDataSource $dataSource;
            {
                this.this$0 = $receiver;
                this.$dataSource = $dataSource;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DatabaseResourceConnectionService.access$waitForConnection(this.this$0, this.$dataSource, (Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (!(isConnectionSuccessful = ((Boolean)v0).booleanValue())) {
                            DatabaseResourceConnectionService.access$getLOG$cp().warn("Unable to connect to database");
                            return Unit.INSTANCE;
                        }
                        v1 = LoaderContext.selectGeneralTask((Project)DatabaseResourceConnectionService.access$getProject$p(this.this$0), (LocalDataSource)this.$dataSource);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"selectGeneralTask(...)");
                        this.Z$0 = isConnectionSuccessful;
                        this.label = 2;
                        v2 = DataSourceUtilKt.performAutoIntrospection((LoaderContext)v1, (boolean)true, (Continuation)((Continuation)this));
                        ** if (v2 != var4_2) goto lbl25
lbl24:
                        // 1 sources

                        return var4_2;
lbl25:
                        // 1 sources

                        ** GOTO lbl38
                    }
                    case 2: {
                        isConnectionSuccessful = this.Z$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                        }
                        catch (CancellationException ce) {
                            DatabaseResourceConnectionService.access$getLOG$cp().trace("Introspection is canceled");
                            throw ce;
                        }
                        catch (Exception e) {
                            DatabaseResourceConnectionService.access$getLOG$cp().warn("Unable to perform auto introspection", (Throwable)e);
                        }
lbl38:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitForConnection(LocalDataSource dataSource, Continuation<? super Boolean> $completion) {
        block12: {
            if (!($completion instanceof waitForConnection.1)) ** GOTO lbl-1000
            var16_3 = $completion;
            if ((var16_3.label & -2147483648) != 0) {
                var16_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ DatabaseResourceConnectionService this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return DatabaseResourceConnectionService.access$waitForConnection(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    credentials = DatabaseCredentialsUi.newUIInstance();
                    $this$forEach$iv = (Iterable)RangesKt.until((int)1, (int)5);
                    $i$f$forEach = 0;
                    var6_9 = $this$forEach$iv.iterator();
lbl16:
                    // 3 sources

                    while (var6_9.hasNext()) {
                        element$iv = var6_9.next();
                        ((Number)element$iv).intValue();
                        $i$a$-forEach-DatabaseResourceConnectionService$waitForConnection$2 = 0;
                        v0 = (DatabaseConnectionConfig)dataSource;
                        Intrinsics.checkNotNull((Object)credentials);
                        $continuation.L$0 = dataSource;
                        $continuation.L$1 = credentials;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                        $continuation.L$3 = var6_9;
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                        $continuation.L$5 = null;
                        $continuation.I$0 = $i$f$forEach;
                        $continuation.I$1 = $i$a$-forEach-DatabaseResourceConnectionService$waitForConnection$2;
                        $continuation.label = 1;
                        v1 = this.connectionManager.testConnection(v0, credentials, (Continuation)$continuation);
                        if (v1 == var17_5) {
                            return var17_5;
                        }
                        ** GOTO lbl47
                    }
                    break block12;
                }
                case 1: {
                    $i$a$-forEach-DatabaseResourceConnectionService$waitForConnection$2 = $continuation.I$1;
                    $i$f$forEach = $continuation.I$0;
                    element$iv = $continuation.L$4;
                    var6_9 = (Iterator)$continuation.L$3;
                    $this$forEach$iv = (Iterable)$continuation.L$2;
                    credentials = (DatabaseCredentials)$continuation.L$1;
                    dataSource = (LocalDataSource)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl47:
                    // 2 sources

                    if (Intrinsics.areEqual((Object)(connectionResult = (TestConnectionExecutionResult)v1), (Object)TestConnectionExecutionResult.Cancelled.INSTANCE)) {
                        DatabaseResourceConnectionService.LOG.debug("Connection cancelled");
                        return Boxing.boxBoolean((boolean)false);
                    }
                    if (!(connectionResult instanceof TestConnectionExecutionResult.Failure)) break;
                    $this$debug_u24default$iv = DatabaseResourceConnectionService.LOG;
                    e$iv = null;
                    $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        var13_16 = $this$debug_u24default$iv;
                        $i$a$-debug$default-DatabaseResourceConnectionService$waitForConnection$2$1 = false;
                        var13_16.debug("Unable to connect to database, " + ((TestConnectionExecutionResult.Failure)connectionResult).getResult().getSummary(), e$iv);
                    }
                    $continuation.L$0 = dataSource;
                    $continuation.L$1 = credentials;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                    $continuation.L$3 = var6_9;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)connectionResult);
                    $continuation.I$0 = $i$f$forEach;
                    $continuation.I$1 = $i$a$-forEach-DatabaseResourceConnectionService$waitForConnection$2;
                    $continuation.label = 2;
                    v2 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)$continuation);
                    if (v2 != var17_5) ** GOTO lbl16
                    return var17_5;
                }
                case 2: {
                    $i$a$-forEach-DatabaseResourceConnectionService$waitForConnection$2 = $continuation.I$1;
                    $i$f$forEach = $continuation.I$0;
                    connectionResult = (TestConnectionExecutionResult)$continuation.L$5;
                    element$iv = $continuation.L$4;
                    var6_9 = (Iterator)$continuation.L$3;
                    $this$forEach$iv = (Iterable)$continuation.L$2;
                    credentials = (DatabaseCredentials)$continuation.L$1;
                    dataSource = (LocalDataSource)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                    ** GOTO lbl16
                }
            }
            if (connectionResult instanceof TestConnectionExecutionResult.Success) {
                return Boxing.boxBoolean((boolean)true);
            }
            throw new NoWhenBranchMatchedException();
        }
        return Boxing.boxBoolean((boolean)false);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void removeConnectionStringByUrl(String url) {
        if (url == null) {
            return;
        }
        String string = this.urlToConnectionString.remove(url);
        if (string == null) {
            return;
        }
        String connectionString = string;
        this.connectionStrings.remove(connectionString);
    }

    private static final Unit createDataSource$lambda$4(DatabaseResource $databaseResource, LocalDataSourceManager $dataSourceManager, LocalDataSource $createdDataSource) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Removing data source for " + $databaseResource.getName());
        }
        ApplicationKt.getApplication().invokeLater(() -> DatabaseResourceConnectionService.createDataSource$lambda$4$1($dataSourceManager, $createdDataSource));
        return Unit.INSTANCE;
    }

    private static final void createDataSource$lambda$4$1(LocalDataSourceManager $dataSourceManager, LocalDataSource $createdDataSource) {
        $dataSourceManager.removeDataSource($createdDataSource);
    }

    public static final /* synthetic */ Object access$addConnection(DatabaseResourceConnectionService $this, DatabaseResource databaseResource, Continuation $completion) {
        return $this.addConnection(databaseResource, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$createDataSource(DatabaseResourceConnectionService $this, String connectionString, boolean connectionStringWasModified, DatabaseResource databaseResource, Continuation $completion) {
        return $this.createDataSource(connectionString, connectionStringWasModified, databaseResource, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$modifyConnectionString-gIAlu-s(DatabaseResourceConnectionService $this, DatabaseResource databaseResource, Continuation $completion) {
        return $this.modifyConnectionString-gIAlu-s(databaseResource, (Continuation<? super Result<String>>)$completion);
    }

    public static final /* synthetic */ Object access$getContainerPorts(DatabaseResourceConnectionService $this, String containerId, Continuation $completion) {
        return $this.getContainerPorts(containerId, (Continuation<? super List<Pair<Integer, Integer>>>)$completion);
    }

    public static final /* synthetic */ Object access$getConnectionUrl(DatabaseResourceConnectionService $this, String connectionString, DatabaseResource databaseResource, DotnetDataProvider dataProvider, DatabaseDriver driver, Continuation $completion) {
        return $this.getConnectionUrl(connectionString, databaseResource, dataProvider, driver, (Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ Object access$connectToDataSource(DatabaseResourceConnectionService $this, LocalDataSource dataSource, Continuation $completion) {
        return $this.connectToDataSource(dataSource, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$waitForConnection(DatabaseResourceConnectionService $this, LocalDataSource dataSource, Continuation $completion) {
        return $this.waitForConnection(dataSource, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Project access$getProject$p(DatabaseResourceConnectionService $this) {
        return $this.project;
    }

    public static final /* synthetic */ Channel access$getConnectionCommands$p(DatabaseResourceConnectionService $this) {
        return $this.connectionCommands;
    }

    public static final /* synthetic */ Channel access$getCreatedDataSources$p(DatabaseResourceConnectionService $this) {
        return $this.createdDataSources;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DatabaseResourceConnectionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        REDIS_REGEX = new Regex(REDIS_CONNECTION_STRING_PATTERN);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/aspire/databases/DatabaseResourceConnectionService$AddDatabaseResourceConnection;", "Lcom/jetbrains/rider/aspire/databases/DatabaseResourceConnectionService$DatabaseResourceConnectionCommand;", "resource", "Lcom/jetbrains/rider/aspire/databases/DatabaseResource;", "<init>", "(Lcom/jetbrains/rider/aspire/databases/DatabaseResource;)V", "getResource", "()Lcom/jetbrains/rider/aspire/databases/DatabaseResource;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "aspire-plugin"})
    public static final class AddDatabaseResourceConnection
    implements DatabaseResourceConnectionCommand {
        @NotNull
        private final DatabaseResource resource;

        public AddDatabaseResourceConnection(@NotNull DatabaseResource resource) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            this.resource = resource;
        }

        @NotNull
        public final DatabaseResource getResource() {
            return this.resource;
        }

        @NotNull
        public final DatabaseResource component1() {
            return this.resource;
        }

        @NotNull
        public final AddDatabaseResourceConnection copy(@NotNull DatabaseResource resource) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            return new AddDatabaseResourceConnection(resource);
        }

        public static /* synthetic */ AddDatabaseResourceConnection copy$default(AddDatabaseResourceConnection addDatabaseResourceConnection, DatabaseResource databaseResource, int n, Object object) {
            if ((n & 1) != 0) {
                databaseResource = addDatabaseResourceConnection.resource;
            }
            return addDatabaseResourceConnection.copy(databaseResource);
        }

        @NotNull
        public String toString() {
            return "AddDatabaseResourceConnection(resource=" + this.resource + ")";
        }

        public int hashCode() {
            return this.resource.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AddDatabaseResourceConnection)) {
                return false;
            }
            AddDatabaseResourceConnection addDatabaseResourceConnection = (AddDatabaseResourceConnection)other;
            return Intrinsics.areEqual((Object)this.resource, (Object)addDatabaseResourceConnection.resource);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/aspire/databases/DatabaseResourceConnectionService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/aspire/databases/DatabaseResourceConnectionService;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "REDIS_CONNECTION_STRING_PATTERN", "", "REDIS_REGEX", "Lkotlin/text/Regex;", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nDatabaseResourceConnectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseResourceConnectionService.kt\ncom/jetbrains/rider/aspire/databases/DatabaseResourceConnectionService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,344:1\n30#2,2:345\n*S KotlinDebug\n*F\n+ 1 DatabaseResourceConnectionService.kt\ncom/jetbrains/rider/aspire/databases/DatabaseResourceConnectionService$Companion\n*L\n51#1:345,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DatabaseResourceConnectionService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DatabaseResourceConnectionService> serviceClass$iv = DatabaseResourceConnectionService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DatabaseResourceConnectionService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/aspire/databases/DatabaseResourceConnectionService$DataSourceListener;", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "dataSourceRemoved", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "aspire-plugin"})
    public static final class DataSourceListener
    implements DataSourceStorage.Listener {
        @NotNull
        private final Project project;

        public DataSourceListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Companion.getInstance(this.project).removeConnectionStringByUrl(dataSource.getUrl());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0001\u0002\u00a8\u0006\u0003\u00c0\u0006\u0003"}, d2={"Lcom/jetbrains/rider/aspire/databases/DatabaseResourceConnectionService$DatabaseResourceConnectionCommand;", "", "Lcom/jetbrains/rider/aspire/databases/DatabaseResourceConnectionService$AddDatabaseResourceConnection;", "aspire-plugin"})
    public static sealed interface DatabaseResourceConnectionCommand
    permits AddDatabaseResourceConnection {
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseType.values().length];
            try {
                nArray[DatabaseType.POSTGRES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.MYSQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.MSSQL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.ORACLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.MONGO.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.REDIS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

