/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.dashboard.components;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ExtensionsKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rider.aspire.AspireBundle;
import com.jetbrains.rider.aspire.dashboard.AspireResource;
import com.jetbrains.rider.aspire.dashboard.components.RowExtensionsKt;
import com.jetbrains.rider.aspire.generated.ResourceEnvironmentVariable;
import com.jetbrains.rider.aspire.generated.ResourceHealthStatus;
import com.jetbrains.rider.aspire.generated.ResourceState;
import com.jetbrains.rider.aspire.generated.ResourceType;
import com.jetbrains.rider.aspire.generated.ResourceUrl;
import com.jetbrains.rider.aspire.generated.ResourceVolume;
import com.jetbrains.rider.aspire.settings.AspireSettings;
import com.jetbrains.rider.aspire.util.AspireResourceUtilsKt;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.LocalDateTime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0014\u0010\r\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0014\u0010\u000f\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0014\u0010\u0010\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0014\u0010\u0011\u001a\u00020\u000b*\u00020\f2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0014\u0010\u0012\u001a\u00020\u000b*\u00020\f2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0014\u0010\u0013\u001a\u00020\u000b*\u00020\f2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0014\u0010\u0014\u001a\u00020\u000b*\u00020\f2\u0006\u0010\t\u001a\u00020\u0003H\u0002J$\u0010\u0015\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0019H\u0002J$\u0010\u001a\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0019H\u0002J$\u0010\u001c\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u0019H\u0002J>\u0010\u001e\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u001f*\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u0002H\u001f\u0018\u00010\u00192\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u00020\u00170!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/aspire/dashboard/components/ResourceDashboardPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "aspireResource", "Lcom/jetbrains/rider/aspire/dashboard/AspireResource;", "<init>", "(Lcom/jetbrains/rider/aspire/dashboard/AspireResource;)V", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "setUpPanel", "resourceData", "addHeader", "", "Lcom/intellij/ui/dsl/builder/Panel;", "addIconAndTitle", "Lcom/intellij/ui/dsl/builder/Row;", "addStateAndHealth", "addActionButtons", "addEndpoints", "addProperties", "addVolumes", "addEnvironmentVariables", "stringPropertyRow", "label", "", "property", "Lcom/jetbrains/rider/aspire/dashboard/AspireResource$AspireResourceProperty;", "intPropertyRow", "", "pathPropertyRow", "Ljava/nio/file/Path;", "propertyRow", "T", "mapper", "Lkotlin/Function1;", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nResourceDashboardPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceDashboardPanel.kt\ncom/jetbrains/rider/aspire/dashboard/components/ResourceDashboardPanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n12970#2,2:276\n6572#2:278\n6572#2:281\n13805#2,2:284\n1869#3,2:279\n1869#3,2:282\n1#4:286\n*S KotlinDebug\n*F\n+ 1 ResourceDashboardPanel.kt\ncom/jetbrains/rider/aspire/dashboard/components/ResourceDashboardPanel\n*L\n140#1:276,2\n156#1:278\n218#1:281\n242#1:284,2\n157#1:279,2\n219#1:282,2\n*E\n"})
public final class ResourceDashboardPanel
extends BorderLayoutPanel {
    @NotNull
    private DialogPanel panel;

    public ResourceDashboardPanel(@NotNull AspireResource aspireResource) {
        Intrinsics.checkNotNullParameter((Object)aspireResource, (String)"aspireResource");
        this.panel = this.setUpPanel(aspireResource);
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)10));
        this.add(ScrollPaneFactory.createScrollPane((Component)((Component)this.panel), (int)0));
    }

    private final DialogPanel setUpPanel(AspireResource resourceData) {
        return BuilderKt.panel(arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$0(this, resourceData, arg_0));
    }

    private final void addHeader(Panel $this$addHeader, AspireResource resourceData) {
        Panel.row$default((Panel)$this$addHeader, null, arg_0 -> ResourceDashboardPanel.addHeader$lambda$0(this, resourceData, arg_0), (int)1, null);
        Panel.separator$default((Panel)$this$addHeader, null, (int)1, null);
    }

    private final void addIconAndTitle(Row $this$addIconAndTitle, AspireResource resourceData) {
        block5: {
            AspireResource.AspireResourceProperty<Path> it;
            Icon resourceIcon = AspireResourceUtilsKt.getIcon(resourceData);
            $this$addIconAndTitle.icon(resourceIcon).gap(RightGap.SMALL);
            RowExtensionsKt.copyableLabel$default($this$addIconAndTitle, resourceData.getDisplayName(), null, null, 6, null).bold().gap(RightGap.SMALL);
            if (resourceData.getType() == ResourceType.Project) {
                AspireResource.AspireResourceProperty<Path> aspireResourceProperty = resourceData.getProjectPath();
                if (aspireResourceProperty != null && (aspireResourceProperty = aspireResourceProperty.getValue()) != null) {
                    it = aspireResourceProperty;
                    boolean bl = false;
                    RowExtensionsKt.copyableLabel$default($this$addIconAndTitle, ((Object)it.getFileName()).toString(), null, UIUtil.FontColor.BRIGHTER, 2, null).gap(RightGap.SMALL);
                }
            }
            if (resourceData.getType() == ResourceType.Container) {
                AspireResource.AspireResourceProperty<String> aspireResourceProperty = resourceData.getContainerImage();
                if (aspireResourceProperty != null && (aspireResourceProperty = aspireResourceProperty.getValue()) != null) {
                    it = aspireResourceProperty;
                    boolean bl = false;
                    RowExtensionsKt.copyableLabel$default($this$addIconAndTitle, (String)((Object)it), null, UIUtil.FontColor.BRIGHTER, 2, null).gap(RightGap.SMALL);
                }
            }
            if (resourceData.getType() != ResourceType.Executable) break block5;
            AspireResource.AspireResourceProperty<Path> aspireResourceProperty = resourceData.getExecutablePath();
            if (aspireResourceProperty != null && (aspireResourceProperty = aspireResourceProperty.getValue()) != null) {
                it = aspireResourceProperty;
                boolean bl = false;
                RowExtensionsKt.copyableLabel$default($this$addIconAndTitle, ((Object)it.getFileName()).toString(), null, UIUtil.FontColor.BRIGHTER, 2, null).gap(RightGap.SMALL);
            }
        }
    }

    private final void addStateAndHealth(Row $this$addStateAndHealth, AspireResource resourceData) {
        ResourceState state = resourceData.getState();
        if (state != null) {
            Cell cell;
            RowExtensionsKt.separator($this$addStateAndHealth).gap(RightGap.SMALL);
            ResourceHealthStatus healthStatus = resourceData.getHealthStatus();
            boolean hasHealthStatus = state == ResourceState.Running && healthStatus != null;
            Cell $this$addStateAndHealth_u24lambda_u240 = cell = RowExtensionsKt.copyableLabel$default($this$addStateAndHealth, state.name(), null, UIUtil.FontColor.BRIGHTER, 2, null);
            boolean bl = false;
            Cell cell2 = hasHealthStatus ? $this$addStateAndHealth_u24lambda_u240.gap(RightGap.SMALL) : $this$addStateAndHealth_u24lambda_u240.gap(RightGap.COLUMNS);
            if (hasHealthStatus) {
                RowExtensionsKt.copyableLabel$default($this$addStateAndHealth, "(" + healthStatus.name() + ")", null, UIUtil.FontColor.BRIGHTER, 2, null).gap(RightGap.COLUMNS);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void addActionButtons(Row $this$addActionButtons, AspireResource resourceData) {
        block7: {
            startAction = ActionManager.getInstance().getAction("Aspire.Resource.Start");
            Intrinsics.checkNotNull((Object)startAction);
            ExtensionsKt.actionButton$default((Row)$this$addActionButtons, (AnAction)startAction, null, (int)2, null);
            stopAction = ActionManager.getInstance().getAction("Aspire.Resource.Stop");
            Intrinsics.checkNotNull((Object)stopAction);
            ExtensionsKt.actionButton$default((Row)$this$addActionButtons, (AnAction)stopAction, null, (int)2, null);
            if (resourceData.getType() != ResourceType.Project) ** GOTO lbl-1000
            v0 = resourceData.getProjectPath();
            if ((v0 != null ? v0.getValue() : null) != null) {
                restartWithoutDebuggerAction = ActionManager.getInstance().getAction("Aspire.Resource.RestartWithoutDebugger");
                Intrinsics.checkNotNull((Object)restartWithoutDebuggerAction);
                ExtensionsKt.actionButton$default((Row)$this$addActionButtons, (AnAction)restartWithoutDebuggerAction, null, (int)2, null);
                restartWithDebuggerAction = ActionManager.getInstance().getAction("Aspire.Resource.RestartWithDebugger");
                Intrinsics.checkNotNull((Object)restartWithDebuggerAction);
                v1 = ExtensionsKt.actionButton$default((Row)$this$addActionButtons, (AnAction)restartWithDebuggerAction, null, (int)2, null);
            } else lbl-1000:
            // 2 sources

            {
                restartAction = ActionManager.getInstance().getAction("Aspire.Resource.Restart");
                Intrinsics.checkNotNull((Object)restartAction);
                v1 = ExtensionsKt.actionButton$default((Row)$this$addActionButtons, (AnAction)restartAction, null, (int)2, null);
            }
            if (resourceData.getType() == ResourceType.Project && resourceData.getState() == ResourceState.Running) {
                v2 = resourceData.getPid();
                if ((v2 != null ? v2.getValue() : null) != null && Intrinsics.areEqual((Object)resourceData.isUnderDebugger(), (Object)false)) {
                    attachAction = ActionManager.getInstance().getAction("Aspire.Resource.Attach");
                    Intrinsics.checkNotNull((Object)attachAction);
                    ExtensionsKt.actionButton$default((Row)$this$addActionButtons, (AnAction)attachAction, null, (int)2, null);
                }
            }
            if (resourceData.getType() == ResourceType.Project && resourceData.getState() == ResourceState.Running && Intrinsics.areEqual((Object)resourceData.isUnderDebugger(), (Object)true)) {
                attachAction = ActionManager.getInstance().getAction("Aspire.Resource.NavigateToDebugTab");
                Intrinsics.checkNotNull((Object)attachAction);
                ExtensionsKt.actionButton$default((Row)$this$addActionButtons, (AnAction)attachAction, null, (int)2, null);
            }
            $this$any$iv = resourceData.getCommands();
            $i$f$any = false;
            var8_9 = $this$any$iv.length;
            for (var7_8 = 0; var7_8 < var8_9; ++var7_8) {
                it = element$iv = $this$any$iv[var7_8];
                $i$a$-any-ResourceDashboardPanel$addActionButtons$1 = false;
                if (!(StringsKt.equals((String)it.getName(), (String)"resource-start", (boolean)true) == false && StringsKt.equals((String)it.getName(), (String)"resource-stop", (boolean)true) == false && StringsKt.equals((String)it.getName(), (String)"resource-restart", (boolean)true) == false)) continue;
                v3 = true;
                break block7;
            }
            v3 = false;
        }
        if (v3) {
            executeCommandAction = ActionManager.getInstance().getAction("Aspire.Resource.Execute.Command");
            Intrinsics.checkNotNull((Object)executeCommandAction);
            ExtensionsKt.actionButton$default((Row)$this$addActionButtons, (AnAction)executeCommandAction, null, (int)2, null);
        }
    }

    private final void addEndpoints(Panel $this$addEndpoints, AspireResource resourceData) {
        if (!(resourceData.getUrls().length == 0)) {
            Panel.row$default((Panel)$this$addEndpoints, null, ResourceDashboardPanel::addEndpoints$lambda$0, (int)1, null).bottomGap(BottomGap.SMALL);
            Object[] $this$sortedBy$iv = resourceData.getUrls();
            boolean $i$f$sortedBy = false;
            Iterable $this$forEach$iv = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ResourceUrl it = (ResourceUrl)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getSortOrder());
                    it = (ResourceUrl)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getSortOrder()));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CharSequence charSequence;
                ResourceUrl url = (ResourceUrl)element$iv;
                boolean bl = false;
                if (url.isInternal()) continue;
                String endpointName = ((CharSequence)url.getDisplayName()).length() > 0 ? url.getDisplayName() : (!((charSequence = (CharSequence)url.getEndpointName()) == null || charSequence.length() == 0) ? url.getEndpointName() : "-");
                $this$addEndpoints.row(endpointName, arg_0 -> ResourceDashboardPanel.addEndpoints$lambda$2$0(url, arg_0));
            }
            Panel.separator$default((Panel)$this$addEndpoints, null, (int)1, null);
        }
    }

    private final void addProperties(Panel $this$addProperties, AspireResource resourceData) {
        Enum it;
        Panel.row$default((Panel)$this$addProperties, null, ResourceDashboardPanel::addProperties$lambda$0, (int)1, null).bottomGap(BottomGap.SMALL);
        AspireResource $this$addProperties_u24lambda_u241 = resourceData;
        boolean bl = false;
        ResourceState resourceState = $this$addProperties_u24lambda_u241.getState();
        if (resourceState != null) {
            it = resourceState;
            boolean bl2 = false;
            $this$addProperties.row(AspireBundle.message("service.tab.dashboard.properties.state", new Object[0]), arg_0 -> ResourceDashboardPanel.addProperties$lambda$1$0$0((ResourceState)it, arg_0));
        }
        ResourceHealthStatus resourceHealthStatus = $this$addProperties_u24lambda_u241.getHealthStatus();
        if (resourceHealthStatus != null) {
            it = resourceHealthStatus;
            boolean bl3 = false;
            $this$addProperties.row(AspireBundle.message("service.tab.dashboard.properties.health.status", new Object[0]), arg_0 -> ResourceDashboardPanel.addProperties$lambda$1$1$0((ResourceHealthStatus)it, arg_0));
        }
        LocalDateTime localDateTime = $this$addProperties_u24lambda_u241.getCreatedAt();
        if (localDateTime != null) {
            it = localDateTime;
            boolean bl4 = false;
            $this$addProperties.row(AspireBundle.message("service.tab.dashboard.properties.creation.time", new Object[0]), arg_0 -> ResourceDashboardPanel.addProperties$lambda$1$2$0((LocalDateTime)it, arg_0));
        }
        LocalDateTime localDateTime2 = $this$addProperties_u24lambda_u241.getStartedAt();
        if (localDateTime2 != null) {
            it = localDateTime2;
            boolean bl5 = false;
            $this$addProperties.row(AspireBundle.message("service.tab.dashboard.properties.start.time", new Object[0]), arg_0 -> ResourceDashboardPanel.addProperties$lambda$1$3$0((LocalDateTime)it, arg_0));
        }
        LocalDateTime localDateTime3 = $this$addProperties_u24lambda_u241.getStoppedAt();
        if (localDateTime3 != null) {
            it = localDateTime3;
            boolean bl6 = false;
            $this$addProperties.row(AspireBundle.message("service.tab.dashboard.properties.stop.time", new Object[0]), arg_0 -> ResourceDashboardPanel.addProperties$lambda$1$4$0((LocalDateTime)it, arg_0));
        }
        this.intPropertyRow($this$addProperties, AspireBundle.message("service.tab.dashboard.properties.pid", new Object[0]), resourceData.getPid());
        this.intPropertyRow($this$addProperties, AspireBundle.message("service.tab.dashboard.properties.exit.code", new Object[0]), resourceData.getExitCode());
        this.pathPropertyRow($this$addProperties, AspireBundle.message("service.tab.dashboard.properties.project", new Object[0]), $this$addProperties_u24lambda_u241.getProjectPath());
        this.pathPropertyRow($this$addProperties, AspireBundle.message("service.tab.dashboard.properties.executable", new Object[0]), $this$addProperties_u24lambda_u241.getExecutablePath());
        this.pathPropertyRow($this$addProperties, AspireBundle.message("service.tab.dashboard.properties.working.dir", new Object[0]), $this$addProperties_u24lambda_u241.getExecutableWorkDir());
        this.stringPropertyRow($this$addProperties, AspireBundle.message("service.tab.dashboard.properties.args", new Object[0]), $this$addProperties_u24lambda_u241.getArgs());
        this.stringPropertyRow($this$addProperties, AspireBundle.message("service.tab.dashboard.properties.container.image", new Object[0]), $this$addProperties_u24lambda_u241.getContainerImage());
        this.stringPropertyRow($this$addProperties, AspireBundle.message("service.tab.dashboard.properties.container.id", new Object[0]), $this$addProperties_u24lambda_u241.getContainerId());
        this.stringPropertyRow($this$addProperties, AspireBundle.message("service.tab.dashboard.properties.container.ports", new Object[0]), $this$addProperties_u24lambda_u241.getContainerPorts());
        this.stringPropertyRow($this$addProperties, AspireBundle.message("service.tab.dashboard.properties.container.command", new Object[0]), $this$addProperties_u24lambda_u241.getContainerCommand());
        this.stringPropertyRow($this$addProperties, AspireBundle.message("service.tab.dashboard.properties.container.args", new Object[0]), $this$addProperties_u24lambda_u241.getContainerArgs());
        this.stringPropertyRow($this$addProperties, AspireBundle.message("service.tab.dashboard.properties.connection.string", new Object[0]), $this$addProperties_u24lambda_u241.getConnectionString());
        this.stringPropertyRow($this$addProperties, AspireBundle.message("service.tab.dashboard.properties.source", new Object[0]), $this$addProperties_u24lambda_u241.getSource());
        this.stringPropertyRow($this$addProperties, AspireBundle.message("service.tab.dashboard.properties.value", new Object[0]), $this$addProperties_u24lambda_u241.getValue());
        Panel.separator$default((Panel)$this$addProperties, null, (int)1, null);
    }

    private final void addVolumes(Panel $this$addVolumes, AspireResource resourceData) {
        if (!(resourceData.getVolumes().length == 0)) {
            Panel.row$default((Panel)$this$addVolumes, null, ResourceDashboardPanel::addVolumes$lambda$0, (int)1, null).bottomGap(BottomGap.SMALL);
            Object[] $this$sortedBy$iv = resourceData.getVolumes();
            boolean $i$f$sortedBy = false;
            Iterable $this$forEach$iv = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ResourceVolume it = (ResourceVolume)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getSource());
                    it = (ResourceVolume)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSource())));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResourceVolume volume = (ResourceVolume)element$iv;
                boolean bl = false;
                Panel.row$default((Panel)$this$addVolumes, null, arg_0 -> ResourceDashboardPanel.addVolumes$lambda$2$0(volume, arg_0), (int)1, null);
            }
            Panel.separator$default((Panel)$this$addVolumes, null, (int)1, null);
        }
    }

    private final void addEnvironmentVariables(Panel $this$addEnvironmentVariables, AspireResource resourceData) {
        boolean showEnvironment = AspireSettings.Companion.getInstance().getShowEnvironmentVariables();
        if (!(resourceData.getEnvironment().length == 0)) {
            Panel.row$default((Panel)$this$addEnvironmentVariables, null, ResourceDashboardPanel::addEnvironmentVariables$lambda$0, (int)1, null).bottomGap(BottomGap.SMALL);
            ResourceEnvironmentVariable[] $this$forEach$iv = resourceData.getEnvironment();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String string;
                ResourceEnvironmentVariable element$iv;
                ResourceEnvironmentVariable variable = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (showEnvironment) {
                    string = variable.getValue();
                    if (string == null) {
                        string = "-";
                    }
                } else {
                    string = "*****";
                }
                String valueText = string;
                Panel.row$default((Panel)$this$addEnvironmentVariables, null, arg_0 -> ResourceDashboardPanel.addEnvironmentVariables$lambda$1$0(variable, valueText, arg_0), (int)1, null);
            }
        }
    }

    private final void stringPropertyRow(Panel $this$stringPropertyRow, String label, AspireResource.AspireResourceProperty<String> property) {
        this.propertyRow($this$stringPropertyRow, label, property, ResourceDashboardPanel::stringPropertyRow$lambda$0);
    }

    private final void intPropertyRow(Panel $this$intPropertyRow, String label, AspireResource.AspireResourceProperty<Integer> property) {
        this.propertyRow($this$intPropertyRow, label, property, ResourceDashboardPanel::intPropertyRow$lambda$0);
    }

    private final void pathPropertyRow(Panel $this$pathPropertyRow, String label, AspireResource.AspireResourceProperty<Path> property) {
        this.propertyRow($this$pathPropertyRow, label, property, ResourceDashboardPanel::pathPropertyRow$lambda$0);
    }

    private final <T> void propertyRow(Panel $this$propertyRow, String label, AspireResource.AspireResourceProperty<T> property, Function1<? super T, String> mapper) {
        if (property == null) {
            return;
        }
        T value = property.getValue();
        boolean showSensitive = AspireSettings.Companion.getInstance().getShowSensitiveProperties();
        String text = showSensitive || !property.isSensitive() ? (String)mapper.invoke(value) : "*****";
        $this$propertyRow.row(label, arg_0 -> ResourceDashboardPanel.propertyRow$lambda$0(text, arg_0));
    }

    private static final Unit setUpPanel$lambda$0(ResourceDashboardPanel this$0, AspireResource $resourceData, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        this$0.addHeader($this$panel, $resourceData);
        this$0.addProperties($this$panel, $resourceData);
        this$0.addEndpoints($this$panel, $resourceData);
        this$0.addVolumes($this$panel, $resourceData);
        this$0.addEnvironmentVariables($this$panel, $resourceData);
        return Unit.INSTANCE;
    }

    private static final Unit addHeader$lambda$0(ResourceDashboardPanel this$0, AspireResource $resourceData, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.addIconAndTitle($this$row, $resourceData);
        this$0.addStateAndHealth($this$row, $resourceData);
        this$0.addActionButtons($this$row, $resourceData);
        return Unit.INSTANCE;
    }

    private static final Unit addEndpoints$lambda$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(AspireBundle.message("service.tab.dashboard.endpoints", new Object[0])).bold();
        return Unit.INSTANCE;
    }

    private static final Unit addEndpoints$lambda$2$0(ResourceUrl $url, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.link($url.getFullUrl(), arg_0 -> ResourceDashboardPanel.addEndpoints$lambda$2$0$0($url, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit addEndpoints$lambda$2$0$0(ResourceUrl $url, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BrowserUtil.browse((String)$url.getFullUrl());
        return Unit.INSTANCE;
    }

    private static final Unit addProperties$lambda$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(AspireBundle.message("service.tab.dashboard.properties", new Object[0])).bold();
        return Unit.INSTANCE;
    }

    private static final Unit addProperties$lambda$1$0$0(ResourceState $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it.name(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit addProperties$lambda$1$1$0(ResourceHealthStatus $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it.name(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit addProperties$lambda$1$2$0(LocalDateTime $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it.toString(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit addProperties$lambda$1$3$0(LocalDateTime $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it.toString(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit addProperties$lambda$1$4$0(LocalDateTime $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it.toString(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit addVolumes$lambda$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(AspireBundle.message("service.tab.dashboard.volumes", new Object[0])).bold();
        return Unit.INSTANCE;
    }

    private static final Unit addVolumes$lambda$2$0(ResourceVolume $volume, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $volume.getSource() + " : " + $volume.getTarget(), null, null, 6, null).gap(RightGap.SMALL);
        Cell $this$addVolumes_u24lambda_u242_u240_u240 = cell = RowExtensionsKt.copyableLabel$default($this$row, $volume.getMountType(), null, UIUtil.FontColor.BRIGHTER, 2, null);
        boolean bl = false;
        if ($volume.isReadOnly()) {
            $this$addVolumes_u24lambda_u242_u240_u240.gap(RightGap.SMALL);
        }
        if ($volume.isReadOnly()) {
            RowExtensionsKt.copyableLabel$default($this$row, "(" + AspireBundle.message("service.tab.dashboard.volumes.readonly", new Object[0]) + ")", null, null, 6, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addEnvironmentVariables$lambda$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(AspireBundle.message("service.tab.dashboard.environment", new Object[0])).bold();
        return Unit.INSTANCE;
    }

    private static final Unit addEnvironmentVariables$lambda$1$0(ResourceEnvironmentVariable $variable, String $valueText, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $variable.getKey() + " = " + $valueText, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final String stringPropertyRow$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final String intPropertyRow$lambda$0(int it) {
        return String.valueOf(it);
    }

    private static final String pathPropertyRow$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)it.toAbsolutePath()).toString();
    }

    private static final Unit propertyRow$lambda$0(String $text, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $text, null, null, 6, null);
        return Unit.INSTANCE;
    }
}

