/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.dashboard;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.aspire.dashboard.AspireHostServiceViewDescriptor;
import com.jetbrains.rider.aspire.dashboard.AspireMainServiceViewContributor;
import com.jetbrains.rider.aspire.dashboard.AspireProjectResourceProfileData;
import com.jetbrains.rider.aspire.dashboard.AspireResource;
import com.jetbrains.rider.aspire.dashboard.AspireResourceServiceViewDescriptor;
import com.jetbrains.rider.aspire.generated.AspireHostModel;
import com.jetbrains.rider.aspire.generated.AspireHostModelConfig;
import com.jetbrains.rider.aspire.generated.CreateSessionRequest;
import com.jetbrains.rider.aspire.generated.CreateSessionResponse;
import com.jetbrains.rider.aspire.generated.DeleteSessionRequest;
import com.jetbrains.rider.aspire.generated.DeleteSessionResponse;
import com.jetbrains.rider.aspire.generated.LogReceived;
import com.jetbrains.rider.aspire.generated.ProcessStarted;
import com.jetbrains.rider.aspire.generated.ProcessTerminated;
import com.jetbrains.rider.aspire.generated.ResourceState;
import com.jetbrains.rider.aspire.generated.ResourceType;
import com.jetbrains.rider.aspire.generated.ResourceWrapper;
import com.jetbrains.rider.aspire.otlp.OpenTelemetryProtocolServerExtension;
import com.jetbrains.rider.aspire.run.AspireHostConfiguration;
import com.jetbrains.rider.aspire.sessions.SessionEvent;
import com.jetbrains.rider.aspire.sessions.SessionLogReceived;
import com.jetbrains.rider.aspire.sessions.SessionManager;
import com.jetbrains.rider.aspire.sessions.SessionStarted;
import com.jetbrains.rider.aspire.sessions.SessionTerminated;
import com.jetbrains.rider.aspire.sessions.projectLaunchers.ProjectSessionProfile;
import com.jetbrains.rider.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.rider.run.ConsoleKind;
import com.jetbrains.rider.run.DotNetProcessRunProfileStateKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 `2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0003:\u0001`B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010&\u001a\u00020\u0000H\u0016J\u0010\u0010'\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020)2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0002H\u0016J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020)J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020)J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00020)2\u0006\u00100\u001a\u00020\u0014J\u0010\u00101\u001a\u0004\u0018\u00010\u00022\u0006\u00102\u001a\u00020\u0005J\u0016\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208J.\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>2\u0006\u0010@\u001a\u00020A2\u0006\u00107\u001a\u000208H\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002J\u001e\u0010F\u001a\u0002042\u0006\u0010G\u001a\u00020?2\u0006\u00105\u001a\u000206H\u0082@\u00a2\u0006\u0002\u0010HJ \u0010I\u001a\u0002042\u0006\u0010J\u001a\u00020\u00142\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u000208H\u0002J\u0010\u0010N\u001a\u0002042\u0006\u0010O\u001a\u00020AH\u0002J\u0018\u0010P\u001a\u0002042\u0006\u0010O\u001a\u00020A2\u0006\u0010Q\u001a\u000208H\u0002J\u0010\u0010R\u001a\u0002042\u0006\u0010S\u001a\u00020TH\u0002J\b\u0010U\u001a\u000204H\u0002J\u0010\u0010V\u001a\u0002042\u0006\u0010W\u001a\u00020\u0002H\u0002J\u0010\u0010V\u001a\u0002042\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010Z\u001a\u0002042\u0006\u0010X\u001a\u00020YH\u0002J\b\u0010[\u001a\u000204H\u0002J\b\u0010\\\u001a\u000204H\u0002J\b\u0010]\u001a\u000204H\u0002J\b\u0010^\u001a\u000204H\u0002J\b\u0010_\u001a\u000204H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\u0004\u0018\u00010\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0019R\"\u0010#\u001a\u0004\u0018\u00010\"2\b\u0010\u001a\u001a\u0004\u0018\u00010\"@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006a"}, d2={"Lcom/jetbrains/rider/aspire/dashboard/AspireHost;", "Lcom/intellij/execution/services/ServiceViewProvidingContributor;", "Lcom/jetbrains/rider/aspire/dashboard/AspireResource;", "Lcom/intellij/openapi/Disposable;", "hostProjectPath", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/openapi/project/Project;)V", "getHostProjectPath", "()Ljava/nio/file/Path;", "descriptor", "Lcom/jetbrains/rider/aspire/dashboard/AspireHostServiceViewDescriptor;", "getDescriptor", "()Lcom/jetbrains/rider/aspire/dashboard/AspireHostServiceViewDescriptor;", "descriptor$delegate", "Lkotlin/Lazy;", "resources", "Ljava/util/concurrent/ConcurrentHashMap;", "", "resourceProfileData", "Lcom/jetbrains/rider/aspire/dashboard/AspireProjectResourceProfileData;", "hostProjectPathString", "getHostProjectPathString", "()Ljava/lang/String;", "value", "displayName", "getDisplayName", "", "isActive", "()Z", "dashboardUrl", "getDashboardUrl", "Lcom/intellij/execution/ui/ConsoleView;", "consoleView", "getConsoleView", "()Lcom/intellij/execution/ui/ConsoleView;", "asService", "getViewDescriptor", "getServices", "", "getServiceDescriptor", "Lcom/jetbrains/rider/aspire/dashboard/AspireResourceServiceViewDescriptor;", "aspireResource", "getResources", "getParentResources", "getChildResourcesFor", "resourceName", "getProjectResource", "projectPath", "setAspireHostModel", "", "model", "Lcom/jetbrains/rider/aspire/generated/AspireHostModel;", "aspireHostLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "createSession", "Lcom/jetbrains/rider/aspire/generated/CreateSessionResponse;", "createSessionRequest", "Lcom/jetbrains/rider/aspire/generated/CreateSessionRequest;", "sessionEvents", "Lkotlinx/coroutines/channels/Channel;", "Lcom/jetbrains/rider/aspire/sessions/SessionEvent;", "aspireHostConfig", "Lcom/jetbrains/rider/aspire/generated/AspireHostModelConfig;", "deleteSession", "Lcom/jetbrains/rider/aspire/generated/DeleteSessionResponse;", "deleteSessionRequest", "Lcom/jetbrains/rider/aspire/generated/DeleteSessionRequest;", "handleSessionEvent", "sessionEvent", "(Lcom/jetbrains/rider/aspire/sessions/SessionEvent;Lcom/jetbrains/rider/aspire/generated/AspireHostModel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "viewResource", "resourceId", "resourceModel", "Lcom/jetbrains/rider/aspire/generated/ResourceWrapper;", "resourceLifetime", "setAspireHostUrl", "config", "setOTLPEndpointUrl", "lifetime", "hostStarted", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "hostStopped", "setProfileDataForResource", "resource", "profile", "Lcom/jetbrains/rider/aspire/sessions/projectLaunchers/ProjectSessionProfile;", "removeProfileData", "selectHost", "expand", "sendServiceChangedEvent", "sendServiceChildrenChangedEvent", "dispose", "Companion", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nAspireHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspireHost.kt\ncom/jetbrains/rider/aspire/dashboard/AspireHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,371:1\n67#2,4:372\n67#2,4:376\n67#2,4:380\n67#2,4:384\n67#2,4:388\n67#2,4:392\n67#2,4:407\n67#2,4:411\n13#2:422\n669#3,11:396\n295#3,2:415\n774#3:417\n865#3,2:418\n1869#3,2:420\n*S KotlinDebug\n*F\n+ 1 AspireHost.kt\ncom/jetbrains/rider/aspire/dashboard/AspireHost\n*L\n186#1:372,4\n202#1:376,4\n214#1:380,4\n221#1:384,4\n228#1:388,4\n241#1:392,4\n279#1:407,4\n304#1:411,4\n46#1:422\n270#1:396,11\n317#1:415,2\n327#1:417\n327#1:418,2\n328#1:420,2\n*E\n"})
public final class AspireHost
implements ServiceViewProvidingContributor<AspireResource, AspireHost>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path hostProjectPath;
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy descriptor$delegate;
    @NotNull
    private final ConcurrentHashMap<String, AspireResource> resources;
    @NotNull
    private final ConcurrentHashMap<String, AspireProjectResourceProfileData> resourceProfileData;
    @NotNull
    private final String hostProjectPathString;
    @NotNull
    private String displayName;
    private boolean isActive;
    @Nullable
    private String dashboardUrl;
    @Nullable
    private ConsoleView consoleView;
    @NotNull
    private static final Logger LOG;

    public AspireHost(@NotNull Path hostProjectPath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)hostProjectPath, (String)"hostProjectPath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.hostProjectPath = hostProjectPath;
        this.project = project;
        this.descriptor$delegate = LazyKt.lazy(() -> AspireHost.descriptor_delegate$lambda$0(this));
        this.resources = new ConcurrentHashMap();
        this.resourceProfileData = new ConcurrentHashMap();
        this.hostProjectPathString = ((Object)this.hostProjectPath.toAbsolutePath()).toString();
        this.displayName = PathsKt.getNameWithoutExtension((Path)this.hostProjectPath);
        this.project.getMessageBus().connect((Disposable)this).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(String executorId, ExecutionEnvironment env, ProcessHandler handler) {
                Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
                RunProfile runProfile = env.getRunProfile();
                Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
                RunProfile profile = runProfile;
                if (profile instanceof AspireHostConfiguration) {
                    Path path = Paths.get(((AspireHostConfiguration)profile).getParameters().getProjectFilePath(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    Path projectFilePath = path;
                    if (!Intrinsics.areEqual((Object)this.getHostProjectPath(), (Object)projectFilePath)) {
                        return;
                    }
                    this.hostStarted(handler);
                } else if (profile instanceof ProjectSessionProfile) {
                    Path path = ((ProjectSessionProfile)profile).getAspireHostProjectPath();
                    if (path == null) {
                        return;
                    }
                    Path aspireHostProjectPath = path;
                    if (!Intrinsics.areEqual((Object)this.getHostProjectPath(), (Object)aspireHostProjectPath)) {
                        return;
                    }
                    this.setProfileDataForResource((ProjectSessionProfile)profile);
                }
            }

            public void processTerminated(String executorId, ExecutionEnvironment env, ProcessHandler handler, int exitCode) {
                Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
                RunProfile runProfile = env.getRunProfile();
                Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
                RunProfile profile = runProfile;
                if (profile instanceof AspireHostConfiguration) {
                    Path path = Paths.get(((AspireHostConfiguration)profile).getParameters().getProjectFilePath(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    Path projectFilePath = path;
                    if (!Intrinsics.areEqual((Object)this.getHostProjectPath(), (Object)projectFilePath)) {
                        return;
                    }
                    this.hostStopped();
                } else if (profile instanceof ProjectSessionProfile) {
                    Path path = ((ProjectSessionProfile)profile).getAspireHostProjectPath();
                    if (path == null) {
                        return;
                    }
                    Path aspireHostProjectPath = path;
                    if (!Intrinsics.areEqual((Object)this.getHostProjectPath(), (Object)aspireHostProjectPath)) {
                        return;
                    }
                    this.removeProfileData((ProjectSessionProfile)profile);
                }
            }
        });
    }

    @NotNull
    public final Path getHostProjectPath() {
        return this.hostProjectPath;
    }

    private final AspireHostServiceViewDescriptor getDescriptor() {
        Lazy lazy = this.descriptor$delegate;
        return (AspireHostServiceViewDescriptor)lazy.getValue();
    }

    @NotNull
    public final String getHostProjectPathString() {
        return this.hostProjectPathString;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    @Nullable
    public final String getDashboardUrl() {
        return this.dashboardUrl;
    }

    @Nullable
    public final ConsoleView getConsoleView() {
        return this.consoleView;
    }

    @NotNull
    public AspireHost asService() {
        return this;
    }

    @NotNull
    public AspireHostServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getDescriptor();
    }

    @NotNull
    public List<AspireResource> getServices(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getParentResources();
    }

    @NotNull
    public AspireResourceServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull AspireResource aspireResource) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)aspireResource, (String)"aspireResource");
        return aspireResource.getViewDescriptor(project);
    }

    @NotNull
    public final List<AspireResource> getResources() {
        Function1[] function1Array;
        Function1[] $this$getResources_u24lambda_u240 = function1Array = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterator<AspireResource> iterator = this.resources.values().iterator();
        while (iterator.hasNext()) {
            AspireResource resource;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (resource.isHidden() || resource.getState() == ResourceState.Hidden) continue;
            $this$getResources_u24lambda_u240.add(resource);
        }
        Iterable iterable = CollectionsKt.build((List)function1Array);
        function1Array = new Function1[]{AspireHost::getResources$lambda$1, AspireHost::getResources$lambda$2};
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
    }

    @NotNull
    public final List<AspireResource> getParentResources() {
        Function1[] function1Array;
        Function1[] $this$getParentResources_u24lambda_u240 = function1Array = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterator<AspireResource> iterator = this.resources.values().iterator();
        while (iterator.hasNext()) {
            String parentResourceName;
            AspireResource resource;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (resource.isHidden() || resource.getState() == ResourceState.Hidden || (parentResourceName = resource.getParentResourceName()) != null) continue;
            $this$getParentResources_u24lambda_u240.add(resource);
        }
        Iterable iterable = CollectionsKt.build((List)function1Array);
        function1Array = new Function1[]{AspireHost::getParentResources$lambda$1, AspireHost::getParentResources$lambda$2};
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
    }

    @NotNull
    public final List<AspireResource> getChildResourcesFor(@NotNull String resourceName) {
        Function1[] function1Array;
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        Function1[] $this$getChildResourcesFor_u24lambda_u240 = function1Array = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterator<AspireResource> iterator = this.resources.values().iterator();
        while (iterator.hasNext()) {
            String parentResourceName;
            AspireResource resource;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (resource.isHidden() || resource.getState() == ResourceState.Hidden || !Intrinsics.areEqual((Object)(parentResourceName = resource.getParentResourceName()), (Object)resourceName)) continue;
            $this$getChildResourcesFor_u24lambda_u240.add(resource);
        }
        Iterable iterable = CollectionsKt.build((List)function1Array);
        function1Array = new Function1[]{AspireHost::getChildResourcesFor$lambda$1, AspireHost::getChildResourcesFor$lambda$2};
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
    }

    @Nullable
    public final AspireResource getProjectResource(@NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        for (Map.Entry resource : ((Map)this.resources).entrySet()) {
            if (((AspireResource)resource.getValue()).getType() != ResourceType.Project || ((AspireResource)resource.getValue()).isHidden() || ((AspireResource)resource.getValue()).getState() == ResourceState.Hidden) continue;
            AspireResource.AspireResourceProperty<Path> aspireResourceProperty = ((AspireResource)resource.getValue()).getProjectPath();
            if (!Intrinsics.areEqual((Object)(aspireResourceProperty != null ? aspireResourceProperty.getValue() : null), (Object)projectPath)) continue;
            return (AspireResource)resource.getValue();
        }
        return null;
    }

    public final void setAspireHostModel(@NotNull AspireHostModel model, @NotNull Lifetime aspireHostLifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)aspireHostLifetime, (String)"aspireHostLifetime");
        LOG.trace(" Subscribing to Aspire host model");
        this.setAspireHostUrl(model.getConfig());
        this.setOTLPEndpointUrl(model.getConfig(), aspireHostLifetime);
        Channel sessionEvents = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        IRdEndpoint.DefaultImpls.set$default(model.getCreateSession(), null, null, arg_0 -> AspireHost.setAspireHostModel$lambda$0(this, sessionEvents, model, aspireHostLifetime, arg_0), (int)3, null);
        IRdEndpoint.DefaultImpls.set$default(model.getDeleteSession(), null, null, arg_0 -> AspireHost.setAspireHostModel$lambda$1(this, arg_0), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)aspireHostLifetime.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Channel<SessionEvent>)sessionEvents, this, model, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ Channel<SessionEvent> $sessionEvents;
            final /* synthetic */ AspireHost this$0;
            final /* synthetic */ AspireHostModel $model;
            {
                this.$sessionEvents = $sessionEvents;
                this.this$0 = $receiver;
                this.$model = $model;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = this.$sessionEvents.iterator();
lbl6:
                        // 2 sources

                        while (true) {
                            this.L$0 = var2_3;
                            this.L$1 = null;
                            this.label = 1;
                            v0 = var2_3.hasNext((Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl18
                            break;
                        }
                    }
                    case 1: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) break;
                        event = (SessionEvent)var2_3.next();
                        this.L$0 = var2_3;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)event);
                        this.label = 2;
                        v1 = AspireHost.access$handleSessionEvent(this.this$0, event, this.$model, (Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        event = (SessionEvent)this.L$1;
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl32:
                        // 2 sources

                        ** continue;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        model.getResources().view(aspireHostLifetime, (arg_0, arg_1, arg_2) -> AspireHost.setAspireHostModel$lambda$2(this, arg_0, arg_1, arg_2));
    }

    private final CreateSessionResponse createSession(CreateSessionRequest createSessionRequest, Channel<SessionEvent> sessionEvents, AspireHostModelConfig aspireHostConfig, Lifetime aspireHostLifetime) {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String sessionId = string;
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Creating session with id: " + sessionId);
        }
        SessionManager.CreateSessionCommand command = new SessionManager.CreateSessionCommand(sessionId, createSessionRequest, sessionEvents, aspireHostConfig.getRunConfigName(), aspireHostLifetime);
        SessionManager.Companion.getInstance(this.project).submitCommand(command);
        return new CreateSessionResponse(sessionId, null);
    }

    private final DeleteSessionResponse deleteSession(DeleteSessionRequest deleteSessionRequest) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Deleting session with id: " + deleteSessionRequest.getSessionId());
        }
        SessionManager.DeleteSessionCommand command = new SessionManager.DeleteSessionCommand(deleteSessionRequest.getSessionId());
        SessionManager.Companion.getInstance(this.project).submitCommand(command);
        return new DeleteSessionResponse(deleteSessionRequest.getSessionId(), null);
    }

    private final Object handleSessionEvent(SessionEvent sessionEvent, AspireHostModel model, Continuation<? super Unit> $completion) {
        SessionEvent sessionEvent2 = sessionEvent;
        if (sessionEvent2 instanceof SessionStarted) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Aspire session started (" + ((SessionStarted)sessionEvent).getId() + ", " + ((SessionStarted)sessionEvent).getPid() + ")");
            }
            Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(model, sessionEvent, null){
                int label;
                final /* synthetic */ AspireHostModel $model;
                final /* synthetic */ SessionEvent $sessionEvent;
                {
                    this.$model = $model;
                    this.$sessionEvent = $sessionEvent;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.$model.getProcessStarted().fire((Object)new ProcessStarted(((SessionStarted)this.$sessionEvent).getId(), ((SessionStarted)this.$sessionEvent).getPid()));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (sessionEvent2 instanceof SessionTerminated) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Aspire session terminated (" + ((SessionTerminated)sessionEvent).getId() + ", " + ((SessionTerminated)sessionEvent).getExitCode() + ")");
            }
            Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(model, sessionEvent, null){
                int label;
                final /* synthetic */ AspireHostModel $model;
                final /* synthetic */ SessionEvent $sessionEvent;
                {
                    this.$model = $model;
                    this.$sessionEvent = $sessionEvent;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.$model.getProcessTerminated().fire((Object)new ProcessTerminated(((SessionTerminated)this.$sessionEvent).getId(), ((SessionTerminated)this.$sessionEvent).getExitCode()));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (sessionEvent2 instanceof SessionLogReceived) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Aspire session log received (" + ((SessionLogReceived)sessionEvent).getId() + ", " + ((SessionLogReceived)sessionEvent).isStdErr() + ", " + ((SessionLogReceived)sessionEvent).getMessage() + ")");
            }
            Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(model, sessionEvent, null){
                int label;
                final /* synthetic */ AspireHostModel $model;
                final /* synthetic */ SessionEvent $sessionEvent;
                {
                    this.$model = $model;
                    this.$sessionEvent = $sessionEvent;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.$model.getLogReceived().fire((Object)new LogReceived(((SessionLogReceived)this.$sessionEvent).getId(), ((SessionLogReceived)this.$sessionEvent).isStdErr(), ((SessionLogReceived)this.$sessionEvent).getMessage()));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final void viewResource(String resourceId, ResourceWrapper resourceModel, Lifetime resourceLifetime) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Adding a new resource with id " + resourceId + " to the host " + this.hostProjectPathString);
        }
        AspireResource resource = new AspireResource(resourceModel, this, resourceLifetime, this.project);
        CollectionExKt.addUnique((Map)this.resources, (Lifetime)resourceLifetime, (Object)resourceId, (Object)resource);
        if (!resource.isHidden() && resource.getState() != ResourceState.Hidden) {
            resourceLifetime.bracketIfAlive(() -> AspireHost.viewResource$lambda$1(this), () -> AspireHost.viewResource$lambda$2(this));
        }
        resourceModel.isInitialized().set((Object)true);
        this.expand();
        this.setProfileDataForResource(resource);
    }

    private final void setAspireHostUrl(AspireHostModelConfig config) {
        this.dashboardUrl = config.getAspireHostProjectUrl();
        this.sendServiceChangedEvent();
    }

    private final void setOTLPEndpointUrl(AspireHostModelConfig config, Lifetime lifetime) {
        Object v0;
        block4: {
            if (config.getOtlpEndpointUrl() == null) {
                return;
            }
            Iterable $this$singleOrNull$iv = OpenTelemetryProtocolServerExtension.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                OpenTelemetryProtocolServerExtension it = (OpenTelemetryProtocolServerExtension)element$iv;
                boolean bl = false;
                if (!it.getEnabled()) continue;
                if (found$iv) {
                    v0 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        OpenTelemetryProtocolServerExtension openTelemetryProtocolServerExtension = v0;
        if (openTelemetryProtocolServerExtension == null) {
            return;
        }
        OpenTelemetryProtocolServerExtension extension = openTelemetryProtocolServerExtension;
        lifetime.bracketIfAlive(() -> AspireHost.setOTLPEndpointUrl$lambda$1(extension, config), () -> AspireHost.setOTLPEndpointUrl$lambda$2(extension, config));
    }

    private final void hostStarted(ProcessHandler processHandler2) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Aspire Host " + this.hostProjectPathString + " was started");
        }
        this.isActive = true;
        ProcessHandler handler = processHandler2 instanceof DebuggerWorkerProcessHandler ? ((DebuggerWorkerProcessHandler)processHandler2).getDebuggerWorkerRealHandler() : processHandler2;
        ConsoleView console = DotNetProcessRunProfileStateKt.createConsole$default((ConsoleKind)ConsoleKind.Normal, (ProcessHandler)handler, (Project)this.project, null, (int)8, null);
        Disposer.register((Disposable)this, (Disposable)((Disposable)console));
        ConsoleView previousConsole = this.consoleView;
        if (previousConsole != null) {
            Disposer.dispose((Disposable)((Disposable)previousConsole));
        }
        this.consoleView = console;
        this.selectHost();
        this.sendServiceChangedEvent();
    }

    private final void hostStopped() {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Aspire Host " + this.hostProjectPathString + " was stopped");
        }
        this.isActive = false;
        this.dashboardUrl = null;
        this.resources.clear();
        this.resourceProfileData.clear();
        this.sendServiceChangedEvent();
    }

    private final void setProfileDataForResource(AspireResource resource) {
        Object v2;
        block3: {
            AspireResource.AspireResourceProperty<Path> aspireResourceProperty = resource.getProjectPath();
            if (aspireResourceProperty == null) {
                return;
            }
            AspireResource.AspireResourceProperty<Path> projectPath = aspireResourceProperty;
            Collection<AspireProjectResourceProfileData> collection = this.resourceProfileData.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AspireProjectResourceProfileData it = (AspireProjectResourceProfileData)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProjectPath(), (Object)projectPath.getValue())) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        AspireProjectResourceProfileData aspireProjectResourceProfileData = v2;
        if (aspireProjectResourceProfileData == null) {
            return;
        }
        AspireProjectResourceProfileData profileData = aspireProjectResourceProfileData;
        resource.setProfileData(profileData);
    }

    /*
     * WARNING - void declaration
     */
    private final void setProfileDataForResource(ProjectSessionProfile profile) {
        void $this$filterTo$iv$iv;
        AspireProjectResourceProfileData profileData = new AspireProjectResourceProfileData(profile.getProjectPath(), profile.isDebugMode());
        ((Map)this.resourceProfileData).put(profile.getSessionId(), profileData);
        Collection<AspireResource> collection = this.resources.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AspireResource it = (AspireResource)element$iv$iv;
            boolean bl = false;
            AspireResource.AspireResourceProperty<Path> aspireResourceProperty = it.getProjectPath();
            if (!Intrinsics.areEqual((Object)(aspireResourceProperty != null ? aspireResourceProperty.getValue() : null), (Object)profileData.getProjectPath())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AspireResource it = (AspireResource)element$iv;
            boolean bl = false;
            it.setProfileData(profileData);
        }
    }

    private final void removeProfileData(ProjectSessionProfile profile) {
        this.resourceProfileData.remove(profile.getSessionId());
    }

    private final void selectHost() {
        ApplicationKt.getApplication().invokeLater(() -> AspireHost.selectHost$lambda$0(this));
    }

    private final void expand() {
        ApplicationKt.getApplication().invokeLater(() -> AspireHost.expand$lambda$0(this));
    }

    private final void sendServiceChangedEvent() {
        ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHANGED, (Object)this, AspireMainServiceViewContributor.class);
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = ServiceEventListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(event);
    }

    private final void sendServiceChildrenChangedEvent() {
        ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHILDREN_CHANGED, (Object)this, AspireMainServiceViewContributor.class);
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = ServiceEventListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(event);
    }

    public void dispose() {
    }

    private static final AspireHostServiceViewDescriptor descriptor_delegate$lambda$0(AspireHost this$0) {
        return new AspireHostServiceViewDescriptor(this$0);
    }

    private static final Comparable getResources$lambda$1(AspireResource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getType());
    }

    private static final Comparable getResources$lambda$2(AspireResource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getName());
    }

    private static final Comparable getParentResources$lambda$1(AspireResource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getType());
    }

    private static final Comparable getParentResources$lambda$2(AspireResource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getName());
    }

    private static final Comparable getChildResourcesFor$lambda$1(AspireResource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getType());
    }

    private static final Comparable getChildResourcesFor$lambda$2(AspireResource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getName());
    }

    private static final CreateSessionResponse setAspireHostModel$lambda$0(AspireHost this$0, Channel $sessionEvents, AspireHostModel $model, Lifetime $aspireHostLifetime, CreateSessionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this$0.createSession(request, (Channel<SessionEvent>)$sessionEvents, $model.getConfig(), $aspireHostLifetime);
    }

    private static final DeleteSessionResponse setAspireHostModel$lambda$1(AspireHost this$0, DeleteSessionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this$0.deleteSession(request);
    }

    private static final Unit setAspireHostModel$lambda$2(AspireHost this$0, Lifetime resourceLifetime, String resourceId, ResourceWrapper resourceModel) {
        Intrinsics.checkNotNullParameter((Object)resourceLifetime, (String)"resourceLifetime");
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        Intrinsics.checkNotNullParameter((Object)((Object)resourceModel), (String)"resourceModel");
        this$0.viewResource(resourceId, resourceModel, resourceLifetime);
        return Unit.INSTANCE;
    }

    private static final Unit viewResource$lambda$1(AspireHost this$0) {
        this$0.sendServiceChildrenChangedEvent();
        return Unit.INSTANCE;
    }

    private static final Unit viewResource$lambda$2(AspireHost this$0) {
        this$0.sendServiceChildrenChangedEvent();
        return Unit.INSTANCE;
    }

    private static final Unit setOTLPEndpointUrl$lambda$1(OpenTelemetryProtocolServerExtension $extension, AspireHostModelConfig $config) {
        $extension.setOTLPServerEndpointForProxying($config.getOtlpEndpointUrl());
        return Unit.INSTANCE;
    }

    private static final Unit setOTLPEndpointUrl$lambda$2(OpenTelemetryProtocolServerExtension $extension, AspireHostModelConfig $config) {
        $extension.removeOTLPServerEndpointForProxying($config.getOtlpEndpointUrl());
        return Unit.INSTANCE;
    }

    private static final void selectHost$lambda$0(AspireHost this$0) {
        ServiceViewManager.getInstance((Project)this$0.project).select((Object)this$0, AspireMainServiceViewContributor.class, true, true);
    }

    private static final void expand$lambda$0(AspireHost this$0) {
        ServiceViewManager.getInstance((Project)this$0.project).expand((Object)this$0, AspireMainServiceViewContributor.class);
    }

    public static final /* synthetic */ Object access$handleSessionEvent(AspireHost $this, SessionEvent sessionEvent, AspireHostModel model, Continuation $completion) {
        return $this.handleSessionEvent(sessionEvent, model, (Continuation<? super Unit>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AspireHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/aspire/dashboard/AspireHost$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "aspire-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

