/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.actions.dashboard.resource;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.platform.workspace.jps.serialization.impl.UtilsKt;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.jetbrains.rider.aspire.dashboard.AspireHost;
import com.jetbrains.rider.aspire.dashboard.AspireResource;
import com.jetbrains.rider.aspire.dashboard.AspireWorker;
import com.jetbrains.rider.aspire.util.DataKeysKt;
import com.jetbrains.rider.aspire.worker.AspireWorkerManager;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH$J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH$J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/aspire/actions/dashboard/resource/AspireResourceBaseAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "performAction", "resourceService", "Lcom/jetbrains/rider/aspire/dashboard/AspireResource;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "update", "updateAction", "getProjectResource", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "aspire-plugin"})
public abstract class AspireResourceBaseAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        AspireResource aspireResource = (AspireResource)event.getData(DataKeysKt.getASPIRE_RESOURCE());
        if (aspireResource == null && (aspireResource = this.getProjectResource(event)) == null) {
            return;
        }
        AspireResource resource = aspireResource;
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        this.performAction(resource, dataContext, project2);
    }

    protected abstract void performAction(@NotNull AspireResource var1, @NotNull DataContext var2, @NotNull Project var3);

    public void update(@NotNull AnActionEvent event) {
        AspireResource resource;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        AspireResource aspireResource = (AspireResource)event.getData(DataKeysKt.getASPIRE_RESOURCE());
        if (aspireResource == null) {
            aspireResource = resource = this.getProjectResource(event);
        }
        if (project == null || resource == null) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        this.updateAction(event, resource, project);
    }

    protected abstract void updateAction(@NotNull AnActionEvent var1, @NotNull AspireResource var2, @NotNull Project var3);

    private final AspireResource getProjectResource(AnActionEvent event) {
        Project project = event.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        ProjectModelEntity projectModelEntity = ProjectModelEntityExtensionsKt.getProjectModelEntity((DataContext)dataContext, (boolean)true);
        if (projectModelEntity == null || (projectModelEntity = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)projectModelEntity)) == null) {
            return null;
        }
        ProjectModelEntity projectEntity = projectModelEntity;
        Object object = projectEntity.getUrl();
        if (object == null || (object = UtilsKt.toPath((VirtualFileUrl)object)) == null) {
            return null;
        }
        Object projectPath = object;
        AspireWorker aspireWorker = AspireWorkerManager.Companion.getInstance(project2).getAspireWorker();
        for (AspireHost aspireHost : aspireWorker.getServices(project2)) {
            AspireResource aspireResource = aspireHost.getProjectResource((Path)projectPath);
            if (aspireResource == null) continue;
            AspireResource resource = aspireResource;
            return resource;
        }
        return null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

