/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.lightweightBackend.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.util.Key;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendProtocolManagerKt;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendRegistrySettingKt;
import com.intellij.rider.lightweightBackend.editor.RiderLightweightBackendAwareTextControlHostKt;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rider.editors.RiderTextControlHost;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0001H\u0002JB\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016\u00a8\u0006$"}, d2={"Lcom/intellij/rider/lightweightBackend/editor/RiderLightweightBackendAwareTextControlHost;", "Lcom/jetbrains/rider/editors/RiderTextControlHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getTextControlKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rd/ide/model/TextControlId;", "getTextControlSynchronizerKey", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizer;", "getEditorClosingKey", "", "findTextControlFrom", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorCreated", "", "editorReleased", "removeClosedEditor", "textControlId", "selectionChanged", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "getLightweightBackendTextControlHost", "createSynchronizer", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "projectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "textControlModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "textControlDisposable", "Lcom/intellij/openapi/Disposable;", "Companion", "intellij.rider.lightweightBackend"})
@SourceDebugExtension(value={"SMAP\nRiderLightweightBackendAwareTextControlHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderLightweightBackendAwareTextControlHost.kt\ncom/intellij/rider/lightweightBackend/editor/RiderLightweightBackendAwareTextControlHost\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,97:1\n30#2,2:98\n*S KotlinDebug\n*F\n+ 1 RiderLightweightBackendAwareTextControlHost.kt\ncom/intellij/rider/lightweightBackend/editor/RiderLightweightBackendAwareTextControlHost\n*L\n77#1:98,2\n*E\n"})
public final class RiderLightweightBackendAwareTextControlHost
extends RiderTextControlHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<EditorSynchronizer> lightweightTextControlSynchronizerKey = new Key("LightweightEditorSynchronizerKey");
    @NotNull
    private static final Key<Boolean> isLightweightEditorClosingKey = new Key("isLightweightEditorClosingKey");

    public RiderLightweightBackendAwareTextControlHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session);
    }

    @NotNull
    protected Key<TextControlId> getTextControlKey() {
        if (RiderLightweightBackendProtocolManagerKt.isLightweightBackendAppSession(this.getSession())) {
            return RiderLightweightBackendAwareTextControlHostKt.getLightweightTextControlIdKey();
        }
        return super.getTextControlKey();
    }

    @NotNull
    public Key<EditorSynchronizer> getTextControlSynchronizerKey() {
        if (RiderLightweightBackendProtocolManagerKt.isLightweightBackendAppSession(this.getSession())) {
            return lightweightTextControlSynchronizerKey;
        }
        return super.getTextControlSynchronizerKey();
    }

    @NotNull
    protected Key<Boolean> getEditorClosingKey() {
        if (RiderLightweightBackendProtocolManagerKt.isLightweightBackendAppSession(this.getSession())) {
            return isLightweightEditorClosingKey;
        }
        return super.getEditorClosingKey();
    }

    @Nullable
    protected TextControlId findTextControlFrom(@NotNull EditorFactoryEvent event) {
        TextControlId textControlId;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (RiderLightweightBackendProtocolManagerKt.isLightweightBackendAppSession(this.getSession())) {
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            textControlId = RiderLightweightBackendAwareTextControlHostKt.getLightweightTextControlId(editor);
        } else {
            textControlId = super.findTextControlFrom(event);
        }
        return textControlId;
    }

    protected void editorCreated(@NotNull EditorFactoryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.editorCreatedFor(event);
        if (!RiderLightweightBackendRegistrySettingKt.isLightweightBackendEnabled()) {
            return;
        }
        this.getLightweightBackendTextControlHost().editorCreatedFor(event);
    }

    public void editorReleased(@NotNull EditorFactoryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.editorReleasedFor(event);
        if (!RiderLightweightBackendRegistrySettingKt.isLightweightBackendEnabled()) {
            return;
        }
        this.getLightweightBackendTextControlHost().editorReleasedFor(event);
    }

    public void removeClosedEditor(@NotNull TextControlId textControlId) {
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        this.removeClosedEditorFor(textControlId);
        if (!RiderLightweightBackendRegistrySettingKt.isLightweightBackendEnabled()) {
            return;
        }
        this.getLightweightBackendTextControlHost().removeClosedEditorFor(textControlId);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.selectionChangedFor(event);
        if (!RiderLightweightBackendRegistrySettingKt.isLightweightBackendEnabled()) {
            return;
        }
        this.getLightweightBackendTextControlHost().selectionChangedFor(event);
    }

    private final RiderTextControlHost getLightweightBackendTextControlHost() {
        ClientAppSession clientAppSession = RiderLightweightBackendProtocolManagerKt.getLightweightAppSession(this.getSession());
        Intrinsics.checkNotNull((Object)clientAppSession);
        ComponentManager $this$service$iv = (ComponentManager)clientAppSession;
        boolean $i$f$service = false;
        Class<FrontendTextControlHost> serviceClass$iv = FrontendTextControlHost.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.rider.editors.RiderTextControlHost");
        return (RiderTextControlHost)object;
    }

    @NotNull
    public EditorSynchronizer createSynchronizer(@NotNull Lifetime textControlLifetime, @NotNull Editor editor, @Nullable ClientProjectSession projectSession, @NotNull ClientAppSession session, @NotNull TextControlId textControlId, @NotNull TextControlModel textControlModel, @NotNull Disposable textControlDisposable) {
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)textControlModel, (String)"textControlModel");
        Intrinsics.checkNotNullParameter((Object)textControlDisposable, (String)"textControlDisposable");
        EditorSynchronizer synchronizer = super.createSynchronizer(textControlLifetime, editor, projectSession, session, textControlId, textControlModel, textControlDisposable);
        if (!RiderLightweightBackendRegistrySettingKt.isLightweightBackendEnabled() || !RiderLightweightBackendProtocolManagerKt.isLightweightBackendAppSession(session)) {
            return synchronizer;
        }
        return synchronizer;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/rider/lightweightBackend/editor/RiderLightweightBackendAwareTextControlHost$Companion;", "", "<init>", "()V", "lightweightTextControlSynchronizerKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizer;", "getLightweightTextControlSynchronizerKey", "()Lcom/intellij/openapi/util/Key;", "isLightweightEditorClosingKey", "", "intellij.rider.lightweightBackend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<EditorSynchronizer> getLightweightTextControlSynchronizerKey() {
            return lightweightTextControlSynchronizerKey;
        }

        @NotNull
        public final Key<Boolean> isLightweightEditorClosingKey() {
            return isLightweightEditorClosingKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

