/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.lightweightBackend;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Key;
import com.intellij.rider.lightweightBackend.LightweightBackendApplicationProtocolKt;
import com.intellij.rider.lightweightBackend.LightweightBackendProtocolKeys;
import com.intellij.rider.lightweightBackend.ReSharperMultiBackendLauncher;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendProtocolManagerKt;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendRegistrySettingKt;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendSolutionHostExtensionsKt;
import com.intellij.rider.lightweightBackend.RiderProtocolHostWithLightweightBackend;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.RdOpenSolution;
import com.jetbrains.rd.ide.model.RdSolutionDescription;
import com.jetbrains.rd.ide.model.RdSolutionOpenStrategy;
import com.jetbrains.rd.ide.model.RdVirtualSolution;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.ReSharperBackendLauncher;
import com.jetbrains.rider.projectView.SolutionDescriptionFactory;
import com.jetbrains.rider.projectView.SolutionInitializerService;
import com.jetbrains.rider.projectView.SolutionOpenStrategyProvider;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendSolutionInitializerService;", "Lcom/jetbrains/rider/projectView/SolutionInitializerService;", "<init>", "()V", "finishInitialization", "", "project", "Lcom/intellij/openapi/project/Project;", "initSolution", "strategy", "Lcom/jetbrains/rd/ide/model/RdSolutionOpenStrategy;", "getSolutionAndProjectSession", "Lkotlin/Pair;", "Lcom/jetbrains/rd/ide/model/Solution;", "Lcom/intellij/openapi/client/ClientProjectSession;", "protocolHost", "Lcom/jetbrains/rider/protocol/IProtocolHostWithBackend;", "session", "releaseProtocolHost", "Companion", "Service", "intellij.rider.lightweightBackend"})
@SourceDebugExtension(value={"SMAP\nRiderLightweightBackendSolutionInitializerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderLightweightBackendSolutionInitializerService.kt\ncom/intellij/rider/lightweightBackend/RiderLightweightBackendSolutionInitializerService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n30#2,2:84\n1#3:86\n13#4:87\n*S KotlinDebug\n*F\n+ 1 RiderLightweightBackendSolutionInitializerService.kt\ncom/intellij/rider/lightweightBackend/RiderLightweightBackendSolutionInitializerService\n*L\n40#1:84,2\n27#1:87\n*E\n"})
public final class RiderLightweightBackendSolutionInitializerService
extends SolutionInitializerService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<SolutionInitializerService.SolutionKey> lightweightSolutionKey = new Key("LightweightSolutionKey");
    @NotNull
    private static final Key<LifetimeDefinition> lightweightSolutionInitializationLifetimeKey = new Key("LightweightSolutionInitializationLifetimeKey");
    @NotNull
    private static final Logger logger;

    public void finishInitialization(@NotNull Project project) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super.finishInitialization(project);
            if (!RiderLightweightBackendRegistrySettingKt.isLightweightBackendEnabled()) {
                return;
            }
            LifetimeDefinition lifetimeDefinition = (LifetimeDefinition)project.getUserData(lightweightSolutionInitializationLifetimeKey);
            if (lifetimeDefinition == null) break block1;
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
    }

    public void initSolution(@NotNull Project project, @NotNull RdSolutionOpenStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        super.initSolution(project, strategy);
        if (!RiderLightweightBackendRegistrySettingKt.isLightweightBackendEnabled()) {
            return;
        }
        RdVirtualSolution lightweightFakeSolutionDescription = SolutionDescriptionFactory.INSTANCE.virtual("", CollectionsKt.emptyList());
        RdOpenSolution lightweightBackendStrategy = new RdOpenSolution((RdSolutionDescription)lightweightFakeSolutionDescription, true);
        ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service = false;
        Class<ReSharperBackendLauncher> serviceClass$iv = ReSharperBackendLauncher.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.rider.lightweightBackend.ReSharperMultiBackendLauncher");
        ((ReSharperMultiBackendLauncher)((Object)object)).launchLightweightBackend(project);
        this.initSolution(project, (RdSolutionOpenStrategy)lightweightBackendStrategy, LightweightBackendApplicationProtocolKt.getLightweightProtocolManager(ApplicationKt.getApplication()), lightweightSolutionInitializationLifetimeKey, lightweightSolutionKey, LightweightBackendProtocolKeys.INSTANCE.getLightweightProtocolHostKey());
    }

    @NotNull
    protected Pair<Solution, ClientProjectSession> getSolutionAndProjectSession(@NotNull IProtocolHostWithBackend protocolHost, @NotNull ClientProjectSession session, @NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)protocolHost, (String)"protocolHost");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!(protocolHost instanceof RiderProtocolHostWithLightweightBackend)) {
            return super.getSolutionAndProjectSession(protocolHost, session, project);
        }
        ClientProjectSession lightweightProjectSession = RiderLightweightBackendProtocolManagerKt.getLightweightProjectSession(session);
        boolean bl2 = bl = lightweightProjectSession != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "LightweightProjectSession is null";
            throw new AssertionError((Object)string);
        }
        Solution solution = RiderLightweightBackendSolutionHostExtensionsKt.getLightweightSolution(project);
        ClientProjectSession clientProjectSession = lightweightProjectSession;
        Intrinsics.checkNotNull((Object)clientProjectSession);
        return new Pair((Object)solution, (Object)clientProjectSession);
    }

    protected void releaseProtocolHost(@NotNull IProtocolHostWithBackend protocolHost) {
        Intrinsics.checkNotNullParameter((Object)protocolHost, (String)"protocolHost");
        if (!(protocolHost instanceof RiderProtocolHostWithLightweightBackend)) {
            super.releaseProtocolHost(protocolHost);
            return;
        }
        LightweightBackendApplicationProtocolKt.getLightweightProtocolManager(ApplicationKt.getApplication()).release(protocolHost);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderLightweightBackendSolutionInitializerService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderLightweightBackendSolutionInitializerService.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendSolutionInitializerService$Companion;", "", "<init>", "()V", "lightweightSolutionKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/projectView/SolutionInitializerService$SolutionKey;", "getLightweightSolutionKey", "()Lcom/intellij/openapi/util/Key;", "lightweightSolutionInitializationLifetimeKey", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.lightweightBackend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<SolutionInitializerService.SolutionKey> getLightweightSolutionKey() {
            return lightweightSolutionKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendSolutionInitializerService$Service;", "Lcom/jetbrains/rider/projectView/SolutionInitializerService$Service;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "initSolutionIfNeeded", "", "intellij.rider.lightweightBackend"})
    @SourceDebugExtension(value={"SMAP\nRiderLightweightBackendSolutionInitializerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderLightweightBackendSolutionInitializerService.kt\ncom/intellij/rider/lightweightBackend/RiderLightweightBackendSolutionInitializerService$Service\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,83:1\n1#2:84\n30#3,2:85\n*S KotlinDebug\n*F\n+ 1 RiderLightweightBackendSolutionInitializerService.kt\ncom/intellij/rider/lightweightBackend/RiderLightweightBackendSolutionInitializerService$Service\n*L\n80#1:85,2\n*E\n"})
    public static final class Service
    extends SolutionInitializerService.Service {
        public Service(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project);
        }

        protected void initSolutionIfNeeded(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (project.isDefault()) {
                return;
            }
            if (!RiderLightweightBackendRegistrySettingKt.isLightweightBackendEnabled()) {
                super.initSolutionIfNeeded(project);
                return;
            }
            if (project.getUserData(SolutionInitializerService.Companion.getSolutionKey()) != null) {
                boolean hasLightweightSolution;
                boolean bl = hasLightweightSolution = project.getUserData(Companion.getLightweightSolutionKey()) != null;
                if (!hasLightweightSolution) {
                    logger.error("!hasLightweightSolution");
                }
                return;
            }
            RdSolutionOpenStrategy strategy = SolutionOpenStrategyProvider.Companion.getInstance().getOpenStrategy(project);
            if (strategy == null) {
                project.putUserData(SolutionInitializerService.Companion.getSolutionKey(), (Object)new SolutionInitializerService.SolutionKey(null));
                project.putUserData(Companion.getLightweightSolutionKey(), (Object)new SolutionInitializerService.SolutionKey(null));
                return;
            }
            Path path = (Path)project.getUserData(ProjectImpl.PROJECT_PATH);
            if (path != null) {
                Path it = path;
                boolean bl = false;
                project.putUserData(ProjectUtilKt.getRdEarlyProjectDir(), (Object)((Object)it).toString());
            }
            ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$service = false;
            Class<SolutionInitializerService> serviceClass$iv = SolutionInitializerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((SolutionInitializerService)object).initSolution(project, strategy);
        }
    }
}

