/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.lightweightBackend;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.rider.lightweightBackend.LightweightBackendApplicationProtocolKt;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendRdDispatcher;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendRegistrySettingKt;
import com.intellij.rider.lightweightBackend.RiderProtocolHostWithLightweightBackend;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.Protocol;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.protocol.RdDispatcher;
import com.jetbrains.rider.protocol.DelayedServerWire;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.ProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolManager;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J6\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendProtocolManager;", "Lcom/jetbrains/rider/protocol/ProtocolManager;", "application", "Lcom/intellij/openapi/application/Application;", "componentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/intellij/openapi/application/Application;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getProtocolName", "", "createRdDispatcher", "Lcom/jetbrains/rdclient/protocol/RdDispatcher;", "lifetime", "getProtocolHost", "Lcom/jetbrains/rider/protocol/ProtocolHostWithBackend;", "project", "Lcom/intellij/openapi/project/Project;", "createProtocolHostWithBackend", "id", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "pair", "Lkotlin/Pair;", "Lcom/jetbrains/rd/framework/Protocol;", "Lcom/jetbrains/rider/protocol/DelayedServerWire;", "process", "Lcom/jetbrains/rider/protocol/ReSharperProcessBase;", "Companion", "intellij.rider.lightweightBackend"})
public final class RiderLightweightBackendProtocolManager
extends ProtocolManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<ClientAppSession> lightweightAppSessionKey = new Key("Lightweight ClientAppSession");
    @NotNull
    private static final Key<ClientAppSession> originalAppSessionKey = new Key("Original ClientAppSession");
    @NotNull
    private static final Key<ClientProjectSession> lightweightProjectSessionKey = new Key("Lightweight ClientProjectSession");
    @NotNull
    private static final Key<ClientProjectSession> originalProjectSessionKey = new Key("Original ClientProjectSession");

    public RiderLightweightBackendProtocolManager(@NotNull Application application, @NotNull Lifetime componentLifetime) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)componentLifetime, (String)"componentLifetime");
        super(application, componentLifetime, true);
    }

    @NotNull
    protected String getProtocolName() {
        return super.getProtocolName() + " LightweightBackend";
    }

    @NotNull
    protected RdDispatcher createRdDispatcher(@NotNull Application application, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (!RiderLightweightBackendRegistrySettingKt.isLightweightBackendEnabled()) {
            return super.createRdDispatcher(application, lifetime);
        }
        return new RiderLightweightBackendRdDispatcher(application, lifetime);
    }

    @NotNull
    protected ProtocolHostWithBackend getProtocolHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!RiderLightweightBackendRegistrySettingKt.isLightweightBackendEnabled()) {
            return super.getProtocolHost(project);
        }
        IProtocolHost iProtocolHost = LightweightBackendApplicationProtocolKt.getLightweightProtocolHost(project);
        Intrinsics.checkNotNull((Object)iProtocolHost, (String)"null cannot be cast to non-null type com.jetbrains.rider.protocol.ProtocolHostWithBackend");
        return (ProtocolHostWithBackend)iProtocolHost;
    }

    @NotNull
    protected ProtocolHostWithBackend createProtocolHostWithBackend(@NotNull String id, @NotNull LifetimeDefinition lifetimeDefinition, @NotNull Pair<Protocol, DelayedServerWire> pair, @Nullable ReSharperProcessBase process) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"lifetimeDefinition");
        Intrinsics.checkNotNullParameter(pair, (String)"pair");
        if (!RiderLightweightBackendRegistrySettingKt.isLightweightBackendEnabled()) {
            return super.createProtocolHostWithBackend(id, lifetimeDefinition, pair, process);
        }
        return new RiderProtocolHostWithLightweightBackend(id, lifetimeDefinition, (Protocol)pair.getFirst(), (DelayedServerWire)pair.getSecond(), ApplicationKt.getApplication(), process);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendProtocolManager$Companion;", "", "<init>", "()V", "lightweightAppSessionKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/client/ClientAppSession;", "getLightweightAppSessionKey", "()Lcom/intellij/openapi/util/Key;", "originalAppSessionKey", "getOriginalAppSessionKey", "lightweightProjectSessionKey", "Lcom/intellij/openapi/client/ClientProjectSession;", "getLightweightProjectSessionKey", "originalProjectSessionKey", "getOriginalProjectSessionKey", "intellij.rider.lightweightBackend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<ClientAppSession> getLightweightAppSessionKey() {
            return lightweightAppSessionKey;
        }

        @NotNull
        public final Key<ClientAppSession> getOriginalAppSessionKey() {
            return originalAppSessionKey;
        }

        @NotNull
        public final Key<ClientProjectSession> getLightweightProjectSessionKey() {
            return lightweightProjectSessionKey;
        }

        @NotNull
        public final Key<ClientProjectSession> getOriginalProjectSessionKey() {
            return originalProjectSessionKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

