/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.lightweightBackend;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendProtocolManagerKt;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendRegistrySettingKt;
import com.jetbrains.rdclient.protocol.DefaultFrontendProtocolExceptionLogger;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J9\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendProtocolExceptionLogger;", "Lcom/jetbrains/rdclient/protocol/DefaultFrontendProtocolExceptionLogger;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "logException", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "logMessage", "", "backendException", "", "attachments", "", "Lcom/intellij/openapi/diagnostic/Attachment;", "(Lcom/intellij/openapi/diagnostic/Logger;Ljava/lang/String;Ljava/lang/Throwable;[Lcom/intellij/openapi/diagnostic/Attachment;)V", "Companion", "intellij.rider.lightweightBackend"})
public final class RiderLightweightBackendProtocolExceptionLogger
extends DefaultFrontendProtocolExceptionLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private static final String prefix = "[LightweightBackend]";

    public RiderLightweightBackendProtocolExceptionLogger(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    public void logException(@NotNull Logger logger, @NotNull String logMessage, @NotNull Throwable backendException, Attachment ... attachments) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)logMessage, (String)"logMessage");
        Intrinsics.checkNotNullParameter((Object)backendException, (String)"backendException");
        Intrinsics.checkNotNullParameter((Object)attachments, (String)"attachments");
        if (!RiderLightweightBackendRegistrySettingKt.isLightweightBackendEnabled() || !RiderLightweightBackendProtocolManagerKt.isLightweightBackendAppSession(this.session)) {
            super.logException(logger, logMessage, backendException, Arrays.copyOf(attachments, attachments.length));
            return;
        }
        boolean warn = ApplicationManager.getApplication().isUnitTestMode();
        if (attachments.length == 0) {
            String message = "[LightweightBackend] " + logMessage;
            if (warn) {
                logger.warn(message, backendException);
            } else {
                logger.error(message, backendException);
            }
        } else {
            String string = backendException.getMessage();
            if (string == null) {
                string = logMessage;
            }
            String message = "[LightweightBackend] " + string;
            if (warn) {
                logger.warn(message, backendException);
            } else {
                logger.error(message, backendException, Arrays.copyOf(attachments, attachments.length));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendProtocolExceptionLogger$Companion;", "", "<init>", "()V", "prefix", "", "intellij.rider.lightweightBackend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

