/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.lightweightBackend;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendExecutor;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendPermittedModalitiesImpl;
import com.intellij.rider.lightweightBackend.RiderLightweightBackendProtocolManagerKt;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.RdFailureResponse;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdRetryResponse;
import com.jetbrains.rd.ide.model.RdSuccessResponse;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchUtilsKt;
import com.jetbrains.rd.ide.requests.SpeculativelyEqualsResult;
import com.jetbrains.rdclient.editorActions.cwm.PhantomCallEditorActionRequest;
import com.jetbrains.rdclient.patches.FrontendPatchEngineHost;
import com.jetbrains.rdclient.requests.FrontendApplyPatchRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutorOld;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0094@\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u001fH\u0014J\u0018\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#H\u0002J(\u0010$\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J \u0010&\u001a\u0004\u0018\u00010#2\u0006\u0010!\u001a\u00020\u00032\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070(H\u0002J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006+"}, d2={"Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendAwareAsyncRequestExecutorOld;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutorOld;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "allowPumpProtocolUnderCurrentModality", "", "backendChanged", "patch", "Lcom/jetbrains/rd/ide/model/RdPatch;", "(Lcom/jetbrains/rd/ide/model/RdPatch;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "submitRequest", "request", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "speculativelyEquals", "Lcom/jetbrains/rd/ide/requests/SpeculativelyEqualsResult;", "speculatedPatch", "backendPatch", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult;", "isBatchMode", "", "handleBackendResult", "", "response", "Lcom/jetbrains/rd/ide/model/RdSuccessResponse;", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "delta", "", "handleRetry", "Lcom/jetbrains/rd/ide/model/RdRetryResponse;", "sendNonMatchedChangesToLightweightBackend", "lightweightAppSession", "nonMatchedChangesRequest", "Lcom/jetbrains/rdclient/requests/FrontendApplyPatchRequest;", "handleFailure", "Lcom/jetbrains/rd/ide/model/RdFailureResponse;", "recordLightweightBackendChanges", "block", "Lkotlin/Function0;", "isEmptyPatch", "Companion", "intellij.rider.lightweightBackend"})
@SourceDebugExtension(value={"SMAP\nRiderLightweightBackendAwareAsyncRequestExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderLightweightBackendAwareAsyncRequestExecutor.kt\ncom/intellij/rider/lightweightBackend/RiderLightweightBackendAwareAsyncRequestExecutorOld\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,135:1\n30#2,2:136\n1#3:138\n50#4,7:139\n57#4,2:151\n59#4,6:154\n65#4,2:161\n57#5:146\n35#5,2:147\n82#5,2:149\n84#5:153\n23#5:160\n13#5:163\n*S KotlinDebug\n*F\n+ 1 RiderLightweightBackendAwareAsyncRequestExecutor.kt\ncom/intellij/rider/lightweightBackend/RiderLightweightBackendAwareAsyncRequestExecutorOld\n*L\n44#1:136,2\n123#1:139,7\n123#1:151,2\n123#1:154,6\n123#1:161,2\n123#1:146\n123#1:147,2\n123#1:149,2\n123#1:153\n123#1:160\n49#1:163\n*E\n"})
public final class RiderLightweightBackendAwareAsyncRequestExecutorOld
extends FrontendAsyncRequestExecutorOld {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public RiderLightweightBackendAwareAsyncRequestExecutorOld(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session);
    }

    public void allowPumpProtocolUnderCurrentModality() {
        if (RiderLightweightBackendProtocolManagerKt.isLightweightBackendAppSession(this.getSession())) {
            ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$service = false;
            Class<RiderLightweightBackendPermittedModalitiesImpl> serviceClass$iv = RiderLightweightBackendPermittedModalitiesImpl.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((RiderLightweightBackendPermittedModalitiesImpl)((Object)object)).allowPumpProtocolUnderCurrentModality();
        } else {
            super.allowPumpProtocolUnderCurrentModality();
        }
    }

    @Nullable
    protected Object backendChanged(@NotNull RdPatch patch, @NotNull Continuation<? super Unit> $completion) {
        if (RiderLightweightBackendProtocolManagerKt.isLightweightBackendAppSession(this.getSession()) && (!((Collection)patch.getChanges()).isEmpty() || !((Collection)patch.getExpectedItemVersions()).isEmpty() || !((Collection)patch.getUpdatedItemVersions()).isEmpty())) {
            LOG.error("Lightweight backend isn't supposed to initiate changes");
            return Unit.INSTANCE;
        }
        Object object = super.backendChanged(patch, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public void submitRequest(@NotNull FrontendAsyncRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (RiderLightweightBackendProtocolManagerKt.isLightweightBackendAppSession(this.getSession()) && !(request instanceof FrontendApplyPatchRequest) && !(request instanceof PhantomCallEditorActionRequest) && !(request instanceof RiderLightweightBackendExecutor.PhantomTypeKeyRequest)) {
            LOG.error("Unexpected request type: " + request.getClass().getName() + " to lightweight backend");
            request.getStatus().cancel();
            return;
        }
        super.submitRequest(request);
    }

    @NotNull
    protected SpeculativelyEqualsResult speculativelyEquals(@NotNull RdPatch speculatedPatch, @Nullable RdPatch backendPatch, @NotNull FrontendAsyncRequestWithImmediateResult request, boolean isBatchMode) {
        Intrinsics.checkNotNullParameter((Object)speculatedPatch, (String)"speculatedPatch");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!RiderLightweightBackendProtocolManagerKt.isLightweightBackendAppSession(this.getSession())) {
            return super.speculativelyEquals(speculatedPatch, backendPatch, request, isBatchMode);
        }
        return RdPatchUtilsKt.speculativelyEquals((RdPatch)speculatedPatch, (RdPatch)backendPatch, (!isBatchMode ? 1 : 0) != 0);
    }

    protected int handleBackendResult(@NotNull FrontendAsyncRequest request, @NotNull RdSuccessResponse response, @NotNull FrontendRebaseSession rebaseSession, long delta, boolean isBatchMode) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        if (!RiderLightweightBackendProtocolManagerKt.isLightweightBackendAppSession(this.getSession())) {
            Ref.ObjectRef handleBackendResult = new Ref.ObjectRef();
            ClientAppSession clientAppSession = RiderLightweightBackendProtocolManagerKt.getLightweightAppSession(this.getSession());
            Intrinsics.checkNotNull((Object)clientAppSession);
            ClientAppSession lightweightAppSession = clientAppSession;
            FrontendApplyPatchRequest nonMatchedChangesRequest = this.recordLightweightBackendChanges(lightweightAppSession, (Function0<Unit>)((Function0)() -> RiderLightweightBackendAwareAsyncRequestExecutorOld.handleBackendResult$lambda$0(handleBackendResult, this, request, response, rebaseSession, delta, isBatchMode)));
            if (nonMatchedChangesRequest != null) {
                this.sendNonMatchedChangesToLightweightBackend(lightweightAppSession, nonMatchedChangesRequest);
            }
            Object object = handleBackendResult.element;
            Intrinsics.checkNotNull((Object)object);
            return ((Number)object).intValue();
        }
        return super.handleBackendResult(request, response, rebaseSession, delta, isBatchMode);
    }

    protected void handleRetry(@NotNull FrontendAsyncRequest request, @NotNull RdRetryResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!RiderLightweightBackendProtocolManagerKt.isLightweightBackendAppSession(this.getSession())) {
            ClientAppSession clientAppSession = RiderLightweightBackendProtocolManagerKt.getLightweightAppSession(this.getSession());
            Intrinsics.checkNotNull((Object)clientAppSession);
            ClientAppSession lightweightAppSession = clientAppSession;
            FrontendApplyPatchRequest nonMatchedChangesRequest = this.recordLightweightBackendChanges(lightweightAppSession, (Function0<Unit>)((Function0)() -> RiderLightweightBackendAwareAsyncRequestExecutorOld.handleRetry$lambda$0(this, request, response)));
            if (nonMatchedChangesRequest != null) {
                this.sendNonMatchedChangesToLightweightBackend(lightweightAppSession, nonMatchedChangesRequest);
            }
            return;
        }
        super.handleRetry(request, response);
    }

    private final void sendNonMatchedChangesToLightweightBackend(ClientAppSession lightweightAppSession, FrontendApplyPatchRequest nonMatchedChangesRequest) {
        LOG.debug("Sending not matched changes to lightweight backend...");
        FrontendAsyncRequestExecutorOld.Companion.getInstance(lightweightAppSession).submitRequest((FrontendAsyncRequest)nonMatchedChangesRequest);
    }

    protected void handleFailure(@NotNull RdFailureResponse response, @NotNull FrontendAsyncRequest request, @NotNull FrontendRebaseSession rebaseSession, long delta) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        if (!RiderLightweightBackendProtocolManagerKt.isLightweightBackendAppSession(this.getSession())) {
            ClientAppSession clientAppSession = RiderLightweightBackendProtocolManagerKt.getLightweightAppSession(this.getSession());
            Intrinsics.checkNotNull((Object)clientAppSession);
            ClientAppSession lightweightAppSession = clientAppSession;
            FrontendApplyPatchRequest nonMatchedChangesRequest = this.recordLightweightBackendChanges(lightweightAppSession, (Function0<Unit>)((Function0)() -> RiderLightweightBackendAwareAsyncRequestExecutorOld.handleFailure$lambda$0(this, response, request, rebaseSession, delta)));
            if (nonMatchedChangesRequest != null) {
                this.sendNonMatchedChangesToLightweightBackend(lightweightAppSession, nonMatchedChangesRequest);
            }
            return;
        }
        super.handleFailure(response, request, rebaseSession, delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final FrontendApplyPatchRequest recordLightweightBackendChanges(ClientAppSession lightweightAppSession, Function0<Unit> block) {
        RdPatch rdPatch;
        void $this$recordChanges$iv;
        boolean bl = RiderLightweightBackendProtocolManagerKt.isLightweightBackendAppSession(lightweightAppSession);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-RiderLightweightBackendAwareAsyncRequestExecutorOld$recordLightweightBackendChanges$22 = false;
            String $i$a$-assert-RiderLightweightBackendAwareAsyncRequestExecutorOld$recordLightweightBackendChanges$22 = "!lightweightAppSession.isLightweightBackendAppSession";
            throw new AssertionError((Object)$i$a$-assert-RiderLightweightBackendAwareAsyncRequestExecutorOld$recordLightweightBackendChanges$22);
        }
        PatchEngine $i$a$-assert-RiderLightweightBackendAwareAsyncRequestExecutorOld$recordLightweightBackendChanges$22 = (PatchEngine)FrontendPatchEngineHost.Companion.getInstance(lightweightAppSession).getEngine();
        String description$iv = "Recording changes difference between lightweight and full backends";
        boolean $i$f$recordChanges = false;
        $this$recordChanges$iv.softAssertThereIsNoActivePatch("recordChanges must no be called under another patch, because it leads to recording and  sending the same patch multiple times");
        boolean alreadyOpened$iv = $this$recordChanges$iv.getHasActivePatch();
        try {
            RdPatch rdPatch2;
            AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$recordChanges$iv, (boolean)false, (String)description$iv, null, (int)4, null);
            Throwable throwable = null;
            try {
                Object object;
                void $this$runAndLogException$iv$iv;
                RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
                boolean bl22 = false;
                boolean $i$f$fileLogger22 = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                Logger $i$f$fileLogger22 = logger;
                boolean $i$f$runAndLogException = false;
                void var14_23 = $this$runAndLogException$iv$iv;
                try {
                    void $this$runAndLogException_u24lambda_u240$iv$iv = var14_23;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    ChangeScope $this$recordLightweightBackendChanges_u24lambda_u241 = it$iv.getSession().getChangeScope();
                    boolean bl5 = false;
                    block.invoke();
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv$iv);
                rdPatch2 = it$iv.getSession().buildPatchAndClear();
            }
            catch (Throwable bl22) {
                try {
                    throwable = bl22;
                    throw bl22;
                }
                catch (Throwable bl22) {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                    throw bl22;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            rdPatch = rdPatch2;
        }
        finally {
            if (!alreadyOpened$iv && $this$recordChanges$iv.getHasActivePatch()) {
                void $this$thisLogger$iv$iv = $this$recordChanges$iv;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(PatchEngine.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("There are unclosed accumulating sessions after recordChanges. Close them forcibly");
                while ($this$recordChanges$iv.getHasActivePatch()) {
                    $this$recordChanges$iv.closeCurrentSession("Wrong dispose ordering: " + description$iv);
                }
            }
        }
        RdPatch delta = rdPatch;
        if (this.isEmptyPatch(delta)) {
            return null;
        }
        return new FrontendApplyPatchRequest(delta, lightweightAppSession, null);
    }

    private final boolean isEmptyPatch(RdPatch patch) {
        return patch.getChanges().isEmpty() && patch.getFeatures().isEmpty() && patch.getExpectedItemVersions().isEmpty() && patch.getUpdatedItemVersions().isEmpty();
    }

    private static final Unit handleBackendResult$lambda$0(Ref.ObjectRef $handleBackendResult, RiderLightweightBackendAwareAsyncRequestExecutorOld this$0, FrontendAsyncRequest $request, RdSuccessResponse $response, FrontendRebaseSession $rebaseSession, long $delta, boolean $isBatchMode) {
        $handleBackendResult.element = super.handleBackendResult($request, $response, $rebaseSession, $delta, $isBatchMode);
        return Unit.INSTANCE;
    }

    private static final Unit handleRetry$lambda$0(RiderLightweightBackendAwareAsyncRequestExecutorOld this$0, FrontendAsyncRequest $request, RdRetryResponse $response) {
        super.handleRetry($request, $response);
        return Unit.INSTANCE;
    }

    private static final Unit handleFailure$lambda$0(RiderLightweightBackendAwareAsyncRequestExecutorOld this$0, RdFailureResponse $response, FrontendAsyncRequest $request, FrontendRebaseSession $rebaseSession, long $delta) {
        super.handleFailure($response, $request, $rebaseSession, $delta);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderLightweightBackendAwareAsyncRequestExecutorOld.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/rider/lightweightBackend/RiderLightweightBackendAwareAsyncRequestExecutorOld$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.lightweightBackend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

