/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.logs.ILogItem;
import com.intellij.kubernetes.logs.ILogSource;
import com.intellij.kubernetes.logs.ILogSubscribableConsistentCache;
import com.intellij.kubernetes.logs.LogConsistentCache;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\b\u0010\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00010\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u00072\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\bB\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007H\u0016J\"\u0010\u0012\u001a\u00020\u00102\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\u0017\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0017H\u0096\u0002RE\u0010\u000b\u001a9\u00120\u0012.\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002 \r*\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u00070\u00070\f\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/kubernetes/logs/LogSubscribableConsistentCache;", "Id", "", "L", "Lcom/intellij/kubernetes/logs/ILogItem;", "S", "Lcom/intellij/kubernetes/logs/ILogSource;", "Lcom/intellij/kubernetes/logs/LogConsistentCache;", "Lcom/intellij/kubernetes/logs/ILogSubscribableConsistentCache;", "<init>", "()V", "subscribers", "Lcom/intellij/util/containers/ConcurrentList;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addSubscriber", "", "anotherCache", "removeSubscriber", "subscriber", "clear", "plusAssign", "newLogs", "", "intellij.clouds.kubernetes.backend"})
public class LogSubscribableConsistentCache<Id extends Comparable<? super Id>, L extends ILogItem<S, Id>, S extends ILogSource>
extends LogConsistentCache<Id, L, S>
implements ILogSubscribableConsistentCache<Id, L, S> {
    @NotNull
    private final ConcurrentList<LogConsistentCache<Id, L, S>> subscribers;

    public LogSubscribableConsistentCache() {
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.subscribers = concurrentList;
    }

    @Override
    public void addSubscriber(@NotNull LogConsistentCache<Id, L, S> anotherCache) {
        Intrinsics.checkNotNullParameter(anotherCache, (String)"anotherCache");
        this.subscribers.add(anotherCache);
        anotherCache.plusAssign(this.getLogsCache().snapshot());
    }

    @Override
    public void removeSubscriber(@NotNull LogConsistentCache<Id, L, S> subscriber) {
        Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
        this.subscribers.remove(subscriber);
    }

    @Override
    public void clear() {
        super.clear();
        for (LogConsistentCache cache : this.subscribers) {
            cache.clear();
        }
    }

    @Override
    public void plusAssign(@NotNull Collection<? extends L> newLogs) {
        Intrinsics.checkNotNullParameter(newLogs, (String)"newLogs");
        super.plusAssign(newLogs);
        for (LogConsistentCache cache : this.subscribers) {
            cache.plusAssign(newLogs);
        }
    }
}

