/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.grazie;

import com.intellij.grazie.text.EventuallyConsistentTextExtractor;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.PsiUtilsKt;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.rider.model.GrammarCheckerRangeType;
import com.jetbrains.rider.model.GrammarCheckerTargetType;
import com.jetbrains.rider.spellChecker.grazie.GrammarCheckerTextRangeMarker;
import com.jetbrains.rider.spellChecker.grazie.RiderGrammarCheckingTarget;
import com.jetbrains.rider.spellChecker.grazie.RiderGrammarCheckingTargetsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\u0012\u001a\u0004\u0018\u00010\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/plugins/appender/grazie/BackendLanguageTextExtractor;", "Lcom/intellij/grazie/text/TextExtractor;", "Lcom/intellij/grazie/text/EventuallyConsistentTextExtractor;", "<init>", "()V", "buildTextContents", "", "Lcom/intellij/grazie/text/TextContent;", "element", "Lcom/intellij/psi/PsiElement;", "allowedDomains", "", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "getPossibleTargetElements", "possibleDomains", "", "getTopmostExpression", "getPossibleDomains", "buildTextContent", "elements", "target", "Lcom/jetbrains/rider/spellChecker/grazie/RiderGrammarCheckingTarget;", "getDomain", "intellij.rider.appender.grazie"})
@SourceDebugExtension(value={"SMAP\nBackendLanguageTextExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendLanguageTextExtractor.kt\ncom/jetbrains/rider/plugins/appender/grazie/BackendLanguageTextExtractor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n23#2:156\n30#3,2:157\n774#4:159\n865#4:160\n1761#4,3:161\n866#4:164\n1617#4,9:165\n1869#4:174\n1870#4:176\n1626#4:177\n1#5:175\n*S KotlinDebug\n*F\n+ 1 BackendLanguageTextExtractor.kt\ncom/jetbrains/rider/plugins/appender/grazie/BackendLanguageTextExtractor\n*L\n55#1:156\n64#1:157,2\n69#1:159\n69#1:160\n69#1:161,3\n69#1:164\n70#1:165,9\n70#1:174\n70#1:176\n70#1:177\n70#1:175\n*E\n"})
public class BackendLanguageTextExtractor
extends TextExtractor
implements EventuallyConsistentTextExtractor {
    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    protected List<TextContent> buildTextContents(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(allowedDomains, (String)"allowedDomains");
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        v0 = Logger.getInstance(BackendLanguageTextExtractor.class);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
        logger = v0;
        file = element.getContainingFile();
        if (file == null) {
            return CollectionsKt.emptyList();
        }
        possibleDomains = this.getPossibleDomains(element);
        if (CollectionsKt.intersect((Iterable)possibleDomains, (Iterable)allowedDomains).isEmpty()) {
            return CollectionsKt.emptyList();
        }
        v1 = file.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getFileDocument(...)");
        document = v1;
        v2 = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getProject(...)");
        project = v2;
        $this$service$iv /* !! */  = (ComponentManager)project;
        $i$f$service = false;
        serviceClass$iv = RiderGrammarCheckingTargetsService.class;
        v3 = $this$service$iv /* !! */ .getService(serviceClass$iv);
        if (v3 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv /* !! */ , serviceClass$iv);
        }
        v4 = (RiderGrammarCheckingTargetsService)v3;
        v5 = element.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getTextRange(...)");
        v6 = v4.getTargets(document, v5);
        if (v6 == null) {
            v6 = CollectionsKt.emptyList();
        }
        targets = v6;
        logger.trace("Got " + targets.size() + " targets for element " + element);
        targetElements = this.getPossibleTargetElements(element, possibleDomains);
        $this$service$iv /* !! */  = targets;
        $i$f$filter = false;
        serviceClass$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block11: {
                it = (RiderGrammarCheckingTarget)element$iv$iv;
                $i$a$-filter-BackendLanguageTextExtractor$buildTextContents$1 = false;
                if (!(((Collection)it.getRanges()).isEmpty() == false)) ** GOTO lbl-1000
                $this$any$iv = targetElements;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v7 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        el = (PsiElement)element$iv;
                        $i$a$-any-BackendLanguageTextExtractor$buildTextContents$1$1 = false;
                        if (!el.getTextRange().intersects((Segment)it)) continue;
                        v7 = true;
                        break block11;
                    }
                    v7 = false;
                }
            }
            if (v7) {
                v8 = true;
            } else lbl-1000:
            // 2 sources

            {
                v8 = false;
            }
            if (!v8) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var17_19 = $this$forEach$iv$iv$iv.iterator();
        while (var17_19.hasNext()) {
            element$iv$iv = element$iv$iv$iv = var17_19.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            it = (RiderGrammarCheckingTarget)element$iv$iv;
            $i$a$-mapNotNull-BackendLanguageTextExtractor$buildTextContents$2 = false;
            if (this.buildTextContent(targetElements, it) == null) continue;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<PsiElement> getPossibleTargetElements(PsiElement element, Set<? extends TextContent.TextDomain> possibleDomains) {
        if (possibleDomains.contains(TextContent.TextDomain.COMMENTS)) {
            return PsiUtilsKt.getNotSoDistantSimilarSiblings((PsiElement)element, arg_0 -> BackendLanguageTextExtractor.getPossibleTargetElements$lambda$0(element, arg_0));
        }
        if (possibleDomains.contains(TextContent.TextDomain.LITERALS)) {
            PsiElement topmostExpression = this.getTopmostExpression(element);
            if (Intrinsics.areEqual((Object)topmostExpression, (Object)element)) {
                return PsiUtilsKt.getNotSoDistantSimilarSiblings((PsiElement)element, arg_0 -> BackendLanguageTextExtractor.getPossibleTargetElements$lambda$1(element, arg_0));
            }
            return CollectionsKt.listOf((Object)topmostExpression);
        }
        return CollectionsKt.listOf((Object)element);
    }

    @NotNull
    protected PsiElement getTopmostExpression(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element;
    }

    @NotNull
    protected Set<TextContent.TextDomain> getPossibleDomains(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
        if (parserDefinition == null) {
            return SetsKt.emptySet();
        }
        if (Intrinsics.areEqual((Object)parserDefinition.getCommentTokens(), (Object)TokenSet.EMPTY) && Intrinsics.areEqual((Object)parserDefinition.getStringLiteralElements(), (Object)TokenSet.EMPTY)) {
            Set set = TextContent.TextDomain.ALL;
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"ALL");
            return set;
        }
        if (parserDefinition.getCommentTokens().contains(PsiTreeUtilKt.getElementType((PsiElement)element))) {
            Object[] objectArray = new TextContent.TextDomain[]{TextContent.TextDomain.COMMENTS, TextContent.TextDomain.DOCUMENTATION};
            return SetsKt.setOf((Object[])objectArray);
        }
        if (parserDefinition.getStringLiteralElements().contains(PsiTreeUtilKt.getElementType((PsiElement)element))) {
            return SetsKt.setOf((Object)TextContent.TextDomain.LITERALS);
        }
        return SetsKt.emptySet();
    }

    private final TextContent buildTextContent(List<? extends PsiElement> elements, RiderGrammarCheckingTarget target) {
        List spaceSeparatedGroups = new ArrayList();
        TextContent.TextDomain domain = this.getDomain(target);
        Ref.ObjectRef currentGroup = new Ref.ObjectRef();
        currentGroup.element = new ArrayList();
        int elementIndex = 0;
        for (GrammarCheckerTextRangeMarker range : target.getRanges()) {
            TextRange actualRange;
            if (range.getRangeInFile() == null || range.getRangeType() == GrammarCheckerRangeType.WHITESPACE) {
                BackendLanguageTextExtractor.buildTextContent$flush((Ref.ObjectRef<List<TextContent>>)currentGroup, spaceSeparatedGroups);
                continue;
            }
            RangeMarker rangeMarker = range.getRangeInFile();
            Intrinsics.checkNotNull((Object)rangeMarker);
            Intrinsics.checkNotNullExpressionValue((Object)rangeMarker.getTextRange(), (String)"getTextRange(...)");
            while (elementIndex < elements.size() && PsiTreeUtilKt.getEndOffset((PsiElement)elements.get(elementIndex)) <= actualRange.getStartOffset()) {
                ++elementIndex;
            }
            if (elementIndex == elements.size()) break;
            PsiElement element = elements.get(elementIndex);
            int left = Math.max(actualRange.getStartOffset() - PsiTreeUtilKt.getStartOffset((PsiElement)element), 0);
            int right = Math.min(actualRange.getEndOffset() - PsiTreeUtilKt.getStartOffset((PsiElement)element), element.getTextRange().getLength());
            if (right <= left) continue;
            TextContent content = TextContent.psiFragment((TextContent.TextDomain)domain, (PsiElement)element, (TextRange)new TextRange(left, right));
            if (range.getRangeType() == GrammarCheckerRangeType.EXCLUDED) {
                content = content.markUnknown(TextRange.from((int)0, (int)content.length()));
            }
            List list = (List)currentGroup.element;
            TextContent textContent = content;
            Intrinsics.checkNotNull((Object)textContent);
            list.add(textContent);
        }
        BackendLanguageTextExtractor.buildTextContent$flush((Ref.ObjectRef<List<TextContent>>)currentGroup, spaceSeparatedGroups);
        return TextContent.joinWithWhitespace((char)' ', (List)spaceSeparatedGroups);
    }

    private final TextContent.TextDomain getDomain(RiderGrammarCheckingTarget target) {
        switch (WhenMappings.$EnumSwitchMapping$0[target.getTargetType().ordinal()]) {
            case 1: {
                return TextContent.TextDomain.COMMENTS;
            }
            case 2: {
                return TextContent.TextDomain.LITERALS;
            }
            case 3: {
                return TextContent.TextDomain.DOCUMENTATION;
            }
        }
        return TextContent.TextDomain.PLAIN_TEXT;
    }

    private static final boolean getPossibleTargetElements$lambda$0(PsiElement $element, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)PsiTreeUtilKt.getElementType((PsiElement)$element));
    }

    private static final boolean getPossibleTargetElements$lambda$1(PsiElement $element, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)PsiTreeUtilKt.getElementType((PsiElement)$element));
    }

    private static final void buildTextContent$flush(Ref.ObjectRef<List<TextContent>> currentGroup, List<TextContent> spaceSeparatedGroups) {
        if (!((List)currentGroup.element).isEmpty()) {
            TextContent content = TextContent.join((List)((List)currentGroup.element));
            if (content != null) {
                spaceSeparatedGroups.add(content);
            }
            currentGroup.element = new ArrayList();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GrammarCheckerTargetType.values().length];
            try {
                nArray[GrammarCheckerTargetType.COMMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GrammarCheckerTargetType.LITERAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GrammarCheckerTargetType.DOCUMENTATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

