/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.introduce;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.psi.SASSTokenTypes;
import org.jetbrains.plugins.scss.psi.SCSSOperationImpl;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssVariableImpl;

public final class SassScssRefactoringPsiHelper {
    @Nullable
    public static PsiElement getSelectedExpression(PsiElement element1, PsiElement element2) {
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            return null;
        }
        String text = parent.getText();
        while (parent != null && text.equals(parent.getText()) && !SassScssRefactoringPsiHelper.checkCanExtract(parent)) {
            parent = parent.getParent();
        }
        return parent != null && SassScssRefactoringPsiHelper.checkCanExtract(parent) ? parent : null;
    }

    public static Pair<PsiElement, PsiElement> getSelectedElements(Editor editor, PsiFile file) {
        PsiElement element2;
        PsiElement element1;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            element1 = file.findElementAt(selectionModel.getSelectionStart());
            element2 = file.findElementAt(selectionModel.getSelectionEnd() - 1);
        } else {
            element2 = element1 = SassScssRefactoringPsiHelper.proceedCaretCase(editor, file);
        }
        if (element1 == null || element2 == null) {
            return Pair.create(null, null);
        }
        while (element1 != null && SassScssRefactoringPsiHelper.isExtendedWhitespace(element1)) {
            if (!((element1 = element1.getNextSibling()) instanceof CssElement) && !(element1 instanceof CompositePsiElement)) continue;
            element1 = PsiTreeUtil.getDeepestFirst((PsiElement)element1);
        }
        while (element2 != null && SassScssRefactoringPsiHelper.isExtendedWhitespace(element2)) {
            if (!((element2 = element2.getPrevSibling()) instanceof CssElement) && !(element2 instanceof CompositePsiElement)) continue;
            element2 = PsiTreeUtil.getDeepestLast((PsiElement)element2);
        }
        return Pair.create((Object)element1, (Object)element2);
    }

    @Nullable
    public static PsiElement proceedCaretCase(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAt = file.findElementAt(offset);
        elementAt = elementAt == null && offset > 0 ? file.findElementAt(offset - 1) : elementAt;
        PsiElement psiElement = elementAt = elementAt != null && (elementAt.getNode().getElementType() == SASSTokenTypes.EOL || elementAt.getNode().getElementType() == CssElementTypes.CSS_SEMICOLON || elementAt instanceof PsiWhiteSpace) ? PsiTreeUtil.prevLeaf((PsiElement)elementAt) : elementAt;
        while (elementAt != null && !(elementAt instanceof CssDeclaration) && !(elementAt instanceof CssRuleset)) {
            if (SassScssRefactoringPsiHelper.checkCanExtract(elementAt)) {
                return elementAt;
            }
            elementAt = elementAt.getParent();
        }
        return null;
    }

    public static boolean checkCanExtract(PsiElement elementAt) {
        PsiElement[] children = elementAt.getChildren();
        SassScssVariableDeclaration variableDeclaration = (SassScssVariableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)elementAt, SassScssVariableDeclaration.class);
        PsiElement child = variableDeclaration != null ? variableDeclaration.getValue() : null;
        return elementAt instanceof CssTerm && (children.length != 1 || !(children[0] instanceof SCSSOperationImpl) && !(children[0] instanceof SassScssVariableImpl)) && (child == null || !child.getText().equals(elementAt.getText())) || elementAt instanceof CssTermList && children.length > 1 || elementAt instanceof SCSSOperationImpl && (child == null || !child.getText().equals(elementAt.getText()));
    }

    static boolean isExtendedWhitespace(PsiElement element) {
        return element instanceof PsiWhiteSpace || "\n".equals(element.getText()) || ";".equals(element.getText()) || element instanceof PsiComment;
    }
}

