/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.backend.split.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.content.Content;
import com.jetbrains.codeWithMe.model.DebuggerSessionModel;
import com.jetbrains.codeWithMe.model.SessionTabInfo;
import com.jetbrains.rdserver.debugger.DebuggerAdditionalTabCustomizer;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.memoryView.RiderClassesHeapView;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/backend/split/debugger/RiderDebuggerAdditionalTabCustomizer;", "Lcom/jetbrains/rdserver/debugger/DebuggerAdditionalTabCustomizer;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "addMemoryViewSelectionListenerIfNeeded", "", "memoryViewContent", "Lcom/intellij/ui/content/Content;", "sessionModel", "Lcom/jetbrains/codeWithMe/model/DebuggerSessionModel;", "sessionTabInfo", "Lcom/jetbrains/codeWithMe/model/SessionTabInfo;", "customize", "content", "intellij.rider.backend.split"})
@SourceDebugExtension(value={"SMAP\nRiderDebuggerAdditionalTabCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDebuggerAdditionalTabCustomizer.kt\ncom/jetbrains/rider/backend/split/debugger/RiderDebuggerAdditionalTabCustomizer\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,33:1\n13#2:34\n13#3:35\n*S KotlinDebug\n*F\n+ 1 RiderDebuggerAdditionalTabCustomizer.kt\ncom/jetbrains/rider/backend/split/debugger/RiderDebuggerAdditionalTabCustomizer\n*L\n13#1:34\n13#1:35\n*E\n"})
public final class RiderDebuggerAdditionalTabCustomizer
implements DebuggerAdditionalTabCustomizer {
    @NotNull
    private final Logger logger;

    public RiderDebuggerAdditionalTabCustomizer() {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderDebuggerAdditionalTabCustomizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    private final void addMemoryViewSelectionListenerIfNeeded(Content memoryViewContent, DebuggerSessionModel sessionModel, SessionTabInfo sessionTabInfo) {
        String memoryViewTabName = RiderDebuggerBundle.Companion.message("display.name.memory", new Object[0]);
        if (!Intrinsics.areEqual((Object)memoryViewContent.getTabName(), (Object)memoryViewTabName)) {
            return;
        }
        JComponent jComponent = memoryViewContent.getComponent();
        RiderClassesHeapView riderClassesHeapView = jComponent instanceof RiderClassesHeapView ? (RiderClassesHeapView)jComponent : null;
        if (riderClassesHeapView == null) {
            RiderDebuggerAdditionalTabCustomizer it = this;
            boolean bl = false;
            this.logger.warn("Tab with name " + memoryViewTabName + " is expected to be RiderClassesHeapView");
            return;
        }
        RiderClassesHeapView riderMemoryView = riderClassesHeapView;
        sessionModel.getAdditionalSessionTabs().getSelectedTab().advise(LifetimeDisposableExKt.createLifetime((Disposable)((Disposable)riderMemoryView)), arg_0 -> RiderDebuggerAdditionalTabCustomizer.addMemoryViewSelectionListenerIfNeeded$lambda$1(riderMemoryView, sessionTabInfo, arg_0));
    }

    public void customize(@NotNull Content content, @NotNull SessionTabInfo sessionTabInfo, @NotNull DebuggerSessionModel sessionModel) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)sessionTabInfo, (String)"sessionTabInfo");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        this.addMemoryViewSelectionListenerIfNeeded(content, sessionModel, sessionTabInfo);
    }

    private static final Unit addMemoryViewSelectionListenerIfNeeded$lambda$1(RiderClassesHeapView $riderMemoryView, SessionTabInfo $sessionTabInfo, Integer selectedTabId) {
        Integer n = selectedTabId;
        int n2 = $sessionTabInfo.getTabId();
        $riderMemoryView.setActive(n != null && n == n2);
        return Unit.INSTANCE;
    }
}

