/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.toolWindow;

import com.intellij.openapi.project.Project;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.containers.Stack;
import com.jetbrains.rider.diagrams.architecture.DiagramHost;
import com.jetbrains.rider.diagrams.architecture.ProjectDiagramUtils;
import com.jetbrains.rider.diagrams.architecture.fus.RiderDiagramFUSLogger;
import com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramFolderTreeNode;
import com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramGroupTreeNode;
import com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramRootTreeNode;
import com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramTree;
import com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramTreeNode;
import com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramTreeNodeBase;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J,\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 2\u0006\u0010!\u001a\u00020\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070 2\u0006\u0010#\u001a\u00020\u0007H\u0002J\u001e\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070 H\u0002J\u0018\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020&H\u0002J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010(\u001a\u00020&2\u0006\u0010+\u001a\u00020&H\u0002J \u0010,\u001a\u00020\u00172\u0006\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020&2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020&H\u0002J\u0018\u00102\u001a\u00020.2\u0006\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020&H\u0002J\u0010\u00103\u001a\u00020.2\u0006\u00100\u001a\u00020&H\u0002J\u0018\u00104\u001a\u00020.2\u0006\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020&H\u0002J\u0010\u00105\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u00066"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramTreeController;", "", "tree", "Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramTree;", "project", "Lcom/intellij/openapi/project/Project;", "fqn", "", "<init>", "(Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramTree;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getTree", "()Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramTree;", "getProject", "()Lcom/intellij/openapi/project/Project;", "diagramHost", "Lcom/jetbrains/rider/diagrams/architecture/DiagramHost;", "root", "Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramRootTreeNode;", "getRoot", "()Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramRootTreeNode;", "setRoot", "(Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramRootTreeNode;)V", "updateNodes", "", "buildProjectsTree", "projects", "", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "getOrCreateFolderNode", "Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramFolderTreeNode;", "folderEntity", "getTreePath", "Lcom/intellij/util/containers/Stack;", "entity", "path", "rootName", "walkAndCreateFolderTreeNodes", "currNode", "Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramTreeNodeBase;", "insertOrdered", "parent", "toInsert", "insertNodeOrdered", "node", "insertAndShiftTail", "idxAt", "", "compareNodes", "x", "y", "compareNodeTypes", "getNodeOrderMark", "compareNodeNames", "createRoot", "intellij.rider.plugins.diagram"})
@SourceDebugExtension(value={"SMAP\nRiderProjectDiagramTreeController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderProjectDiagramTreeController.kt\ncom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramTreeController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n230#2,2:179\n1869#2,2:181\n295#2,2:183\n295#2,2:185\n*S KotlinDebug\n*F\n+ 1 RiderProjectDiagramTreeController.kt\ncom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramTreeController\n*L\n42#1:179,2\n45#1:181,2\n65#1:183,2\n89#1:185,2\n*E\n"})
public final class RiderProjectDiagramTreeController {
    @NotNull
    private final RiderProjectDiagramTree tree;
    @NotNull
    private final Project project;
    @NotNull
    private final String fqn;
    @NotNull
    private final DiagramHost diagramHost;
    @Nullable
    private RiderProjectDiagramRootTreeNode root;

    public RiderProjectDiagramTreeController(@NotNull RiderProjectDiagramTree tree, @NotNull Project project, @NotNull String fqn) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        this.tree = tree;
        this.project = project;
        this.fqn = fqn;
        this.diagramHost = DiagramHost.Companion.getInstance(this.project);
        this.buildProjectsTree(ProjectDiagramUtils.INSTANCE.collectProjectsAndSolutions(this.project));
        this.tree.addCheckboxTreeListener(new CheckboxTreeListener(){

            public void nodeStateChanged(CheckedTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node instanceof RiderProjectDiagramTreeNode) {
                    RiderDiagramFUSLogger.INSTANCE.onCheckboxClick(this.getProject(), ((RiderProjectDiagramTreeNode)node).isChecked());
                    if (((RiderProjectDiagramTreeNode)node).isChecked()) {
                        DiagramHost diagramHost = diagramHost;
                        Integer n = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)((RiderProjectDiagramTreeNode)node).getProjectEntity(), (Project)this.getProject());
                        Intrinsics.checkNotNull((Object)n);
                        v2 = diagramHost.selectProject(n, fqn);
                    } else {
                        DiagramHost diagramHost = diagramHost;
                        Integer n = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)((RiderProjectDiagramTreeNode)node).getProjectEntity(), (Project)this.getProject());
                        Intrinsics.checkNotNull((Object)n);
                        v2 = diagramHost.deselectProject(n, fqn);
                    }
                }
            }
        });
    }

    @NotNull
    public final RiderProjectDiagramTree getTree() {
        return this.tree;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final RiderProjectDiagramRootTreeNode getRoot() {
        return this.root;
    }

    public final void setRoot(@Nullable RiderProjectDiagramRootTreeNode riderProjectDiagramRootTreeNode) {
        this.root = riderProjectDiagramRootTreeNode;
    }

    public final void updateNodes() {
        block2: {
            Object object;
            block4: {
                block3: {
                    if (this.root == null) break block2;
                    object = this.tree.getExpandedDescendants(new TreePath(this.root));
                    if (object == null) break block3;
                    ArrayList arrayList = Collections.list(object);
                    Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                    object = arrayList;
                    if (object != null) break block4;
                }
                object = CollectionsKt.emptyList();
            }
            Object expandedDescendants = object;
            this.tree.updateNodes();
            this.tree.updateExpandedPath((List<? extends TreePath>)expandedDescendants);
        }
    }

    public final void buildProjectsTree(@NotNull List<? extends ProjectModelEntity> projects) {
        ProjectModelEntity it;
        Object element$iv2;
        block5: {
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            Iterable $this$first$iv = projects;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                it = (ProjectModelEntity)element$iv2;
                boolean bl = false;
                if (!(it.getParentEntity() == null)) continue;
                break block5;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        ProjectModelEntity rootNode = (ProjectModelEntity)element$iv2;
        this.root = this.createRoot(rootNode);
        Iterable $this$forEach$iv = projects;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            it = (ProjectModelEntity)element$iv2;
            boolean bl = false;
            if (it.getParentEntity() == null) continue;
            RiderProjectDiagramTreeNode node = new RiderProjectDiagramTreeNode(it.getName(), it);
            ProjectModelEntity parent = it.getParentEntity();
            if (parent != null && !Intrinsics.areEqual((Object)ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)parent, (Project)this.project), (Object)ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)rootNode, (Project)this.project))) {
                RiderProjectDiagramRootTreeNode riderProjectDiagramRootTreeNode = this.root;
                if (riderProjectDiagramRootTreeNode == null) {
                    throw new IllegalStateException("Root is null".toString());
                }
                RiderProjectDiagramFolderTreeNode folder = this.getOrCreateFolderNode(parent, riderProjectDiagramRootTreeNode);
                this.insertOrdered(folder, node);
                continue;
            }
            RiderProjectDiagramRootTreeNode riderProjectDiagramRootTreeNode = this.root;
            if (riderProjectDiagramRootTreeNode == null) {
                throw new IllegalStateException("Root is null".toString());
            }
            this.insertOrdered(riderProjectDiagramRootTreeNode, node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final RiderProjectDiagramFolderTreeNode getOrCreateFolderNode(ProjectModelEntity folderEntity, RiderProjectDiagramRootTreeNode root) {
        if (folderEntity.getParentEntity() == null) {
            ProjectModelEntity projectModelEntity = folderEntity.getParentEntity();
            if (!Intrinsics.areEqual((Object)(projectModelEntity != null ? projectModelEntity.getName() : null), (Object)root.getMarker())) {
                Object v4;
                RiderProjectDiagramFolderTreeNode folderTreeNode;
                block4: {
                    void $this$firstOrNull$iv;
                    Integer n = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)folderEntity, (Project)this.project);
                    Intrinsics.checkNotNull((Object)n);
                    folderTreeNode = new RiderProjectDiagramFolderTreeNode(n, folderEntity.getName());
                    Enumeration enumeration = root.children();
                    Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"children(...)");
                    ArrayList arrayList = Collections.list(enumeration);
                    Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                    Iterable iterable = arrayList;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        TreeNode it = (TreeNode)element$iv;
                        boolean bl = false;
                        if (!(it instanceof RiderProjectDiagramFolderTreeNode && Intrinsics.areEqual((Object)((RiderProjectDiagramFolderTreeNode)((Object)it)).getMarker(), (Object)folderEntity.getName()))) continue;
                        v4 = element$iv;
                        break block4;
                    }
                    v4 = null;
                }
                TreeNode exists = v4;
                if (exists == null) {
                    root.add((MutableTreeNode)((Object)folderTreeNode));
                    return folderTreeNode;
                }
                return (RiderProjectDiagramFolderTreeNode)((Object)exists);
            }
        }
        Stack<String> path = this.getTreePath(folderEntity, (Stack<String>)new Stack(), root.getMarker());
        return this.walkAndCreateFolderTreeNodes(root, path);
    }

    private final Stack<String> getTreePath(ProjectModelEntity entity, Stack<String> path, String rootName) {
        block3: {
            block2: {
                path.push((Object)entity.getName());
                if (entity.getParentEntity() == null) break block2;
                ProjectModelEntity projectModelEntity = entity.getParentEntity();
                if (!Intrinsics.areEqual((Object)(projectModelEntity != null ? projectModelEntity.getName() : null), (Object)rootName)) break block3;
            }
            return path;
        }
        ProjectModelEntity projectModelEntity = entity.getParentEntity();
        Intrinsics.checkNotNull((Object)projectModelEntity);
        return this.getTreePath(projectModelEntity, path, rootName);
    }

    /*
     * WARNING - void declaration
     */
    private final RiderProjectDiagramFolderTreeNode walkAndCreateFolderTreeNodes(RiderProjectDiagramTreeNodeBase currNode, Stack<String> path) {
        Object v3;
        String childName;
        block4: {
            void $this$firstOrNull$iv;
            String string = (String)path.tryPop();
            if (string == null) {
                Intrinsics.checkNotNull((Object)currNode, (String)"null cannot be cast to non-null type com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramFolderTreeNode");
                return (RiderProjectDiagramFolderTreeNode)currNode;
            }
            childName = string;
            Enumeration enumeration = currNode.children();
            Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"children(...)");
            ArrayList arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            Iterable iterable = arrayList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TreeNode it = (TreeNode)element$iv;
                boolean bl = false;
                if (!(it instanceof RiderProjectDiagramFolderTreeNode && Intrinsics.areEqual((Object)((RiderProjectDiagramFolderTreeNode)((Object)it)).getMarker(), (Object)childName))) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        TreeNode child = v3;
        if (child == null) {
            Intrinsics.checkNotNull((Object)currNode, (String)"null cannot be cast to non-null type com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramGroupTreeNode");
            RiderProjectDiagramFolderTreeNode folderNode = new RiderProjectDiagramFolderTreeNode(((RiderProjectDiagramGroupTreeNode)currNode).getId(), childName);
            this.insertOrdered(currNode, folderNode);
            if (path.empty()) {
                return folderNode;
            }
            return this.walkAndCreateFolderTreeNodes(folderNode, path);
        }
        return this.walkAndCreateFolderTreeNodes((RiderProjectDiagramFolderTreeNode)((Object)child), path);
    }

    private final void insertOrdered(RiderProjectDiagramTreeNodeBase parent, RiderProjectDiagramTreeNodeBase toInsert) {
        RiderProjectDiagramTreeNodeBase riderProjectDiagramTreeNodeBase = toInsert;
        if (riderProjectDiagramTreeNodeBase instanceof RiderProjectDiagramRootTreeNode) {
            return;
        }
        if (riderProjectDiagramTreeNodeBase instanceof RiderProjectDiagramFolderTreeNode) {
            this.insertNodeOrdered(parent, toInsert);
        } else if (riderProjectDiagramTreeNodeBase instanceof RiderProjectDiagramTreeNode) {
            this.insertNodeOrdered(parent, toInsert);
        } else if (!(riderProjectDiagramTreeNodeBase instanceof RiderProjectDiagramGroupTreeNode)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void insertNodeOrdered(RiderProjectDiagramTreeNodeBase parent, RiderProjectDiagramTreeNodeBase node) {
        int n = parent.getChildCount();
        for (int i = 0; i < n; ++i) {
            int comparisonResult;
            TreeNode child = parent.getChildAt(i);
            if (!(child instanceof RiderProjectDiagramTreeNodeBase) || (comparisonResult = this.compareNodes(node, (RiderProjectDiagramTreeNodeBase)((Object)child))) <= 0) continue;
            this.insertAndShiftTail(parent, node, i);
            return;
        }
        parent.add((MutableTreeNode)((Object)node));
    }

    private final void insertAndShiftTail(RiderProjectDiagramTreeNodeBase parent, RiderProjectDiagramTreeNodeBase toInsert, int idxAt) {
        TreeNode treeNode = parent.getChildAt(idxAt);
        Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramTreeNodeBase");
        RiderProjectDiagramTreeNodeBase current = (RiderProjectDiagramTreeNodeBase)((Object)treeNode);
        parent.remove(idxAt);
        parent.insert((MutableTreeNode)((Object)toInsert), idxAt);
        parent.insert((MutableTreeNode)((Object)current), idxAt + 1);
    }

    private final int compareNodes(RiderProjectDiagramTreeNodeBase x, RiderProjectDiagramTreeNodeBase y) {
        int typesComparison = this.compareNodeTypes(x, y);
        if (typesComparison != 0) {
            return typesComparison;
        }
        return this.compareNodeNames(x, y);
    }

    private final int compareNodeTypes(RiderProjectDiagramTreeNodeBase x, RiderProjectDiagramTreeNodeBase y) {
        int xMark = this.getNodeOrderMark(x);
        int yMark = this.getNodeOrderMark(y);
        return xMark < yMark ? 1 : (xMark > yMark ? -1 : 0);
    }

    private final int getNodeOrderMark(RiderProjectDiagramTreeNodeBase x) {
        RiderProjectDiagramTreeNodeBase riderProjectDiagramTreeNodeBase = x;
        return riderProjectDiagramTreeNodeBase instanceof RiderProjectDiagramRootTreeNode ? 0 : (riderProjectDiagramTreeNodeBase instanceof RiderProjectDiagramFolderTreeNode ? 1 : (riderProjectDiagramTreeNodeBase instanceof RiderProjectDiagramTreeNode ? 2 : 3));
    }

    private final int compareNodeNames(RiderProjectDiagramTreeNodeBase x, RiderProjectDiagramTreeNodeBase y) {
        int nameComparison = StringsKt.compareTo((String)x.getName(), (String)y.getName(), (boolean)true);
        return nameComparison < 0 ? 1 : (nameComparison > 0 ? -1 : 0);
    }

    private final RiderProjectDiagramRootTreeNode createRoot(ProjectModelEntity entity) {
        Integer n = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)entity, (Project)this.project);
        Intrinsics.checkNotNull((Object)n);
        return new RiderProjectDiagramRootTreeNode(n, entity.getName());
    }
}

