/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.toolWindow;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.anim.AnimationFactory;
import com.intellij.openapi.graph.anim.AnimationListener;
import com.intellij.openapi.graph.anim.AnimationObject;
import com.intellij.openapi.graph.anim.AnimationPlayer;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.layout.ApplyCurrentLayoutAction;
import com.intellij.openapi.graph.layout.GraphLayout;
import com.intellij.openapi.graph.layout.LayoutGraph;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LayoutMorpher;
import com.intellij.openapi.graph.view.hierarchy.GroupLayoutConfigurator;
import com.jetbrains.rider.diagrams.architecture.RiderDiagramBundle;
import com.jetbrains.rider.diagrams.architecture.fus.RiderDiagramFUSLogger;
import com.jetbrains.rider.diagrams.architecture.graph.RiderGraphBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderApplyCurrentLayoutAction;", "Lcom/intellij/openapi/graph/builder/actions/layout/ApplyCurrentLayoutAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "graph", "Lcom/intellij/openapi/graph/view/Graph2D;", "update", "doLayout", "view", "Lcom/intellij/openapi/graph/view/Graph2DView;", "builder", "Lcom/jetbrains/rider/diagrams/architecture/graph/RiderGraphBuilder;", "layouter", "Lcom/intellij/openapi/graph/layout/Layouter;", "settings", "Lcom/intellij/openapi/graph/settings/GraphSettings;", "intellij.rider.plugins.diagram"})
public final class RiderApplyCurrentLayoutAction
extends ApplyCurrentLayoutAction {
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        GraphBuilder graphBuilder = this.getBuilder(e);
        RiderGraphBuilder riderGraphBuilder = graphBuilder instanceof RiderGraphBuilder ? (RiderGraphBuilder)graphBuilder : null;
        if (riderGraphBuilder == null) {
            return;
        }
        RiderGraphBuilder builder = riderGraphBuilder;
        Graph2DView view = AbstractGraphAction.getGraph2DView((Graph2D)graph);
        GraphSettings graphSettings = builder.getGraphPresentationModel().getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)graphSettings, (String)"getSettings(...)");
        GraphSettings settings = graphSettings;
        Intrinsics.checkNotNull((Object)view);
        Layouter layouter = settings.getCurrentLayouter();
        Intrinsics.checkNotNullExpressionValue((Object)layouter, (String)"getCurrentLayouter(...)");
        this.doLayout(view, builder, layouter, settings);
        RiderDiagramFUSLogger.INSTANCE.onApplyCurrentLayout(e.getProject());
    }

    public void update(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        super.update(e, graph);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        presentation2.setText(RiderDiagramBundle.message("action.apply.current.layout.text", new Object[0]));
    }

    private final void doLayout(Graph2DView view, RiderGraphBuilder builder, Layouter layouter, GraphSettings settings) {
        GraphManager graphManager = GraphManager.getGraphManager();
        GroupLayoutConfigurator glc = graphManager.createGroupLayoutConfigurator(view.getGraph2D());
        if (settings.isFitContentAfterLayout()) {
            glc.prepareAll();
            graphManager.createBufferedLayouter(layouter).doLayout((LayoutGraph)view.getGraph2D());
            glc.restoreAll();
            builder.fitContent(true);
        } else {
            glc.prepareAll();
            GraphLayout layout = graphManager.createBufferedLayouter(layouter).calcLayout((LayoutGraph)view.getGraph2D());
            glc.restoreAll();
            LayoutMorpher morpher = graphManager.createLayoutMorpher(view, layout);
            morpher.setPreferredDuration(800L);
            morpher.setKeepZoomFactor(true);
            AnimationPlayer player = graphManager.createAnimationPlayer();
            player.addAnimationListener((AnimationListener)view);
            player.setFps(1200);
            player.animate(AnimationFactory.Statics.createEasedAnimation((AnimationObject)((AnimationObject)morpher)));
            GraphAnimationService.getInstance().updateWorldRect(view);
        }
        view.getGraph2D().updateViews();
    }
}

