/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.graph;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.anim.AnimationFactory;
import com.intellij.openapi.graph.anim.AnimationListener;
import com.intellij.openapi.graph.anim.AnimationObject;
import com.intellij.openapi.graph.anim.AnimationPlayer;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.layout.GraphLayout;
import com.intellij.openapi.graph.layout.LayoutGraph;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LayoutMorpher;
import com.intellij.openapi.graph.view.hierarchy.GroupLayoutConfigurator;
import com.jetbrains.rider.diagrams.architecture.graph.RiderGraphBuilder;
import com.jetbrains.rider.diagrams.architecture.graph.RiderGraphUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/graph/RiderGraphLayouter;", "", "<init>", "()V", "doLayout", "", "graph", "Lcom/intellij/openapi/graph/view/Graph2D;", "view", "Lcom/intellij/openapi/graph/view/Graph2DView;", "builder", "Lcom/jetbrains/rider/diagrams/architecture/graph/RiderGraphBuilder;", "doAnimatedLayout", "intellij.rider.plugins.diagram"})
public final class RiderGraphLayouter {
    public final void doLayout(@NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull RiderGraphBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)builder), (String)"builder");
        Node[] nodeArray = graph.getNodeArray();
        Intrinsics.checkNotNullExpressionValue((Object)nodeArray, (String)"getNodeArray(...)");
        if (ArraysKt.any((Object[])nodeArray)) {
            RiderGraphUtil.Companion.doLayout((GraphBuilder)builder);
            GraphAnimationService.getInstance().updateWorldRect(view);
            graph.updateViews();
        }
    }

    public final void doAnimatedLayout(@NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull RiderGraphBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)builder), (String)"builder");
        Node[] nodeArray = graph.getNodeArray();
        Intrinsics.checkNotNullExpressionValue((Object)nodeArray, (String)"getNodeArray(...)");
        if (ArraysKt.any((Object[])nodeArray)) {
            GraphSettings graphSettings = builder.getGraphPresentationModel().getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)graphSettings, (String)"getSettings(...)");
            GraphSettings settings = graphSettings;
            Layouter layouter = settings.getCurrentLayouter();
            Intrinsics.checkNotNullExpressionValue((Object)layouter, (String)"getCurrentLayouter(...)");
            Layouter layouter2 = layouter;
            GraphManager gm = GraphManager.getGraphManager();
            GroupLayoutConfigurator glc = gm.createGroupLayoutConfigurator(view.getGraph2D());
            glc.prepareAll();
            GraphLayout layout = gm.createBufferedLayouter(layouter2).calcLayout((LayoutGraph)view.getGraph2D());
            LayoutMorpher morpher = gm.createLayoutMorpher(view, layout);
            morpher.setPreferredDuration(500L);
            morpher.setKeepZoomFactor(true);
            AnimationPlayer player = gm.createAnimationPlayer();
            player.addAnimationListener((AnimationListener)view);
            player.setFps(1200);
            player.animate(AnimationFactory.Statics.createEasedAnimation((AnimationObject)((AnimationObject)morpher)));
            GraphAnimationService.getInstance().updateWorldRect(view);
            view.getGraph2D().updateViews();
            glc.restoreAll();
        }
    }
}

