/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.filesystem;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.rider.diagrams.architecture.filesystem.RiderDiagramVirtualFileType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001dJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001f\u001a\u00020 2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018J\u0006\u0010!\u001a\u00020 J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0004H\u0016J\b\u0010%\u001a\u00020\u0004H\u0016J\u0010\u0010&\u001a\u00020 2\b\u0010'\u001a\u0004\u0018\u00010\u0004J\b\u0010(\u001a\u00020\u0004H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020#H\u0016J\b\u0010,\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/filesystem/RiderDiagramVirtualFile;", "Lcom/intellij/testFramework/LightVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "myName", "", "<init>", "(Ljava/lang/String;)V", "myProject", "Lcom/intellij/openapi/project/Project;", "value", "project", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "state", "Lcom/intellij/diagram/presentation/DiagramState;", "getState", "()Lcom/intellij/diagram/presentation/DiagramState;", "setState", "(Lcom/intellij/diagram/presentation/DiagramState;)V", "presentableName", "myBuilders", "", "Lcom/intellij/diagram/DiagramBuilder;", "builder", "getBuilder", "()Lcom/intellij/diagram/DiagramBuilder;", "getUmlProvider", "Lcom/intellij/diagram/DiagramProvider;", "getFQN", "addBuilder", "", "clearCache", "isWritable", "", "getExtension", "getPresentableName", "setPresentableName", "name", "getPath", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "enforcePresentableName", "getPresentablePath", "intellij.rider.plugins.diagram"})
public final class RiderDiagramVirtualFile
extends LightVirtualFile
implements VirtualFilePathWrapper {
    @NotNull
    private final String myName;
    @Nullable
    private Project myProject;
    @Nullable
    private DiagramState state;
    @Nullable
    private String presentableName;
    @NotNull
    private final List<DiagramBuilder> myBuilders;

    public RiderDiagramVirtualFile(@NotNull String myName) {
        Intrinsics.checkNotNullParameter((Object)myName, (String)"myName");
        super(myName, RiderDiagramVirtualFileType.Companion.getINSTANCE(), (CharSequence)"");
        this.myName = myName;
        this.presentableName = "Project Diagram";
        this.myBuilders = new ArrayList();
    }

    @Nullable
    public final Project getProject() {
        return this.myProject;
    }

    public final void setProject(@Nullable Project value) {
        Project project = this.myProject = value;
        if (project == null) {
            return;
        }
        Disposer.register((Disposable)((Disposable)project), this::clearCache);
    }

    @Nullable
    public final DiagramState getState() {
        return this.state;
    }

    public final void setState(@Nullable DiagramState diagramState) {
        this.state = diagramState;
    }

    @Nullable
    public final DiagramBuilder getBuilder() {
        return !CollectionsKt.any((Iterable)this.myBuilders) ? null : (DiagramBuilder)CollectionsKt.last(this.myBuilders);
    }

    @Nullable
    public final DiagramProvider<?> getUmlProvider() {
        DiagramProvider diagramProvider;
        int ind = StringsKt.indexOf$default((CharSequence)this.myName, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (ind == -1) {
            diagramProvider = null;
        } else {
            String string = this.myName.substring(0, ind);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            diagramProvider = DiagramProvider.findByID((String)string);
        }
        return diagramProvider;
    }

    @Nullable
    public final String getFQN() {
        String string;
        int ind = StringsKt.indexOf$default((CharSequence)this.myName, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (ind == -1) {
            string = null;
        } else {
            String string2 = this.myName.substring(ind + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return string;
    }

    public final void addBuilder(@Nullable DiagramBuilder builder) {
        if (!CollectionsKt.contains((Iterable)this.myBuilders, (Object)builder)) {
            DiagramBuilder diagramBuilder = builder;
            Intrinsics.checkNotNull((Object)diagramBuilder);
            this.myBuilders.add(diagramBuilder);
        }
        DiagramBuilder diagramBuilder = builder;
        Intrinsics.checkNotNull((Object)diagramBuilder);
        Disposer.register((Disposable)((Disposable)diagramBuilder), () -> RiderDiagramVirtualFile.addBuilder$lambda$0(this, builder));
    }

    public final void clearCache() {
        this.myBuilders.clear();
    }

    public boolean isWritable() {
        return true;
    }

    @NotNull
    public String getExtension() {
        return "argr";
    }

    @NotNull
    public String getPresentableName() {
        String string = this.presentableName;
        if (string == null) {
            string = "Project Diagram";
        }
        return string;
    }

    public final void setPresentableName(@Nullable String name) {
        this.presentableName = name;
    }

    @NotNull
    public String getPath() {
        return this.myName;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem("riderDiagram");
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
        return virtualFileSystem;
    }

    public boolean enforcePresentableName() {
        return true;
    }

    @NotNull
    public String getPresentablePath() {
        return "Project Diagram";
    }

    private static final void addBuilder$lambda$0(RiderDiagramVirtualFile this$0, DiagramBuilder $builder) {
        this$0.myBuilders.remove($builder);
        if (this$0.myBuilders.isEmpty()) {
            this$0.clearCache();
        }
    }
}

