/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.editor;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.diagrams.architecture.DiagramHost;
import com.jetbrains.rider.diagrams.architecture.RiderProjectDiagramDataModel;
import com.jetbrains.rider.diagrams.architecture.RiderProjectDiagramProvider;
import com.jetbrains.rider.diagrams.architecture.editor.RiderDiagramEditor;
import com.jetbrains.rider.diagrams.architecture.filesystem.RiderDiagramVirtualFile;
import com.jetbrains.rider.diagrams.architecture.graphElements.RiderDiagramNode;
import com.jetbrains.rider.diagrams.architecture.infrastructure.ProjectDiagramDescriptor;
import com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramWindowManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ*\u0010\f\u001a\u00020\r2\b\u0010\u0002\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/editor/RiderProjectDiagramEditor;", "Lcom/jetbrains/rider/diagrams/architecture/editor/RiderDiagramEditor;", "element", "", "initialized", "", "myFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/Object;ZLcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)V", "initialize", "", "Lcom/jetbrains/rider/diagrams/architecture/graphElements/RiderDiagramNode;", "file", "setupToolWindow", "isDiagramEditorOpened", "url", "", "intellij.rider.plugins.diagram"})
@SourceDebugExtension(value={"SMAP\nRiderProjectDiagramEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderProjectDiagramEditor.kt\ncom/jetbrains/rider/diagrams/architecture/editor/RiderProjectDiagramEditor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,60:1\n12970#2,2:61\n*S KotlinDebug\n*F\n+ 1 RiderProjectDiagramEditor.kt\ncom/jetbrains/rider/diagrams/architecture/editor/RiderProjectDiagramEditor\n*L\n58#1:61,2\n*E\n"})
public final class RiderProjectDiagramEditor
extends RiderDiagramEditor {
    public RiderProjectDiagramEditor(@Nullable Object element, boolean initialized, @NotNull VirtualFile myFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(element, initialized, myFile, project);
    }

    @Override
    public void initialize(@Nullable RiderDiagramNode element, boolean initialized, @NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super.initialize(element, initialized, file, project);
        this.setupToolWindow(file, project);
    }

    private final void setupToolWindow(VirtualFile file, Project project) {
        if (!(file instanceof RiderDiagramVirtualFile)) {
            return;
        }
        String string = ((RiderDiagramVirtualFile)file).getFQN();
        if (string == null) {
            return;
        }
        String fqn = string;
        LifetimeDefinition subscriptionLifetime = LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)project));
        DiagramHost diagramHost = DiagramHost.Companion.getInstance(project);
        ProjectDiagramDescriptor descriptor = diagramHost.getProjectDiagramDescriptor(fqn);
        RiderProjectDiagramProvider provider = descriptor.getDiagramProvider();
        RiderProjectDiagramDataModel diagramDataModel = descriptor.getDiagramManager().getDataModel();
        RiderProjectDiagramWindowManager diagramWindowManager = descriptor.getDiagramWindowManager();
        MessageBusConnection messageBusConnection = project.getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)subscriptionLifetime), null, (int)1, null));
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(provider, diagramDataModel, this, project, subscriptionLifetime, fqn, diagramWindowManager, diagramHost){
            final /* synthetic */ RiderProjectDiagramProvider $provider;
            final /* synthetic */ RiderProjectDiagramDataModel $diagramDataModel;
            final /* synthetic */ RiderProjectDiagramEditor this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ LifetimeDefinition $subscriptionLifetime;
            final /* synthetic */ String $fqn;
            final /* synthetic */ RiderProjectDiagramWindowManager $diagramWindowManager;
            final /* synthetic */ DiagramHost $diagramHost;
            {
                this.$provider = $provider;
                this.$diagramDataModel = $diagramDataModel;
                this.this$0 = $receiver;
                this.$project = $project;
                this.$subscriptionLifetime = $subscriptionLifetime;
                this.$fqn = $fqn;
                this.$diagramWindowManager = $diagramWindowManager;
                this.$diagramHost = $diagramHost;
            }

            public void fileClosed(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (Intrinsics.areEqual((Object)file.getUrl(), (Object)this.$provider.getDiagramUrl(this.$diagramDataModel.getFqn()))) {
                    String string = file.getUrl();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                    if (!RiderProjectDiagramEditor.access$isDiagramEditorOpened(this.this$0, this.$project, string)) {
                        LifetimeDefinition.terminate$default((LifetimeDefinition)this.$subscriptionLifetime, (boolean)false, (int)1, null);
                        if (Intrinsics.areEqual((Object)DiagramHost.Companion.getInstance(this.$project).getCurrentToolWindowFqn(), (Object)this.$fqn)) {
                            this.$diagramWindowManager.closeToolWindow();
                        }
                    }
                }
            }

            public void selectionChanged(FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FileEditor newEditor = event.getNewEditor();
                RiderDiagramEditor riderDiagramEditor = newEditor instanceof RiderDiagramEditor ? (RiderDiagramEditor)newEditor : null;
                DiagramDataModel diagramDataModel = riderDiagramEditor != null && (riderDiagramEditor = riderDiagramEditor.getBuilder()) != null ? riderDiagramEditor.getDataModel() : null;
                RiderProjectDiagramDataModel riderProjectDiagramDataModel = diagramDataModel instanceof RiderProjectDiagramDataModel ? (RiderProjectDiagramDataModel)diagramDataModel : null;
                if (riderProjectDiagramDataModel == null) {
                    return;
                }
                RiderProjectDiagramDataModel dataModel = riderProjectDiagramDataModel;
                ProjectDiagramDescriptor desc = this.$diagramHost.getProjectDiagramDescriptor(dataModel.getFqn());
                desc.getDiagramWindowManager().showActualTree();
            }
        });
        diagramWindowManager.getOrRegisterToolWindow().show();
    }

    private final boolean isDiagramEditorOpened(Project project, String url) {
        boolean bl;
        block1: {
            FileEditor[] editors;
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            FileEditor[] fileEditorArray = manager.getAllEditors();
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
            FileEditor[] $this$any$iv = editors = fileEditorArray;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                FileEditor element$iv;
                FileEditor it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                VirtualFile virtualFile = it.getFile();
                if (!Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getUrl() : null), (Object)url)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$isDiagramEditorOpened(RiderProjectDiagramEditor $this, Project project, String url) {
        return $this.isDiagramEditorOpened(project, url);
    }
}

