/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.printing.DarculaAwareGraph2DPrinter;
import com.intellij.openapi.graph.builder.actions.printing.PrintUtil;
import com.intellij.openapi.graph.option.OptionHandler;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DPrinter;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.PrintPreviewPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.diagrams.architecture.RiderDiagramBundle;
import com.jetbrains.rider.diagrams.architecture.actions.RiderPrintGraphAction;
import com.jetbrains.rider.diagrams.architecture.actions.RiderPrintOptionDialog;
import com.jetbrains.rider.diagrams.architecture.fus.RiderDiagramFUSLogger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\u000b\u001a\u00020\u00052\u000e\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/actions/RiderPrintPreviewAction;", "Lcom/intellij/openapi/graph/builder/actions/AbstractGraphAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "graph", "Lcom/intellij/openapi/graph/view/Graph2D;", "actionPerformed", "performInternal", "builder", "Lcom/intellij/openapi/graph/builder/GraphBuilder;", "printJob", "Ljava/awt/print/PrinterJob;", "intellij.rider.plugins.diagram"})
public final class RiderPrintPreviewAction
extends AbstractGraphAction {
    public RiderPrintPreviewAction() {
        this.getTemplatePresentation().setText(RiderDiagramBundle.message("action.print.text", new Object[0]));
        this.getTemplatePresentation().setIcon(AllIcons.Actions.Preview);
    }

    protected void update(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
    }

    protected void actionPerformed(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        GraphBuilder graphBuilder = (GraphBuilder)e.getData(GraphDataKeys.GRAPH_BUILDER);
        if (graphBuilder == null) {
            return;
        }
        GraphBuilder builder = graphBuilder;
        PrinterJob printJob = PrinterJob.getPrinterJob();
        boolean isDarcula = StartupUiUtil.isUnderDarcula();
        RiderDiagramFUSLogger.INSTANCE.onDiagramPrinting(project2, isDarcula);
        Intrinsics.checkNotNull((Object)printJob);
        this.performInternal(builder, printJob);
    }

    private final void performInternal(GraphBuilder<?, ?> builder, PrinterJob printJob) {
        Project project = builder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Graph2D graph2D = builder.getGraph();
        Intrinsics.checkNotNullExpressionValue((Object)graph2D, (String)"getGraph(...)");
        Graph2D graph2D2 = graph2D;
        Graph2DView view = AbstractGraphAction.getGraph2DView((Graph2D)graph2D2);
        DarculaAwareGraph2DPrinter gp = new DarculaAwareGraph2DPrinter(view);
        PrintPreviewPanel panel = GraphManager.getGraphManager().createPrintPreviewPanel(printJob, (Printable)gp, gp.getPosterColumns(), gp.getPosterColumns() * gp.getPosterRows(), printJob.defaultPage());
        panel.setThreadingEnabled(false);
        OptionHandler options = PrintUtil.createPrintOptions();
        AbstractAction optionAction2 = new AbstractAction(project2, options, gp, panel){
            final /* synthetic */ Project $project;
            final /* synthetic */ OptionHandler $options;
            final /* synthetic */ DarculaAwareGraph2DPrinter $gp;
            final /* synthetic */ PrintPreviewPanel $panel;
            {
                this.$project = $project;
                this.$options = $options;
                this.$gp = $gp;
                this.$panel = $panel;
                super("Options...");
            }

            public void actionPerformed(ActionEvent e) {
                OptionHandler optionHandler = this.$options;
                Intrinsics.checkNotNull((Object)optionHandler);
                RiderPrintOptionDialog dialog = new RiderPrintOptionDialog(this.$project, optionHandler);
                if (!dialog.showAndGet()) {
                    return;
                }
                PrintUtil.initGraph2DPrinter((Graph2DPrinter)((Graph2DPrinter)this.$gp), (OptionHandler)this.$options);
                this.$panel.setPages(0, this.$gp.getPosterColumns(), this.$gp.getPosterColumns() * this.$gp.getPosterRows());
            }
        };
        panel.addControlComponent((JComponent)new JButton(optionAction2));
        JPanel panelComponent = panel.getJPanel();
        UIUtil.uiTraverser((Component)panelComponent).filter(JButton.class).filter(arg_0 -> RiderPrintPreviewAction.performInternal$lambda$1(RiderPrintPreviewAction::performInternal$lambda$0, arg_0)).consumeEach(arg_0 -> RiderPrintPreviewAction.performInternal$lambda$3(RiderPrintPreviewAction::performInternal$lambda$2, arg_0));
        new DialogWrapper(project2, panelComponent, printJob, gp, panel){
            final /* synthetic */ JPanel $panelComponent;
            final /* synthetic */ PrinterJob $printJob;
            final /* synthetic */ DarculaAwareGraph2DPrinter $gp;
            final /* synthetic */ PrintPreviewPanel $panel;
            {
                this.$panelComponent = $panelComponent;
                this.$printJob = $printJob;
                this.$gp = $gp;
                this.$panel = $panel;
                super($project);
                this.setTitle(RiderDiagramBundle.message("diagram.dialog.title.print.preview", new Object[0]));
                this.init();
                this.getOKAction().putValue("Name", RiderDiagramBundle.message("diagram.print", new Object[0]));
            }

            protected JComponent createCenterPanel() {
                return this.$panelComponent;
            }

            protected String getDimensionServiceKey() {
                return "Diagram.Print.Preview.Dialog";
            }

            protected void doOKAction() {
                super.doOKAction();
                this.$printJob.setPrintable((Printable)this.$gp, this.$panel.getPageFormat());
                RiderPrintGraphAction.Companion.doPrint(this.$printJob);
            }
        }.show();
    }

    private static final boolean performInternal$lambda$0(JButton o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        String string = o.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.startsWith$default((String)string, (String)"Print", (boolean)false, (int)2, null);
    }

    private static final boolean performInternal$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit performInternal$lambda$2(JButton o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        o.setVisible(false);
        return Unit.INSTANCE;
    }

    private static final void performInternal$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

