/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.printing.DarculaAwareGraph2DPrinter;
import com.intellij.openapi.graph.builder.actions.printing.PrintUtil;
import com.intellij.openapi.graph.option.OptionHandler;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.view.BackgroundRenderer;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DPrinter;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.StartupUiUtil;
import com.jetbrains.rider.diagrams.architecture.actions.RiderPrintOptionDialog;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/actions/RiderPrintGraphAction;", "Lcom/intellij/openapi/graph/builder/actions/AbstractGraphAction;", "<init>", "()V", "myPageFormat", "Ljava/awt/print/PageFormat;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "graph", "Lcom/intellij/openapi/graph/view/Graph2D;", "actionPerformed", "Companion", "intellij.rider.plugins.diagram"})
public final class RiderPrintGraphAction
extends AbstractGraphAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PageFormat myPageFormat;
    @NotNull
    private static final Logger logger;

    protected void update(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
    }

    protected void actionPerformed(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Graph2DView view = AbstractGraphAction.getGraph2DView((Graph2D)graph);
        BackgroundRenderer renderer = view.getBackgroundRenderer();
        GraphBuilder builder = (GraphBuilder)e.getData(GraphDataKeys.GRAPH_BUILDER);
        DarculaAwareGraph2DPrinter printer = new DarculaAwareGraph2DPrinter(view);
        OptionHandler handler = PrintUtil.createPrintOptions();
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)handler);
        RiderPrintOptionDialog dialog = new RiderPrintOptionDialog(project, handler);
        if (!dialog.showAndGet()) {
            return;
        }
        PrintUtil.initGraph2DPrinter((Graph2DPrinter)((Graph2DPrinter)printer), (OptionHandler)handler);
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if (this.myPageFormat == null) {
            this.myPageFormat = printJob.defaultPage();
        }
        PageFormat pageFormat = printJob.pageDialog(this.myPageFormat);
        Intrinsics.checkNotNullExpressionValue((Object)pageFormat, (String)"pageDialog(...)");
        PageFormat pf = pageFormat;
        if (pf == this.myPageFormat) {
            return;
        }
        this.myPageFormat = pf;
        printJob.setPrintable((Printable)printer, this.myPageFormat);
        Intrinsics.checkNotNull((Object)printJob);
        Companion.doPrint(printJob);
    }

    static {
        Logger logger = Logger.getInstance(RiderPrintGraphAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderPrintGraphAction.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000fJ\"\u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0010\u0010\u000e\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000fR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/actions/RiderPrintGraphAction$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "doPrint", "", "printJob", "Ljava/awt/print/PrinterJob;", "setupBackgroundBeforePrint", "graph2D", "Lcom/intellij/openapi/graph/view/Graph2D;", "builder", "Lcom/intellij/openapi/graph/builder/GraphBuilder;", "rollbackBackgroundAfterPrint", "renderer", "Lcom/intellij/openapi/graph/view/BackgroundRenderer;", "intellij.rider.plugins.diagram"})
    public static final class Companion {
        private Companion() {
        }

        public final void doPrint(@NotNull PrinterJob printJob) {
            Intrinsics.checkNotNullParameter((Object)printJob, (String)"printJob");
            if (printJob.printDialog()) {
                try {
                    printJob.print();
                }
                catch (Exception ex) {
                    logger.error((Throwable)ex);
                }
            }
        }

        public final void setupBackgroundBeforePrint(@NotNull Graph2D graph2D, @Nullable GraphBuilder<?, ?> builder) {
            Intrinsics.checkNotNullParameter((Object)graph2D, (String)"graph2D");
            if (!StartupUiUtil.isUnderDarcula()) {
                return;
            }
            graph2D.getCurrentView().updateView();
            if (builder != null) {
                builder.updateGraph();
                builder.getGraph().updateViews();
            }
        }

        public final void rollbackBackgroundAfterPrint(@Nullable BackgroundRenderer renderer, @Nullable GraphBuilder<?, ?> builder) {
            block2: {
                if (!StartupUiUtil.isUnderDarcula()) {
                    return;
                }
                GraphExportService.getInstance().setPrintMode(false);
                JBColor.setDark((boolean)StartupUiUtil.isUnderDarcula());
                if (renderer instanceof DefaultBackgroundRenderer) {
                    ((DefaultBackgroundRenderer)renderer).setColor(JBColor.background());
                }
                GraphBuilder<?, ?> graphBuilder = builder;
                if (graphBuilder == null) break block2;
                graphBuilder.updateGraph();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

