/*
 * Decompiled with CFR 0.152.
 */
package tscn.toolWindow;

import com.intellij.ide.ActivityTracker;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.BitUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import common.util.GdScriptProjectLifetimeService;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tscn.toolWindow.RebuildDelay;
import tscn.toolWindow.TscnScenePreviewWindow;
import tscn.toolWindow.model.TscnSceneTreeBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\u0006\u0010\u001d\u001a\u00020\u0017J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0017H\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0012H\u0002J\b\u0010#\u001a\u00020\u0017H\u0002J\u0012\u0010$\u001a\u00020\u00172\b\u0010%\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010&\u001a\u00020\u0017H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006+"}, d2={"Ltscn/toolWindow/TscnScenePreviewWindow;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;)V", "activityCount", "", "myFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "pendingRebuild", "Ljava/util/concurrent/atomic/AtomicBoolean;", "rebuildRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Ltscn/toolWindow/RebuildDelay;", "isStructureViewShowing", "", "()Z", "runScheduler", "", "dispose", "runTask", "task", "Ljava/lang/Runnable;", "checkUpdate", "rebuildNow", "getVirtualFile", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "scheduleRebuild", "delay", "setFileFromSelectionHistory", "setFile", "file", "rebuildImpl", "createContentPanel", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JComponent;", "intellij.rider.plugins.godot.gdscript"})
public final class TscnScenePreviewWindow
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ToolWindow toolWindow;
    private int activityCount;
    @Nullable
    private VirtualFile myFile;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final AtomicBoolean pendingRebuild;
    @NotNull
    private final MutableSharedFlow<RebuildDelay> rebuildRequests;

    private final boolean isStructureViewShowing() {
        ToolWindowManager windowManager = ToolWindowManager.Companion.getInstance(this.project);
        ToolWindow toolWindow = windowManager.getToolWindow("TscnScenePreviewWindowId");
        return toolWindow != null && toolWindow.isVisible();
    }

    public TscnScenePreviewWindow(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.pendingRebuild = new AtomicBoolean(false);
        this.rebuildRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.project = project;
        this.toolWindow = toolWindow;
        this.coroutineScope = GdScriptProjectLifetimeService.Companion.getScope(project);
    }

    public final void runScheduler() {
        JComponent jComponent = this.toolWindow.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent component = jComponent;
        Timer timer = TimerUtil.createNamedTimer((String)"SceneView", (int)100, arg_0 -> TscnScenePreviewWindow.runScheduler$lambda$0(component, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)timer, (String)"createNamedTimer(...)");
        Timer timer2 = timer;
        timer2.start();
        Disposer.register((Disposable)this, () -> TscnScenePreviewWindow.runScheduler$lambda$1(timer2));
        component.addHierarchyListener(arg_0 -> TscnScenePreviewWindow.runScheduler$lambda$2(this, arg_0));
        if (component.isShowing()) {
            this.runTask(() -> TscnScenePreviewWindow.runScheduler$lambda$3(this));
            this.scheduleRebuild();
        }
        Disposer.register((Disposable)((Disposable)this.toolWindow.getContentManager()), (Disposable)this);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TscnScenePreviewWindow this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.debounce((Flow)((Flow)TscnScenePreviewWindow.access$getRebuildRequests$p(this.this$0)), runScheduler.4::invokeSuspend$lambda$0), (Function2)((Function2)new Function2<RebuildDelay, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ TscnScenePreviewWindow this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        TscnScenePreviewWindow.access$rebuildImpl(this.this$0);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(RebuildDelay p1, Continuation<? super Unit> p2) {
                                return (this.create((Object)((Object)p1), p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final long invokeSuspend$lambda$0(RebuildDelay it) {
                return switch (runScheduler.WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                    case 1 -> 0L;
                    case 2 -> 100L;
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
        }), (int)3, null);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkFileListener(this){
            final /* synthetic */ TscnScenePreviewWindow this$0;
            {
                this.this$0 = $receiver;
            }

            public void after(List<? extends VFileEvent> events) {
                block2: {
                    Object v0;
                    TscnScenePreviewWindow tscnScenePreviewWindow;
                    Iterable iterable;
                    block1: {
                        Intrinsics.checkNotNullParameter(events, (String)"events");
                        iterable = events;
                        tscnScenePreviewWindow = this.this$0;
                        Iterable iterable2 = iterable;
                        for (T t : iterable2) {
                            VFileEvent it = (VFileEvent)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getFile(), (Object)TscnScenePreviewWindow.access$getMyFile$p(tscnScenePreviewWindow))) continue;
                            v0 = t;
                            break block1;
                        }
                        v0 = null;
                    }
                    VFileEvent vFileEvent = v0;
                    if (vFileEvent == null) break block2;
                    iterable = vFileEvent;
                    tscnScenePreviewWindow = this.this$0;
                    Iterable it = iterable;
                    boolean bl = false;
                    TscnScenePreviewWindow.access$scheduleRebuild(tscnScenePreviewWindow);
                }
            }
        });
    }

    public void dispose() {
    }

    private final boolean runTask(Runnable task) {
        try {
            task.run();
            return true;
        }
        catch (Throwable exception) {
            return false;
        }
    }

    private final void checkUpdate() {
        if (this.project.isDisposed()) {
            return;
        }
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        DataContext dataContext = DataManager.getInstance().getDataContext(owner);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        ToolWindowManager.Companion.getInstance(this.project).invokeLater(() -> TscnScenePreviewWindow.checkUpdate$lambda$0(this, dataContext2));
    }

    public final void rebuildNow() {
        this.scheduleRebuild(RebuildDelay.NOW);
    }

    private final VirtualFile getVirtualFile(DataContext dataContext) {
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        return files != null && files.length == 1 ? files[0] : null;
    }

    private final void scheduleRebuild() {
        if (!this.toolWindow.isVisible()) {
            return;
        }
        this.scheduleRebuild(RebuildDelay.QUEUE);
    }

    private final void scheduleRebuild(RebuildDelay delay) {
        this.pendingRebuild.set(true);
        if (!this.rebuildRequests.tryEmit((Object)delay)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    private final void setFileFromSelectionHistory() {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
        FileEditorManagerImpl editorManager = (FileEditorManagerImpl)fileEditorManager;
        Pair firstInHistory = (Pair)CollectionsKt.firstOrNull((List)editorManager.getSelectionHistory());
        if (firstInHistory != null) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Pair<VirtualFile, EditorWindow>)firstInHistory, null){
                int label;
                final /* synthetic */ TscnScenePreviewWindow this$0;
                final /* synthetic */ Pair<VirtualFile, EditorWindow> $firstInHistory;
                {
                    this.this$0 = $receiver;
                    this.$firstInHistory = $firstInHistory;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            TscnScenePreviewWindow.access$setFile(this.this$0, (VirtualFile)this.$firstInHistory.first);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void setFile(VirtualFile file) {
        if (Intrinsics.areEqual((Object)file, (Object)this.myFile)) {
            return;
        }
        this.myFile = file;
        this.scheduleRebuild();
    }

    private final void rebuildImpl() {
        ToolWindowManager.Companion.getInstance(this.project).invokeLater(() -> TscnScenePreviewWindow.rebuildImpl$lambda$0(this));
    }

    private final JPanel createContentPanel(JComponent component) {
        JPanel panel = new JPanel();
        panel.setBackground(UIUtil.getTreeBackground());
        panel.add(component);
        return panel;
    }

    private static final void runScheduler$lambda$0(JComponent $component, TscnScenePreviewWindow this$0, ActionEvent actionEvent) {
        if (!$component.isShowing()) {
            return;
        }
        int count = ActivityTracker.getInstance().getCount();
        if (count == this$0.activityCount) {
            return;
        }
        ModalityState modalityState = ModalityState.stateForComponent((Component)$component);
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
        ModalityState state = modalityState;
        if (ModalityState.current().dominates(state)) {
            return;
        }
        boolean success = this$0.runTask(() -> TscnScenePreviewWindow.runScheduler$lambda$0$0(this$0));
        if (success) {
            this$0.activityCount = count;
        }
    }

    private static final void runScheduler$lambda$0$0(TscnScenePreviewWindow this$0) {
        this$0.checkUpdate();
    }

    private static final void runScheduler$lambda$1(Timer $timer) {
        $timer.stop();
    }

    private static final void runScheduler$lambda$2(TscnScenePreviewWindow this$0, HierarchyEvent e) {
        if (BitUtil.isSet((long)e.getChangeFlags(), (long)2L)) {
            boolean visible = this$0.toolWindow.isVisible();
            if (visible) {
                this$0.runTask(() -> TscnScenePreviewWindow.runScheduler$lambda$2$0(this$0));
                this$0.scheduleRebuild();
            } else if (!this$0.project.isDisposed()) {
                this$0.myFile = null;
                this$0.rebuildNow();
            }
        }
    }

    private static final void runScheduler$lambda$2$0(TscnScenePreviewWindow this$0) {
        this$0.checkUpdate();
    }

    private static final void runScheduler$lambda$3(TscnScenePreviewWindow this$0) {
        this$0.checkUpdate();
    }

    private static final void checkUpdate$lambda$0(TscnScenePreviewWindow this$0, DataContext $dataContext) {
        VirtualFile file = this$0.getVirtualFile($dataContext);
        BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(file, this$0, null){
            int label;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ TscnScenePreviewWindow this$0;
            {
                this.$file = $file;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (this.$file != null) {
                            TscnScenePreviewWindow.access$setFileFromSelectionHistory(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void rebuildImpl$lambda$0(TscnScenePreviewWindow this$0) {
        VirtualFile file;
        ContentManager contentManager = this$0.toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        contentManager2.removeAllContents(true);
        if (!this$0.isStructureViewShowing()) {
            return;
        }
        Object object = this$0.myFile;
        if (object == null) {
            TscnScenePreviewWindow $this$rebuildImpl_u24lambda_u240_u240 = this$0;
            boolean bl = false;
            VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)$this$rebuildImpl_u24lambda_u240_u240.project).getSelectedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
            VirtualFile[] selectedFiles = virtualFileArray;
            object = !(selectedFiles.length == 0) ? selectedFiles[0] : null;
        }
        if ((file = object) != null && file.isValid()) {
            this$0.myFile = file;
        }
        Object[] objectArray = new Object[]{this$0};
        ReadAction.nonBlocking(() -> TscnScenePreviewWindow.rebuildImpl$lambda$0$1(this$0, file)).coalesceBy(objectArray).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> TscnScenePreviewWindow.rebuildImpl$lambda$0$3(arg_0 -> TscnScenePreviewWindow.rebuildImpl$lambda$0$2(this$0, contentManager2, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static final JComponent rebuildImpl$lambda$0$1(TscnScenePreviewWindow this$0, VirtualFile $file) {
        return new TscnSceneTreeBuilder(this$0.project).build($file);
    }

    private static final Unit rebuildImpl$lambda$0$2(TscnScenePreviewWindow this$0, ContentManager $contentManager, JComponent it) {
        ContentFactory contentFactory = ContentFactory.getInstance();
        JComponent jComponent = it;
        if (jComponent == null) {
            jComponent = this$0.createContentPanel(new JLabel(GdScriptBundle.INSTANCE.message("no.scene", new Object[0])));
        }
        Content content = contentFactory.createContent(jComponent, null, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        $contentManager.addContent(content2);
        this$0.pendingRebuild.set(false);
        return Unit.INSTANCE;
    }

    private static final void rebuildImpl$lambda$0$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ MutableSharedFlow access$getRebuildRequests$p(TscnScenePreviewWindow $this) {
        return $this.rebuildRequests;
    }

    public static final /* synthetic */ void access$rebuildImpl(TscnScenePreviewWindow $this) {
        $this.rebuildImpl();
    }

    public static final /* synthetic */ VirtualFile access$getMyFile$p(TscnScenePreviewWindow $this) {
        return $this.myFile;
    }

    public static final /* synthetic */ void access$scheduleRebuild(TscnScenePreviewWindow $this) {
        $this.scheduleRebuild();
    }

    public static final /* synthetic */ void access$setFile(TscnScenePreviewWindow $this, VirtualFile file) {
        $this.setFile(file);
    }

    public static final /* synthetic */ void access$setFileFromSelectionHistory(TscnScenePreviewWindow $this) {
        $this.setFileFromSelectionHistory();
    }
}

