/*
 * Decompiled with CFR 0.152.
 */
package tscn.psi.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import gdscript.psi.utils.PsiGdResourceUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tscn.index.impl.TscnResourceIndex;
import tscn.index.stub.TscnResourceHeaderStub;
import tscn.psi.TscnHeaderValue;
import tscn.psi.TscnResourceHeader;
import tscn.psi.utils.TscnHeaderUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u0006\u001a\u00020\u000bJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Ltscn/psi/utils/TscnResourceUtil;", "", "<init>", "()V", "getId", "", "element", "Ltscn/psi/TscnResourceHeader;", "getPath", "getType", "findTscnByResource", "Lcom/intellij/psi/PsiElement;", "findTscnByResources", "", "resourcePath", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.godot.gdscript"})
public final class TscnResourceUtil {
    @NotNull
    public static final TscnResourceUtil INSTANCE = new TscnResourceUtil();

    private TscnResourceUtil() {
    }

    @NotNull
    public final String getId(@NotNull TscnResourceHeader element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TscnResourceHeaderStub stub = (TscnResourceHeaderStub)element.getStub();
        if (stub != null) {
            return stub.getId();
        }
        List<TscnHeaderValue> list = element.getHeaderValueList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHeaderValueList(...)");
        return TscnHeaderUtils.INSTANCE.getValue(list, TscnHeaderUtils.INSTANCE.getHL_ID());
    }

    @NotNull
    public final String getPath(@NotNull TscnResourceHeader element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TscnResourceHeaderStub stub = (TscnResourceHeaderStub)element.getStub();
        if (stub != null) {
            return stub.getPath();
        }
        List<TscnHeaderValue> list = element.getHeaderValueList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHeaderValueList(...)");
        return TscnHeaderUtils.INSTANCE.getValue(list, TscnHeaderUtils.INSTANCE.getHL_PATH());
    }

    @NotNull
    public final String getType(@NotNull TscnResourceHeader element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List<TscnHeaderValue> list = element.getHeaderValueList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHeaderValueList(...)");
        return TscnHeaderUtils.INSTANCE.getValue(list, TscnHeaderUtils.INSTANCE.getHL_TYPE());
    }

    @Deprecated(message="list list below - script might be in multiple .tscn")
    @Nullable
    public final TscnResourceHeader findTscnByResource(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VirtualFile virtualFile = element.getContainingFile().getOriginalFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        String resource = PsiGdResourceUtil.resourcePath$default(PsiGdResourceUtil.INSTANCE, virtualFile, false, 2, null);
        return (TscnResourceHeader)CollectionsKt.firstOrNull((Iterable)TscnResourceIndex.Companion.getINSTANCE().getGlobally(resource, element));
    }

    @NotNull
    public final Collection<TscnResourceHeader> findTscnByResources(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VirtualFile virtualFile = element.getContainingFile().getOriginalFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        String resource = PsiGdResourceUtil.resourcePath$default(PsiGdResourceUtil.INSTANCE, virtualFile, false, 2, null);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.findTscnByResources(resource, project);
    }

    @NotNull
    public final Collection<TscnResourceHeader> findTscnByResources(@NotNull String resourcePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return TscnResourceIndex.Companion.getINSTANCE().getGlobally(resourcePath, project);
    }
}

