/*
 * Decompiled with CFR 0.152.
 */
package tscn.psi.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tscn.index.impl.TscnNodeIndex;
import tscn.index.stub.TscnNodeHeaderStub;
import tscn.psi.TscnDataLine;
import tscn.psi.TscnHeaderValue;
import tscn.psi.TscnNodeHeader;
import tscn.psi.TscnParagraph;
import tscn.psi.TscnResourceHeader;
import tscn.psi.utils.TscnHeaderUtils;
import tscn.psi.utils.TscnResourceUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tJ\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tJ\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tH\u0007J\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\tJ\u0019\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u000e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\u0019\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010!\u001a\u00020\"\u00a2\u0006\u0002\u0010#J\u0019\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u000e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006'"}, d2={"Ltscn/psi/utils/TscnNodeUtil;", "", "<init>", "()V", "META_PREFIX", "", "getMETA_PREFIX", "()Ljava/lang/String;", "findNode", "Ltscn/psi/TscnNodeHeader;", "nodeHeaders", "Lkotlin/sequences/Sequence;", "nodeName", "getName", "element", "getType", "getParentPath", "getGroups", "", "(Ltscn/psi/TscnNodeHeader;)[Ljava/lang/String;", "getInstanceResource", "getIndex", "", "isUniqueNameOwner", "", "isVisible", "getScriptResource", "getNodePath", "getDirectParentPath", "hasScript", "listAllGroups", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Ljava/lang/String;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)[Ljava/lang/String;", "listAllMetas", "parseResourceId", "resource", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nTscnNodeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TscnNodeUtil.kt\ntscn/psi/utils/TscnNodeUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1563#2:183\n1634#2,3:184\n1374#2:190\n1460#2,5:191\n1617#2,9:198\n1869#2:207\n1870#2:209\n1626#2:210\n37#3,2:187\n37#3,2:196\n37#3,2:211\n1#4:189\n1#4:208\n*S KotlinDebug\n*F\n+ 1 TscnNodeUtil.kt\ntscn/psi/utils/TscnNodeUtil\n*L\n66#1:183\n66#1:184,3\n159#1:190\n159#1:191,5\n170#1:198,9\n170#1:207\n170#1:209\n170#1:210\n67#1:187,2\n161#1:196,2\n174#1:211,2\n170#1:208\n*E\n"})
public final class TscnNodeUtil {
    @NotNull
    public static final TscnNodeUtil INSTANCE = new TscnNodeUtil();
    @NotNull
    private static final String META_PREFIX = "metadata/";

    private TscnNodeUtil() {
    }

    @NotNull
    public final String getMETA_PREFIX() {
        return META_PREFIX;
    }

    @Nullable
    public final TscnNodeHeader findNode(@NotNull Sequence<? extends TscnNodeHeader> nodeHeaders, @NotNull String nodeName) {
        Intrinsics.checkNotNullParameter(nodeHeaders, (String)"nodeHeaders");
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        for (TscnNodeHeader nodeHeader : nodeHeaders) {
            String string = nodeHeader.getParentPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
            if (((CharSequence)string).length() == 0 && Intrinsics.areEqual((Object)nodeName, (Object)".")) {
                return nodeHeader;
            }
            if (Intrinsics.areEqual((Object)nodeHeader.getParentPath(), (Object)".") && Intrinsics.areEqual((Object)nodeHeader.getName(), (Object)nodeName)) {
                return nodeHeader;
            }
            if (!Intrinsics.areEqual((Object)(nodeHeader.getParentPath() + "/" + nodeHeader.getName()), (Object)nodeName)) continue;
            return nodeHeader;
        }
        return null;
    }

    @NotNull
    public final String getName(@NotNull TscnNodeHeader element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TscnNodeHeaderStub stub = (TscnNodeHeaderStub)element.getStub();
        if (stub != null) {
            return stub.getName();
        }
        List<TscnHeaderValue> list = element.getHeaderValueList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHeaderValueList(...)");
        return TscnHeaderUtils.INSTANCE.getValue(list, TscnHeaderUtils.INSTANCE.getHL_NAME());
    }

    @NotNull
    public final String getType(@NotNull TscnNodeHeader element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TscnNodeHeaderStub stub = (TscnNodeHeaderStub)element.getStub();
        if (stub != null) {
            return stub.getType();
        }
        List<TscnHeaderValue> list = element.getHeaderValueList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHeaderValueList(...)");
        return TscnHeaderUtils.INSTANCE.getValue(list, TscnHeaderUtils.INSTANCE.getHL_TYPE());
    }

    @NotNull
    public final String getParentPath(@NotNull TscnNodeHeader element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TscnNodeHeaderStub stub = (TscnNodeHeaderStub)element.getStub();
        if (stub != null) {
            return stub.getParentPath();
        }
        List<TscnHeaderValue> list = element.getHeaderValueList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHeaderValueList(...)");
        return TscnHeaderUtils.INSTANCE.getValue(list, TscnHeaderUtils.INSTANCE.getHL_PARENT());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] getGroups(@NotNull TscnNodeHeader element) {
        void $this$mapTo$iv$iv;
        TscnNodeHeaderStub stub;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TscnNodeHeaderStub tscnNodeHeaderStub = stub = (TscnNodeHeaderStub)element.getStub();
        if (tscnNodeHeaderStub != null) {
            return tscnNodeHeaderStub.getGroups();
        }
        List<TscnHeaderValue> list = element.getHeaderValueList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHeaderValueList(...)");
        Object[] objectArray = new char[]{'[', ']'};
        CharSequence charSequence = StringsKt.trim((String)TscnHeaderUtils.INSTANCE.getValue(list, TscnHeaderUtils.INSTANCE.getHL_GROUPS()), (char[])objectArray);
        objectArray = new String[1];
        objectArray[0] = (char)",";
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)charSequence, (String[])objectArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            char[] cArray = new char[]{' ', '\"'};
            collection.add(StringsKt.trim((String)it, (char[])cArray));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @NotNull
    public final String getInstanceResource(@NotNull TscnNodeHeader element) {
        Object object;
        Object v3;
        block4: {
            TscnNodeHeaderStub stub;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            TscnNodeHeaderStub tscnNodeHeaderStub = stub = (TscnNodeHeaderStub)element.getStub();
            if (tscnNodeHeaderStub != null) {
                return tscnNodeHeaderStub.getScriptResource();
            }
            String id = null;
            List<TscnHeaderValue> list = element.getHeaderValueList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getHeaderValueList(...)");
            id = TscnHeaderUtils.INSTANCE.getValue(list, TscnHeaderUtils.INSTANCE.getHL_INSTANCE());
            if (StringsKt.isBlank((CharSequence)id)) {
                return "";
            }
            id = this.parseResourceId(id);
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)element.getContainingFile()), TscnResourceHeader.class);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
            Collection resources = collection;
            Iterable iterable = resources;
            for (Object t : iterable) {
                TscnResourceHeader it = (TscnResourceHeader)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v3 = t;
                break block4;
            }
            v3 = null;
        }
        if ((object = (TscnResourceHeader)v3) == null || (object = object.getPath()) == null) {
            object = "";
        }
        return object;
    }

    public final int getIndex(@NotNull TscnNodeHeader element) {
        TscnNodeHeaderStub stub;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TscnNodeHeaderStub tscnNodeHeaderStub = stub = (TscnNodeHeaderStub)element.getStub();
        if (tscnNodeHeaderStub != null) {
            return tscnNodeHeaderStub.getIndex();
        }
        List<TscnHeaderValue> list = element.getHeaderValueList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHeaderValueList(...)");
        String index = TscnHeaderUtils.INSTANCE.getValue(list, TscnHeaderUtils.INSTANCE.getHL_INDEX());
        if (StringsKt.isBlank((CharSequence)index)) {
            return -1;
        }
        Integer n = StringsKt.toIntOrNull((String)index);
        return n != null ? n : -1;
    }

    public final boolean isUniqueNameOwner(@NotNull TscnNodeHeader element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TscnNodeHeaderStub stub = (TscnNodeHeaderStub)element.getStub();
        if (stub != null) {
            return stub.isUniqueNameOwner();
        }
        PsiElement psiElement = element.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type tscn.psi.TscnParagraph");
        return Intrinsics.areEqual((Object)TscnHeaderUtils.INSTANCE.getDataValue((TscnParagraph)psiElement, TscnHeaderUtils.INSTANCE.getDL_UNIQUE()), (Object)"true");
    }

    public final boolean isVisible(@NotNull TscnNodeHeader element) {
        TscnNodeHeaderStub stub;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TscnNodeHeaderStub tscnNodeHeaderStub = stub = (TscnNodeHeaderStub)element.getStub();
        if (tscnNodeHeaderStub != null) {
            return tscnNodeHeaderStub.isVisible();
        }
        PsiElement psiElement = element.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type tscn.psi.TscnParagraph");
        return !Intrinsics.areEqual((Object)TscnHeaderUtils.INSTANCE.getDataValue((TscnParagraph)psiElement, TscnHeaderUtils.INSTANCE.getDL_VISIBLE()), (Object)"false");
    }

    @NotNull
    public final String getScriptResource(@NotNull TscnNodeHeader element) {
        Object object;
        Object v3;
        block4: {
            TscnNodeHeaderStub stub;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            TscnNodeHeaderStub tscnNodeHeaderStub = stub = (TscnNodeHeaderStub)element.getStub();
            if (tscnNodeHeaderStub != null) {
                return tscnNodeHeaderStub.getScriptResource();
            }
            String id = null;
            PsiElement psiElement = element.getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type tscn.psi.TscnParagraph");
            id = TscnHeaderUtils.INSTANCE.getDataValue((TscnParagraph)psiElement, TscnHeaderUtils.INSTANCE.getDL_SCRIPT());
            if (StringsKt.isBlank((CharSequence)id)) {
                return "";
            }
            id = this.parseResourceId(id);
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)element.getContainingFile()), TscnResourceHeader.class);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
            Collection scripts = collection;
            Iterable iterable = scripts;
            for (Object t : iterable) {
                TscnResourceHeader it = (TscnResourceHeader)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v3 = t;
                break block4;
            }
            v3 = null;
        }
        if ((object = (TscnResourceHeader)v3) == null || (object = object.getPath()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getNodePath(@NotNull TscnNodeHeader element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TscnNodeHeaderStub stub = (TscnNodeHeaderStub)element.getStub();
        if (stub != null) {
            return stub.getNodePath();
        }
        String string = element.getParentPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
        String parentPath = string;
        return Intrinsics.areEqual((Object)parentPath, (Object)"") ? ".." : (Intrinsics.areEqual((Object)parentPath, (Object)".") ? "../" + element.getName() : "../" + parentPath + "/" + element.getName());
    }

    @Deprecated(message="is it needed after Node rework?")
    @NotNull
    public final String getDirectParentPath(@NotNull TscnNodeHeader element) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getParentPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
        String parentPath = string;
        if (Intrinsics.areEqual((Object)parentPath, (Object)"")) {
            object = ".";
        } else if (Intrinsics.areEqual((Object)parentPath, (Object)".")) {
            String string2 = element.getName();
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        } else {
            object = parentPath + "/" + element.getName();
        }
        return object;
    }

    public final boolean hasScript(@NotNull TscnNodeHeader element) {
        TscnNodeHeaderStub stub;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TscnNodeHeaderStub tscnNodeHeaderStub = stub = (TscnNodeHeaderStub)element.getStub();
        if (tscnNodeHeaderStub != null) {
            return tscnNodeHeaderStub.hasScript();
        }
        return !StringsKt.isBlank((CharSequence)this.getScriptResource(element));
    }

    @NotNull
    public final String[] listAllGroups(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.listAllGroups(project);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] listAllGroups(@NotNull Project project) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$flatMap$iv = TscnNodeIndex.Companion.getINSTANCE().getAllValues(project);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TscnNodeHeader it = (TscnNodeHeader)element$iv$iv;
            boolean bl = false;
            String[] stringArray = it.getGroups();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getGroups(...)");
            Iterable list$iv$iv = ArraysKt.toList((Object[])stringArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] listAllMetas(@NotNull PsiElement element) {
        void $this$toTypedArray$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TscnResourceHeader tscnResourceHeader = TscnResourceUtil.INSTANCE.findTscnByResource(element);
        if (tscnResourceHeader == null) {
            return new String[0];
        }
        TscnResourceHeader tscnFile = tscnResourceHeader;
        TscnNodeHeader tscnNodeHeader = (TscnNodeHeader)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tscnFile.getContainingFile()), TscnNodeHeader.class);
        if (tscnNodeHeader == null) {
            return new String[0];
        }
        TscnNodeHeader node = tscnNodeHeader;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)node.getParent(), TscnDataLine.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        List datas = list;
        Iterable $this$mapNotNull$iv = datas;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TscnDataLine it = (TscnDataLine)element$iv$iv;
            boolean bl2 = false;
            String name = it.getDataLineHeader().getText();
            Intrinsics.checkNotNull((Object)name);
            if (StringsKt.startsWith$default((String)name, (String)META_PREFIX, (boolean)false, (int)2, null)) {
                String string2 = name.substring(META_PREFIX.length());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private final String parseResourceId(String resource) {
        char[] cArray = new char[]{'\"', ' '};
        return StringsKt.trim((String)StringsKt.removeSuffix((String)((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)resource, (CharSequence)"ExtResource("))).toString(), (CharSequence)")"), (char[])cArray);
    }
}

