/*
 * Decompiled with CFR 0.152.
 */
package tscn.psi.search;

import com.intellij.model.PsiElementUsageInfo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.usageView.UsageInfo;
import gdscript.utils.ProjectUtil;
import gdscript.utils.VirtualFileUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import tscn.TscnFileType;
import tscn.psi.TscnResourceHeader;
import tscn.psi.search.processor.TscnResourceHeaderCollectingProcessor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ltscn/psi/search/TscnResourceSearcher;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "searchHelper", "Lcom/intellij/psi/search/PsiSearchHelper;", "Lorg/jetbrains/annotations/NotNull;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "listReference", "", "Lcom/intellij/usageView/UsageInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nTscnResourceSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TscnResourceSearcher.kt\ntscn/psi/search/TscnResourceSearcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1869#2,2:41\n*S KotlinDebug\n*F\n+ 1 TscnResourceSearcher.kt\ntscn/psi/search/TscnResourceSearcher\n*L\n28#1:41,2\n*E\n"})
public final class TscnResourceSearcher {
    @NotNull
    private final PsiSearchHelper searchHelper;
    @NotNull
    private final SearchScope searchScope;

    public TscnResourceSearcher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiSearchHelper, (String)"getInstance(...)");
        this.searchHelper = psiSearchHelper;
        FileType[] fileTypeArray = new FileType[]{TscnFileType.INSTANCE};
        SearchScope searchScope = PsiSearchScopeUtil.restrictScopeTo((SearchScope)((SearchScope)ProjectUtil.INSTANCE.contentScope(project)), (FileType[])fileTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"restrictScopeTo(...)");
        this.searchScope = searchScope;
    }

    @NotNull
    public final List<UsageInfo> listReference(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String searchFor = "path=\"" + VirtualFileUtil.resourcePath$default(VirtualFileUtil.INSTANCE, file, false, 1, null) + "\"";
        TscnResourceHeaderCollectingProcessor processor = new TscnResourceHeaderCollectingProcessor();
        this.searchHelper.processElementsWithWord((TextOccurenceProcessor)processor, this.searchScope, searchFor, (short)1, true);
        Set checked = new LinkedHashSet();
        List result = new ArrayList();
        Iterable $this$forEach$iv = processor.getResult();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TscnResourceHeader it = (TscnResourceHeader)element$iv;
            boolean bl = false;
            VirtualFile virtualFile = it.getContainingFile().getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            String resource = VirtualFileUtil.resourcePath$default(VirtualFileUtil.INSTANCE, virtualFile, false, 1, null);
            if (!checked.contains(resource)) {
                result.add(new PsiElementUsageInfo((PsiElement)it));
            }
            checked.add(resource);
        }
        return result;
    }
}

