/*
 * Decompiled with CFR 0.152.
 */
package tscn.psi.search;

import com.intellij.model.PsiElementUsageInfo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.usageView.UsageInfo;
import gdscript.utils.ProjectUtil;
import gdscript.utils.VirtualFileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tscn.TscnFileType;
import tscn.psi.TscnConnectionHeader;
import tscn.psi.TscnDataLine;
import tscn.psi.TscnNodeHeader;
import tscn.psi.TscnParagraph;
import tscn.psi.TscnResourceHeader;
import tscn.psi.search.AbstractTscnSearcher$extractNodePaths$;
import tscn.psi.search.AbstractTscnSearcher$listConnectionReference$;
import tscn.psi.search.processor.TscnConnectionHeaderCollectingProcessor;
import tscn.psi.search.processor.TscnParagraphCollectingProcessor;
import tscn.psi.utils.TscnNodeUtil;
import tscn.psi.utils.TscnResourceUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J2\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00130\u001bH\u0004J&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0013H\u0004J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130 2\u0006\u0010!\u001a\u00020\u0005H\u0002J.\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00132\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00050\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ltscn/psi/search/AbstractTscnSearcher;", "", "project", "Lcom/intellij/openapi/project/Project;", "scriptFile", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "searchHelper", "Lcom/intellij/psi/search/PsiSearchHelper;", "Lorg/jetbrains/annotations/NotNull;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "linkedScenes", "", "kotlin.jvm.PlatformType", "sceneResources", "", "scriptResource", "listConnectionReference", "Lcom/intellij/usageView/UsageInfo;", "searchTerm", "earlyStop", "", "conSourceFn", "Lkotlin/Function1;", "Ltscn/psi/TscnConnectionHeader;", "listAnimationReference", "type", "extractNodePaths", "", "sceneFile", "matchInParagraph", "par", "Ltscn/psi/TscnParagraph;", "typeSuffix", "nodePaths", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nAbstractTscnSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTscnSearcher.kt\ntscn/psi/search/AbstractTscnSearcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,129:1\n1563#2:130\n1634#2,3:131\n1563#2:134\n1634#2,3:135\n1761#2,3:144\n223#3,2:138\n223#3,2:141\n477#4:140\n477#4:143\n*S KotlinDebug\n*F\n+ 1 AbstractTscnSearcher.kt\ntscn/psi/search/AbstractTscnSearcher\n*L\n29#1:130\n29#1:131,3\n30#1:134\n30#1:135,3\n111#1:144,3\n42#1:138,2\n79#1:141,2\n42#1:140\n79#1:143\n*E\n"})
public abstract class AbstractTscnSearcher {
    @NotNull
    private final Project project;
    @NotNull
    private final PsiSearchHelper searchHelper;
    @NotNull
    private final SearchScope searchScope;
    @NotNull
    private final List<PsiFile> linkedScenes;
    @NotNull
    private final List<String> sceneResources;
    @NotNull
    private final String scriptResource;

    public AbstractTscnSearcher(@NotNull Project project, @NotNull PsiFile scriptFile) {
        PsiFile it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        this.project = project;
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiSearchHelper, (String)"getInstance(...)");
        this.searchHelper = psiSearchHelper;
        FileType[] fileTypeArray = new FileType[]{TscnFileType.INSTANCE};
        SearchScope searchScope = PsiSearchScopeUtil.restrictScopeTo((SearchScope)((SearchScope)ProjectUtil.INSTANCE.contentScope(this.project)), (FileType[])fileTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"restrictScopeTo(...)");
        this.searchScope = searchScope;
        Iterable iterable = TscnResourceUtil.INSTANCE.findTscnByResources((PsiElement)scriptFile);
        AbstractTscnSearcher abstractTscnSearcher = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TscnResourceHeader tscnResourceHeader = (TscnResourceHeader)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getContainingFile());
        }
        abstractTscnSearcher.linkedScenes = (List)destination$iv$iv;
        $this$map$iv = this.linkedScenes;
        abstractTscnSearcher = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PsiFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = it.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            collection.add(VirtualFileUtil.resourcePath$default(VirtualFileUtil.INSTANCE, virtualFile, false, 1, null));
        }
        abstractTscnSearcher.sceneResources = (List)destination$iv$iv;
        VirtualFile virtualFile = scriptFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        this.scriptResource = VirtualFileUtil.resourcePath$default(VirtualFileUtil.INSTANCE, virtualFile, false, 1, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final List<UsageInfo> listConnectionReference(@NotNull String searchTerm, boolean earlyStop, @NotNull Function1<? super TscnConnectionHeader, String> conSourceFn) {
        Intrinsics.checkNotNullParameter((Object)searchTerm, (String)"searchTerm");
        Intrinsics.checkNotNullParameter(conSourceFn, (String)"conSourceFn");
        List result = new ArrayList();
        TscnConnectionHeaderCollectingProcessor processor = new TscnConnectionHeaderCollectingProcessor();
        this.searchHelper.processElementsWithWord((TextOccurenceProcessor)processor, this.searchScope, searchTerm, (short)1, true);
        for (TscnConnectionHeader con : processor.getResult()) {
            TscnNodeHeader node;
            PsiFile psiFile = con.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            PsiElement $this$descendantsOfType_u24default$iv = (PsiElement)psiFile;
            boolean childrenFirst$iv = false;
            boolean $i$f$descendantsOfType = false;
            Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.descendants$default((PsiElement)$this$descendantsOfType_u24default$iv, (boolean)childrenFirst$iv, null, (int)2, null);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)listConnectionReference$$inlined$descendantsOfType$default$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            if (TscnNodeUtil.INSTANCE.findNode((Sequence<? extends TscnNodeHeader>)sequence, (String)conSourceFn.invoke((Object)con)) == null || !this.sceneResources.contains(node.getInstanceResource()) && !Intrinsics.areEqual((Object)this.scriptResource, (Object)node.getScriptResource())) continue;
            result.add(new PsiElementUsageInfo((PsiElement)con));
            if (!earlyStop) continue;
            return result;
        }
        return result;
    }

    @NotNull
    protected final List<UsageInfo> listAnimationReference(@NotNull String searchTerm, boolean earlyStop, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)searchTerm, (String)"searchTerm");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List result = new ArrayList();
        TscnParagraphCollectingProcessor processor = new TscnParagraphCollectingProcessor("Animation");
        this.searchHelper.processElementsWithWord((TextOccurenceProcessor)processor, this.searchScope, searchTerm, (short)1, true);
        String typeSuffix = "/type = \"" + type + "\"";
        for (TscnParagraph par : processor.getResult()) {
            PsiFile psiFile = par.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            List<String> nodePaths = this.extractNodePaths(psiFile);
            if (nodePaths.isEmpty() || !this.matchInParagraph(par, searchTerm, typeSuffix, nodePaths)) continue;
            result.add(new PsiElementUsageInfo((PsiElement)par));
            if (!earlyStop) continue;
            return result;
        }
        return result;
    }

    private final List<String> extractNodePaths(PsiFile sceneFile) {
        List nodePaths = new ArrayList();
        PsiElement $this$descendantsOfType_u24default$iv = (PsiElement)sceneFile;
        boolean childrenFirst$iv = false;
        boolean $i$f$descendantsOfType = false;
        Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.descendants$default((PsiElement)$this$descendantsOfType_u24default$iv, (boolean)childrenFirst$iv, null, (int)2, null);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)extractNodePaths$$inlined$descendantsOfType$default$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        for (TscnNodeHeader node : sequence) {
            if (!this.sceneResources.contains(node.getInstanceResource()) && !Intrinsics.areEqual((Object)this.scriptResource, (Object)node.getScriptResource())) continue;
            String string = node.getParentPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
            boolean bl = ((CharSequence)string).length() == 0 ? nodePaths.add("/path = NodePath(\".\")") : (Intrinsics.areEqual((Object)node.getParentPath(), (Object)".") ? nodePaths.add("/path = NodePath(\"" + node.getName() + "\")") : nodePaths.add("/path = NodePath(\"" + node.getParentPath() + "/" + node.getName() + "\")"));
        }
        return nodePaths;
    }

    private final boolean matchInParagraph(TscnParagraph par, String searchTerm, String typeSuffix, List<String> nodePaths) {
        String activeTrack = null;
        boolean possibleMatch = false;
        for (TscnDataLine line : PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)par, TscnDataLine.class)) {
            int typeIdx;
            String lineText;
            if (line.getText() == null) continue;
            if (activeTrack != null && StringsKt.startsWith$default((String)lineText, activeTrack, (boolean)false, (int)2, null)) {
                if (possibleMatch && StringsKt.startsWith$default((String)lineText, (String)(activeTrack + "/keys"), (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)lineText, (CharSequence)searchTerm, (boolean)false, (int)2, null)) {
                    return true;
                }
                if (StringsKt.startsWith$default((String)lineText, (String)(activeTrack + "/path"), (boolean)false, (int)2, null)) {
                    boolean bl;
                    block8: {
                        Iterable $this$any$iv = nodePaths;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String suffix = (String)element$iv;
                                boolean bl2 = false;
                                if (!StringsKt.contains$default((CharSequence)lineText, (CharSequence)suffix, (boolean)false, (int)2, null)) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    possibleMatch = bl;
                }
            } else {
                activeTrack = null;
            }
            if ((typeIdx = StringsKt.indexOf$default((CharSequence)lineText, (String)typeSuffix, (int)0, (boolean)false, (int)6, null)) == -1) continue;
            Intrinsics.checkNotNullExpressionValue((Object)lineText.substring(0, typeIdx), (String)"substring(...)");
            possibleMatch = false;
        }
        return false;
    }
}

