/*
 * Decompiled with CFR 0.152.
 */
package project.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import project.psi.ProjectElementType;
import project.psi.ProjectTokenType;
import project.psi.impl.ProjectDataElementType;
import project.psi.impl.ProjectDataImpl;
import project.psi.impl.ProjectDataKeyImpl;
import project.psi.impl.ProjectDataValueImpl;
import project.psi.impl.ProjectSectionElementType;
import project.psi.impl.ProjectSectionImpl;
import project.psi.impl.ProjectSectionNmImpl;

public interface ProjectTypes {
    public static final IElementType DATA = ProjectDataElementType.getInstance("DATA");
    public static final IElementType DATA_KEY = new ProjectElementType("DATA_KEY");
    public static final IElementType DATA_VALUE = new ProjectElementType("DATA_VALUE");
    public static final IElementType SECTION = ProjectSectionElementType.getInstance("SECTION");
    public static final IElementType SECTION_NM = new ProjectElementType("SECTION_NM");
    public static final IElementType BAD_CHARACTER = new ProjectTokenType("bad_character");
    public static final IElementType COMMENT = new ProjectTokenType("comment");
    public static final IElementType EQ = new ProjectTokenType("EQ");
    public static final IElementType KEY = new ProjectTokenType("KEY");
    public static final IElementType SECTION_KEY = new ProjectTokenType("SECTION_KEY");
    public static final IElementType VALUE = new ProjectTokenType("VALUE");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == DATA) {
                return new ProjectDataImpl(node);
            }
            if (type == DATA_KEY) {
                return new ProjectDataKeyImpl(node);
            }
            if (type == DATA_VALUE) {
                return new ProjectDataValueImpl(node);
            }
            if (type == SECTION) {
                return new ProjectSectionImpl(node);
            }
            if (type == SECTION_NM) {
                return new ProjectSectionNmImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

