/*
 * Decompiled with CFR 0.152.
 */
package gdscript.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import gdscript.utils.VirtualFileUtil;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006J\u001a\u0010\u0007\u001a\u00020\b*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lgdscript/utils/PsiFileUtil;", "", "<init>", "()V", "isInSdk", "", "Lcom/intellij/psi/PsiFile;", "toAbsoluteResource", "", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nPsiFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiFileUtil.kt\ngdscript/utils/PsiFileUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,47:1\n23#2:48\n*S KotlinDebug\n*F\n+ 1 PsiFileUtil.kt\ngdscript/utils/PsiFileUtil\n*L\n36#1:48\n*E\n"})
public final class PsiFileUtil {
    @NotNull
    public static final PsiFileUtil INSTANCE = new PsiFileUtil();

    private PsiFileUtil() {
    }

    public final boolean isInSdk(@NotNull PsiFile $this$isInSdk) {
        Intrinsics.checkNotNullParameter((Object)$this$isInSdk, (String)"<this>");
        return ProjectFileIndex.getInstance((Project)$this$isInSdk.getProject()).isInLibrary($this$isInSdk.getVirtualFile());
    }

    @NotNull
    public final String toAbsoluteResource(@NotNull String $this$toAbsoluteResource, @NotNull PsiElement element, @NotNull Project project) {
        Object v5;
        Object object;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$toAbsoluteResource, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (StringsKt.startsWith$default((String)$this$toAbsoluteResource, (String)"res://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$toAbsoluteResource, (String)"\"res://", (boolean)false, (int)2, null)) {
                return $this$toAbsoluteResource;
            }
            object = new char[]{'\"'};
            Path path = NioPathUtil.toNioPathOrNull((String)StringsKt.trim((String)$this$toAbsoluteResource, (char[])object));
            if (path == null || (path = path.normalize()) == null) {
                return $this$toAbsoluteResource;
            }
            Path thisPath = path;
            VirtualFile virtualFile = element.getContainingFile().getOriginalFile().getVirtualFile().getParent();
            if (virtualFile == null) {
                return $this$toAbsoluteResource;
            }
            VirtualFile dirPath = virtualFile;
            Collection collection = FilenameIndex.getVirtualFilesByName((String)PathsKt.getName((Path)thisPath), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                boolean bl;
                VirtualFile it = (VirtualFile)t;
                boolean bl2 = false;
                try {
                    Path relative = dirPath.toNioPath().relativize(it.toNioPath());
                    bl = Intrinsics.areEqual((Object)relative, (Object)thisPath);
                }
                catch (Exception e) {
                    String $this$thisLogger$iv = $this$toAbsoluteResource;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(String.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.trace((Throwable)e);
                    bl = false;
                }
                if (!bl) continue;
                v5 = t;
                break block7;
            }
            v5 = null;
        }
        object = v5;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            return VirtualFileUtil.resourcePath$default(VirtualFileUtil.INSTANCE, (VirtualFile)it, false, 1, null);
        }
        return $this$toAbsoluteResource;
    }
}

