/*
 * Decompiled with CFR 0.152.
 */
package gdscript.utils;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import gdscript.psi.GdArgList;
import gdscript.psi.GdCallEx;
import gdscript.psi.GdTypes;
import gdscript.utils.ElementTypeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import project.psi.model.GdAutoload;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\tJ\u0011\u0010\f\u001a\u0004\u0018\u00010\t*\u00020\n\u00a2\u0006\u0002\u0010\rJ\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\nJ\f\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\nJ\f\u0010\u0011\u001a\u0004\u0018\u00010\n*\u00020\nJ%\u0010\u0012\u001a\u0004\u0018\u00010\n*\u00020\n2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0014\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0015J\f\u0010\u0016\u001a\u0004\u0018\u00010\n*\u00020\nJ\n\u0010\u0017\u001a\u00020\n*\u00020\u0001R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgdscript/utils/PsiElementUtil;", "", "<init>", "()V", "SKIPS_TO_COMMENT", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "precedingNewLines", "", "Lcom/intellij/psi/PsiElement;", "position", "getCaretOffsetIfSingle", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Integer;", "getCallExpr", "Lgdscript/psi/GdCallEx;", "getCallExprOfParam", "nextNonWhiteCommentToken", "prevNonWhiteCommentToken", "skip", "", "(Lcom/intellij/psi/PsiElement;[Lcom/intellij/psi/tree/IElementType;)Lcom/intellij/psi/PsiElement;", "prevCommentBlock", "psi", "intellij.rider.plugins.godot.gdscript"})
public final class PsiElementUtil {
    @NotNull
    public static final PsiElementUtil INSTANCE = new PsiElementUtil();
    @NotNull
    private static final List<IElementType> SKIPS_TO_COMMENT;

    private PsiElementUtil() {
    }

    public final int precedingNewLines(@NotNull PsiElement $this$precedingNewLines, int position) {
        Intrinsics.checkNotNullParameter((Object)$this$precedingNewLines, (String)"<this>");
        PsiElement psiElement = $this$precedingNewLines.getParent();
        if (psiElement == null) {
            return 0;
        }
        PsiElement parent = psiElement;
        String string = parent.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() == 0) {
            return 0;
        }
        String string2 = parent.getContainingFile().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String string3 = string2;
        int n = 0;
        String string4 = string3.substring(n, position);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String partial = string4;
        int c = 0;
        char[] cArray = partial.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        List list = ArraysKt.reversed((char[])cArray);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            char ch = ((Character)list.get(i)).charValue();
            if (ch == '\n') {
                ++c;
                continue;
            }
            if (ch != ' ' && ch != '\t') break;
        }
        return c;
    }

    @Nullable
    public final Integer getCaretOffsetIfSingle(@NotNull PsiElement $this$getCaretOffsetIfSingle) {
        Intrinsics.checkNotNullParameter((Object)$this$getCaretOffsetIfSingle, (String)"<this>");
        Editor editor = PsiEditorUtil.findEditor((PsiElement)$this$getCaretOffsetIfSingle);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        if (editor2.getCaretModel().getCaretCount() != 1) {
            return null;
        }
        return editor2.getCaretModel().getCurrentCaret().getOffset();
    }

    @Nullable
    public final GdCallEx getCallExpr(@NotNull PsiElement $this$getCallExpr) {
        Intrinsics.checkNotNullParameter((Object)$this$getCallExpr, (String)"<this>");
        PsiElement psiElement = PsiTreeUtil.nextVisibleLeaf((PsiElement)$this$getCallExpr);
        if (psiElement == null) {
            return null;
        }
        PsiElement next = psiElement;
        if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)next), (Object)GdTypes.LRBR)) {
            PsiElement psiElement2 = next.getParent();
            if (Intrinsics.areEqual((Object)(psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null), (Object)GdTypes.CALL_EX)) {
                PsiElement psiElement3 = next.getParent();
                Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type gdscript.psi.GdCallEx");
                return (GdCallEx)psiElement3;
            }
        }
        return null;
    }

    @Nullable
    public final GdCallEx getCallExprOfParam(@NotNull PsiElement $this$getCallExprOfParam) {
        Intrinsics.checkNotNullParameter((Object)$this$getCallExprOfParam, (String)"<this>");
        GdArgList gdArgList = (GdArgList)PsiTreeUtil.getParentOfType((PsiElement)$this$getCallExprOfParam, GdArgList.class);
        if (gdArgList == null) {
            return null;
        }
        GdArgList argList = gdArgList;
        if (argList.getParent() instanceof GdCallEx) {
            PsiElement psiElement = argList.getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type gdscript.psi.GdCallEx");
            return (GdCallEx)psiElement;
        }
        return null;
    }

    @Nullable
    public final PsiElement nextNonWhiteCommentToken(@NotNull PsiElement $this$nextNonWhiteCommentToken) {
        PsiElement next;
        Intrinsics.checkNotNullParameter((Object)$this$nextNonWhiteCommentToken, (String)"<this>");
        for (next = $this$nextNonWhiteCommentToken.getNextSibling(); next != null && ElementTypeUtil.INSTANCE.isSkipable(PsiTreeUtilKt.getElementType((PsiElement)next)); next = next.getNextSibling()) {
        }
        return next;
    }

    @Nullable
    public final PsiElement prevNonWhiteCommentToken(@NotNull PsiElement $this$prevNonWhiteCommentToken, IElementType ... skip) {
        PsiElement prev;
        Intrinsics.checkNotNullParameter((Object)$this$prevNonWhiteCommentToken, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)skip, (String)"skip");
        for (prev = $this$prevNonWhiteCommentToken.getPrevSibling(); prev != null && (ElementTypeUtil.INSTANCE.isSkipable(PsiTreeUtilKt.getElementType((PsiElement)prev)) || ArraysKt.contains((Object[])skip, (Object)PsiTreeUtilKt.getElementType((PsiElement)prev))); prev = prev.getPrevSibling()) {
        }
        return prev;
    }

    @Nullable
    public final PsiElement prevCommentBlock(@NotNull PsiElement $this$prevCommentBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$prevCommentBlock, (String)"<this>");
        PsiElement prev = PsiTreeUtilKt.prevLeaf$default((PsiElement)$this$prevCommentBlock, (boolean)false, (int)1, null);
        while (true) {
            PsiElement psiElement = prev;
            if (!SKIPS_TO_COMMENT.contains(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null)) break;
            PsiElement psiElement2 = prev;
            Intrinsics.checkNotNull((Object)psiElement2);
            if (Intrinsics.areEqual((Object)psiElement2.getText(), (Object)"\n")) {
                prev = PsiTreeUtilKt.prevLeaf$default((PsiElement)prev, (boolean)false, (int)1, null);
                break;
            }
            prev = PsiTreeUtilKt.prevLeaf$default((PsiElement)prev, (boolean)false, (int)1, null);
        }
        PsiElement psiElement = prev;
        if (Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)GdTypes.COMMENT)) {
            return prev;
        }
        return null;
    }

    @NotNull
    public final PsiElement psi(@NotNull Object $this$psi) {
        Intrinsics.checkNotNullParameter((Object)$this$psi, (String)"<this>");
        return $this$psi instanceof GdAutoload ? (PsiElement)((GdAutoload)$this$psi).getElement() : (PsiElement)$this$psi;
    }

    static {
        Object[] objectArray = new IElementType[]{TokenType.WHITE_SPACE, GdTypes.INDENT, GdTypes.DEDENT};
        SKIPS_TO_COMMENT = CollectionsKt.listOf((Object[])objectArray);
    }
}

