/*
 * Decompiled with CFR 0.152.
 */
package gdscript.utils;

import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.suggested.UtilsKt;
import com.jetbrains.rider.godot.community.gdscript.GdFileType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0010"}, d2={"Lgdscript/utils/GdSettingsUtil;", "", "<init>", "()V", "indentToSpaces", "Lcom/intellij/formatting/Indent;", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "indent", "", "offset", "", "absolute", "", "calculateSpaceIndents", "element", "Lcom/intellij/psi/PsiElement;", "intellij.rider.plugins.godot.gdscript"})
public final class GdSettingsUtil {
    @NotNull
    public static final GdSettingsUtil INSTANCE = new GdSettingsUtil();

    private GdSettingsUtil() {
    }

    @NotNull
    public final Indent indentToSpaces(@NotNull CodeStyleSettings $this$indentToSpaces, @NotNull String indent, int offset, boolean absolute) {
        Intrinsics.checkNotNullParameter((Object)$this$indentToSpaces, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        char whiteSpace = StringsKt.first((CharSequence)indent);
        int tabSize = $this$indentToSpaces.getTabSize((FileType)GdFileType.INSTANCE);
        int baseSize = offset * tabSize;
        int size = 0;
        if (!CharsKt.isWhitespace((char)whiteSpace)) {
            Indent indent2 = Indent.getSpaceIndent((int)baseSize);
            Intrinsics.checkNotNullExpressionValue((Object)indent2, (String)"getSpaceIndent(...)");
            return indent2;
        }
        while (true) {
            Character c = StringsKt.getOrNull((CharSequence)indent, (int)size);
            char c2 = whiteSpace;
            if (c == null || c.charValue() != c2) break;
            ++size;
        }
        if (whiteSpace != ' ') {
            size *= tabSize;
        }
        if (absolute) {
            return (Indent)new IndentImpl(Indent.Type.SPACES, true, size + baseSize, false, false);
        }
        Indent indent3 = Indent.getSpaceIndent((int)Math.max(size + baseSize, 0));
        Intrinsics.checkNotNullExpressionValue((Object)indent3, (String)"getSpaceIndent(...)");
        return indent3;
    }

    public static /* synthetic */ Indent indentToSpaces$default(GdSettingsUtil gdSettingsUtil, CodeStyleSettings codeStyleSettings, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return gdSettingsUtil.indentToSpaces(codeStyleSettings, string, n, bl);
    }

    @NotNull
    public final Indent calculateSpaceIndents(@NotNull CodeStyleSettings $this$calculateSpaceIndents, @NotNull PsiElement element, int offset, boolean absolute) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateSpaceIndents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = PsiTreeUtil.getDeepestVisibleLast((PsiElement)element);
        if (psiElement == null) {
            psiElement = element;
        }
        PsiElement lastVisible = psiElement;
        Editor editor = PsiEditorUtil.findEditor((PsiElement)lastVisible);
        Intrinsics.checkNotNull((Object)editor);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int line = document2.getLineNumber(UtilsKt.getEndOffset((PsiElement)lastVisible));
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = document2.getLineStartOffset(line);
        int n2 = document2.getLineEndOffset(line);
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String indentedLine = string3;
        return this.indentToSpaces($this$calculateSpaceIndents, indentedLine, offset, absolute);
    }

    public static /* synthetic */ Indent calculateSpaceIndents$default(GdSettingsUtil gdSettingsUtil, CodeStyleSettings codeStyleSettings, PsiElement psiElement, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return gdSettingsUtil.calculateSpaceIndents(codeStyleSettings, psiElement, n, bl);
    }
}

