/*
 * Decompiled with CFR 0.152.
 */
package gdscript.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import gdscript.settings.GdProjectSettingsState;
import gdscript.settings.GdProjectState;
import gdscript.settings.GdSettingsComponent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgdscript/settings/GdSettingsConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "component", "Lgdscript/settings/GdSettingsComponent;", "getDisplayName", "", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "createComponent", "isModified", "", "apply", "", "reset", "disposeUIResources", "intellij.rider.plugins.godot.gdscript"})
public final class GdSettingsConfigurable
implements Configurable {
    @NotNull
    private final Project project;
    @Nullable
    private GdSettingsComponent component;

    public GdSettingsConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public String getDisplayName() {
        return "GdScript Settings";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        GdSettingsComponent gdSettingsComponent = this.component;
        return gdSettingsComponent != null ? gdSettingsComponent.preferredFocusedComponent() : null;
    }

    @Nullable
    public JComponent createComponent() {
        GdSettingsComponent gdSettingsComponent = this.component = new GdSettingsComponent(this.project);
        return gdSettingsComponent != null ? gdSettingsComponent.getPanel() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        GdProjectState settings = GdProjectSettingsState.Companion.getInstance(this.project).getState();
        GdSettingsComponent gdSettingsComponent = this.component;
        if (gdSettingsComponent == null) return true;
        if (gdSettingsComponent.getHidePrivate() != settings.getHidePrivate()) return true;
        boolean bl = true;
        if (!bl) return true;
        GdSettingsComponent gdSettingsComponent2 = this.component;
        if (gdSettingsComponent2 == null) return true;
        if (gdSettingsComponent2.getShortTyped() != settings.getShortTyped()) return true;
        boolean bl2 = true;
        if (!bl2) return true;
        GdSettingsComponent gdSettingsComponent3 = this.component;
        if (!Intrinsics.areEqual((Object)(gdSettingsComponent3 != null ? gdSettingsComponent3.getAnnotators() : null), (Object)settings.getAnnotators())) return true;
        GdSettingsComponent gdSettingsComponent4 = this.component;
        if (!Intrinsics.areEqual((Object)(gdSettingsComponent4 != null ? gdSettingsComponent4.getCriticals() : null), (Object)settings.getCriticals())) return true;
        GdSettingsComponent gdSettingsComponent5 = this.component;
        if (!Intrinsics.areEqual((Object)(gdSettingsComponent5 != null ? gdSettingsComponent5.getWarnings() : null), (Object)settings.getWarnings())) return true;
        GdSettingsComponent gdSettingsComponent6 = this.component;
        if (Intrinsics.areEqual((Object)(gdSettingsComponent6 != null ? gdSettingsComponent6.getNotes() : null), (Object)settings.getNotes())) return false;
        return true;
    }

    public void apply() {
        GdProjectState settings = GdProjectSettingsState.Companion.getInstance(this.project).getState();
        GdSettingsComponent gdSettingsComponent = this.component;
        settings.setHidePrivate(gdSettingsComponent != null ? gdSettingsComponent.getHidePrivate() : true);
        GdSettingsComponent gdSettingsComponent2 = this.component;
        settings.setShortTyped(gdSettingsComponent2 != null ? gdSettingsComponent2.getShortTyped() : false);
        Object object = this.component;
        if (object == null || (object = ((GdSettingsComponent)object).getAnnotators()) == null) {
            object = GdProjectState.Companion.getOFF();
        }
        settings.setAnnotators((String)object);
        Object object2 = this.component;
        if (object2 == null || (object2 = ((GdSettingsComponent)object2).getCriticals()) == null) {
            object2 = "ALERT,ATTENTION,CAUTION,CRITICAL,DANGER,SECURITY";
        }
        settings.setCriticals((String)object2);
        Object object3 = this.component;
        if (object3 == null || (object3 = ((GdSettingsComponent)object3).getWarnings()) == null) {
            object3 = "BUG,DEPRECATED,FIXME,HACK,TASK,TBD,TODO,WARNING";
        }
        settings.setWarnings((String)object3);
        Object object4 = this.component;
        if (object4 == null || (object4 = ((GdSettingsComponent)object4).getNotes()) == null) {
            object4 = "INFO,NOTE,NOTICE,TEST,TESTING";
        }
        settings.setNotes((String)object4);
    }

    public void reset() {
        block5: {
            GdProjectState settings = GdProjectSettingsState.Companion.getInstance(this.project).getState();
            GdSettingsComponent gdSettingsComponent = this.component;
            if (gdSettingsComponent != null) {
                gdSettingsComponent.setHidePrivate(settings.getHidePrivate());
            }
            GdSettingsComponent gdSettingsComponent2 = this.component;
            if (gdSettingsComponent2 != null) {
                gdSettingsComponent2.setShortTyped(settings.getShortTyped());
            }
            GdSettingsComponent gdSettingsComponent3 = this.component;
            if (gdSettingsComponent3 != null) {
                gdSettingsComponent3.setAnnotators(settings.getAnnotators());
            }
            GdSettingsComponent gdSettingsComponent4 = this.component;
            if (gdSettingsComponent4 != null) {
                gdSettingsComponent4.setCriticals(settings.getCriticals());
            }
            GdSettingsComponent gdSettingsComponent5 = this.component;
            if (gdSettingsComponent5 != null) {
                gdSettingsComponent5.setWarnings(settings.getWarnings());
            }
            GdSettingsComponent gdSettingsComponent6 = this.component;
            if (gdSettingsComponent6 == null) break block5;
            gdSettingsComponent6.setNotes(settings.getNotes());
        }
    }

    public void disposeUIResources() {
        this.component = null;
    }
}

