/*
 * Decompiled with CFR 0.152.
 */
package gdscript.settings;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import gdscript.settings.GdProjectState;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR$\u0010\"\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R$\u0010'\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R$\u0010*\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010$\"\u0004\b,\u0010&R$\u0010-\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010$\"\u0004\b/\u0010&\u00a8\u00060"}, d2={"Lgdscript/settings/GdSettingsComponent;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "hidePrivateCheck", "Lcom/intellij/ui/components/JBCheckBox;", "shortTypedCheck", "annotatorsCb", "Lcom/intellij/openapi/ui/ComboBox;", "", "criticalsTf", "Ljavax/swing/JTextField;", "warningsTf", "notesTf", "preferredFocusedComponent", "Ljavax/swing/JComponent;", "newStatus", "", "hidePrivate", "getHidePrivate", "()Z", "setHidePrivate", "(Z)V", "shortTyped", "getShortTyped", "setShortTyped", "annotators", "getAnnotators", "()Ljava/lang/String;", "setAnnotators", "(Ljava/lang/String;)V", "criticals", "getCriticals", "setCriticals", "warnings", "getWarnings", "setWarnings", "notes", "getNotes", "setNotes", "intellij.rider.plugins.godot.gdscript"})
public final class GdSettingsComponent {
    @NotNull
    private final Project project;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final JBCheckBox hidePrivateCheck;
    @NotNull
    private final JBCheckBox shortTypedCheck;
    @NotNull
    private final ComboBox<String> annotatorsCb;
    @NotNull
    private final JTextField criticalsTf;
    @NotNull
    private final JTextField warningsTf;
    @NotNull
    private final JTextField notesTf;

    public GdSettingsComponent(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.hidePrivateCheck = new JBCheckBox("Hide _private members from completion");
        this.shortTypedCheck = new JBCheckBox("Use short typing 'var a := 1' instead of 'var a: int = 1'");
        this.annotatorsCb = new ComboBox();
        this.criticalsTf = new JTextField();
        this.warningsTf = new JTextField();
        this.notesTf = new JTextField();
        this.annotatorsCb.addItem((Object)GdProjectState.Companion.getOFF());
        this.annotatorsCb.addItem((Object)GdProjectState.Companion.getWARN());
        this.annotatorsCb.addItem((Object)GdProjectState.Companion.getERR());
        this.annotatorsCb.setSelectedItem((Object)GdProjectState.Companion.getOFF());
        JPanel jPanel = FormBuilder.createFormBuilder().addComponent((JComponent)this.hidePrivateCheck, 1).addComponent((JComponent)this.shortTypedCheck, 1).addLabeledComponent("Reference, Node, Resource checks", (JComponent)this.annotatorsCb, 1).addLabeledComponent("Critical comments", (JComponent)this.criticalsTf, 1).addLabeledComponent("Warning comments", (JComponent)this.warningsTf, 1).addLabeledComponent("Note comments", (JComponent)this.notesTf, 1).addComponentFillVertically((JComponent)new JPanel(), 0).getPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getPanel(...)");
        this.panel = jPanel;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JPanel getPanel() {
        return this.panel;
    }

    @NotNull
    public final JComponent preferredFocusedComponent() {
        return (JComponent)this.hidePrivateCheck;
    }

    public final boolean getHidePrivate() {
        return this.hidePrivateCheck.isSelected();
    }

    public final void setHidePrivate(boolean newStatus) {
        this.hidePrivateCheck.setSelected(newStatus);
    }

    public final boolean getShortTyped() {
        return this.shortTypedCheck.isSelected();
    }

    public final void setShortTyped(boolean newStatus) {
        this.shortTypedCheck.setSelected(newStatus);
    }

    @NotNull
    public final String getAnnotators() {
        Object object = this.annotatorsCb.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    public final void setAnnotators(@NotNull String newStatus) {
        Intrinsics.checkNotNullParameter((Object)newStatus, (String)"newStatus");
        this.annotatorsCb.setSelectedItem((Object)newStatus);
    }

    @NotNull
    public final String getCriticals() {
        String string = this.criticalsTf.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public final void setCriticals(@NotNull String newStatus) {
        Intrinsics.checkNotNullParameter((Object)newStatus, (String)"newStatus");
        this.criticalsTf.setText(newStatus);
    }

    @NotNull
    public final String getWarnings() {
        String string = this.warningsTf.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public final void setWarnings(@NotNull String newStatus) {
        Intrinsics.checkNotNullParameter((Object)newStatus, (String)"newStatus");
        this.warningsTf.setText(newStatus);
    }

    @NotNull
    public final String getNotes() {
        String string = this.notesTf.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public final void setNotes(@NotNull String newStatus) {
        Intrinsics.checkNotNullParameter((Object)newStatus, (String)"newStatus");
        this.notesTf.setText(newStatus);
    }
}

