/*
 * Decompiled with CFR 0.152.
 */
package gdscript.run;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import gdscript.run.GdRunConfiguration;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class GdSettingsEditor
extends SettingsEditor<GdRunConfiguration> {
    private JPanel myPanel;
    private LabeledComponent<TextFieldWithBrowseButton> godotExe;
    private LabeledComponent<TextFieldWithBrowseButton> tscn;
    private LabeledComponent<JTextField> arguments;
    private JCheckBox debugShapes;
    private JCheckBox debugPaths;

    public GdSettingsEditor() {
        this.$$$setupUI$$$();
    }

    public void resetEditorFrom(GdRunConfiguration gdRunConfiguration) {
        ((TextFieldWithBrowseButton)this.godotExe.getComponent()).setText(gdRunConfiguration.getGodotExe());
        ((TextFieldWithBrowseButton)this.tscn.getComponent()).setText(gdRunConfiguration.getTscn());
        ((JTextField)this.arguments.getComponent()).setText(gdRunConfiguration.getArguments());
        this.debugShapes.setSelected(gdRunConfiguration.getDebugShapes());
        this.debugPaths.setSelected(gdRunConfiguration.getDebugPaths());
    }

    public void applyEditorTo(GdRunConfiguration gdRunConfiguration) {
        gdRunConfiguration.setGodotExe(((TextFieldWithBrowseButton)this.godotExe.getComponent()).getText());
        gdRunConfiguration.setTscn(((TextFieldWithBrowseButton)this.tscn.getComponent()).getText());
        gdRunConfiguration.setArguments(((JTextField)this.arguments.getComponent()).getText());
        gdRunConfiguration.setDebugShapes(this.debugShapes.isSelected());
        gdRunConfiguration.setDebugPaths(this.debugPaths.isSelected());
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            GdSettingsEditor.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.godotExe = new LabeledComponent();
        this.tscn = new LabeledComponent();
        this.arguments = new LabeledComponent();
        TextFieldWithBrowseButton godotField = new TextFieldWithBrowseButton();
        godotField.setText("");
        godotField.setToolTipText("Path to the Godot Executable");
        godotField.addBrowseFolderListener(new TextBrowseFolderListener(SystemInfo.isWindows ? FileChooserDescriptorFactory.createSingleFileDescriptor((String)"exe") : FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor()));
        this.godotExe.setComponent((JComponent)godotField);
        TextFieldWithBrowseButton tscnField = new TextFieldWithBrowseButton();
        tscnField.setText("Node.tscn");
        tscnField.setToolTipText("Node.tscn");
        tscnField.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFileDescriptor((String)"tscn")));
        this.tscn.setComponent((JComponent)tscnField);
        JTextField argumentsField = new JTextField();
        argumentsField.setText("options");
        argumentsField.setToolTipText("options");
        this.arguments.setComponent((JComponent)argumentsField);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "gdscript/run/GdSettingsEditor", "createEditor"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        LabeledComponent<TextFieldWithBrowseButton> labeledComponent = this.tscn;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("Scene file");
        jPanel.add((Component)labeledComponent, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, new Dimension(-1, 20), null));
        LabeledComponent<TextFieldWithBrowseButton> labeledComponent2 = this.godotExe;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText("Godot Executable");
        jPanel.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, new Dimension(-1, 20), null));
        this.debugShapes = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        jCheckBox2.setText("Visible Collision Shapes");
        jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.debugPaths = jCheckBox = new JCheckBox();
        jCheckBox.setText("Visible Paths");
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        LabeledComponent<JTextField> labeledComponent3 = this.arguments;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText("Options");
        jPanel.add((Component)labeledComponent3, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, new Dimension(-1, 20), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

