/*
 * Decompiled with CFR 0.152.
 */
package gdscript.reference;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceBase;
import gdscript.completion.GdLookup;
import gdscript.index.impl.GdFileResIndex;
import gdscript.psi.GdElementFactory;
import gdscript.psi.utils.GdCfgUtil;
import gdscript.utils.StringUtil;
import gdscript.utils.VirtualFileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgdscript/reference/GdResourceReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "element", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "key", "", "resKey", "project", "Lcom/intellij/openapi/project/Project;", "handleElementRename", "newElementName", "bindToElement", "resolve", "getVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()[Lcom/intellij/codeInsight/lookup/LookupElement;", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nGdResourceReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdResourceReference.kt\ngdscript/reference/GdResourceReference\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,80:1\n23#2:81\n11561#3:82\n11896#3,3:83\n37#4,2:86\n*S KotlinDebug\n*F\n+ 1 GdResourceReference.kt\ngdscript/reference/GdResourceReference\n*L\n40#1:81\n71#1:82\n71#1:83,3\n76#1:86,2\n*E\n"})
public final class GdResourceReference
extends PsiReferenceBase<PsiElement> {
    @NotNull
    private String key;
    @NotNull
    private String resKey;
    @NotNull
    private Project project;

    public GdResourceReference(@NotNull PsiElement element) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super(element, new TextRange(0, element.getTextLength()));
            this.key = "";
            this.resKey = "";
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.project = project;
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.key = string;
            char[] cArray = new char[]{'\"', '\''};
            this.resKey = StringsKt.trim((String)this.key, (char[])cArray);
            if (StringsKt.startsWith$default((String)this.resKey, (String)"res://", (boolean)false, (int)2, null)) break block4;
            PsiFile psiFile = element.getContainingFile();
            if (psiFile != null && (psiFile = psiFile.getVirtualFile()) != null && (psiFile = psiFile.getParent()) != null) {
                VirtualFile virtualFile;
                PsiFile it = psiFile;
                boolean bl = false;
                try {
                    virtualFile = com.intellij.openapi.vfs.VirtualFileUtil.findFileOrDirectory((VirtualFile)it, (String)this.resKey);
                }
                catch (Exception e) {
                    GdResourceReference $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(GdResourceReference.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Failed to resolve relative resource path '" + this.resKey + "' from parent '" + it.getPath() + "': Exception", (Throwable)e);
                    virtualFile = null;
                }
                VirtualFile file = virtualFile;
                if (file != null && com.intellij.openapi.vfs.VirtualFileUtil.isFile((VirtualFile)file)) {
                    this.resKey = VirtualFileUtil.INSTANCE.resourcePath(file, true);
                }
            }
        }
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        if (!StringsKt.startsWith$default((String)this.key, (String)"\"res://", (boolean)false, (int)2, null)) {
            PsiElement psiElement = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            return psiElement;
        }
        char[] cArray = new char[]{'\"', '\''};
        GdCfgUtil.INSTANCE.renameValue(this.project, StringsKt.trim((String)this.key, (char[])cArray), "res://" + newElementName);
        PsiElement psiElement = this.getElement().replace(GdElementFactory.INSTANCE.typeStringVal(this.project, newElementName));
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"replace(...)");
        return psiElement;
    }

    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        this.handleElementRename(VirtualFileUtil.INSTANCE.resourcePath(virtualFile, false));
        return element;
    }

    @Nullable
    public PsiElement resolve() {
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull((Iterable)GdFileResIndex.Companion.getFiles(this.resKey, this.project));
        return (PsiElement)(virtualFile != null ? VirtualFileUtil.INSTANCE.getPsiFile(virtualFile, this.project) : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LookupElement[] getVariants() {
        void $this$mapTo$iv$iv;
        String[] $this$map$iv = StringUtil.INSTANCE.filterGdTscn(GdFileResIndex.Companion.getNonEmptyKeys(this.project));
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GdLookup.create$default(GdLookup.INSTANCE, "\"" + (String)it + "\"", null, null, 220.0, null, null, null, null, null, 502, null));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new LookupElement[0]);
    }
}

