/*
 * Decompiled with CFR 0.152.
 */
package gdscript.refactoring.inline;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import gdscript.psi.GdConstDeclSt;
import gdscript.psi.GdConstDeclTl;
import gdscript.psi.GdVarNmi;
import gdscript.refactoring.inline.GdInlineVariableProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u000eH\u0014J\b\u0010\u0010\u001a\u00020\u000eH\u0014J\b\u0010\u0011\u001a\u00020\u000eH\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0013H\u0014J\u0012\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0006\u0010\u001a\u001a\u00020\u0019R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgdscript/refactoring/inline/GdInlineVariableDialog;", "Lcom/intellij/refactoring/inline/InlineOptionsDialog;", "project", "Lcom/intellij/openapi/project/Project;", "field", "Lgdscript/psi/GdVarNmi;", "ref", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgdscript/psi/GdVarNmi;Lcom/intellij/psi/PsiElement;)V", "myRef", "occurrences", "", "getNameLabelText", "", "getBorderTitle", "getInlineAllText", "getInlineThisText", "allowInlineAll", "", "isInlineThis", "ignoreOccurrence", "reference", "Lcom/intellij/psi/PsiReference;", "doAction", "", "inlineAndRemove", "intellij.rider.plugins.godot.gdscript"})
public final class GdInlineVariableDialog
extends InlineOptionsDialog {
    @Nullable
    private final PsiElement myRef;
    private final int occurrences;

    public GdInlineVariableDialog(@NotNull Project project, @NotNull GdVarNmi field, @Nullable PsiElement ref) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        super(project, true, (PsiElement)field);
        this.myRef = ref;
        this.occurrences = this.getNumberOfOccurrences(field);
        this.myInvokedOnReference = ref != null;
        this.setTitle("Inline Variable");
        this.init();
    }

    @NotNull
    protected String getNameLabelText() {
        PsiElement parent = this.myElement.getParent();
        boolean isConst = parent instanceof GdConstDeclTl || parent instanceof GdConstDeclSt;
        String string = isConst ? "Constant" : "Variable";
        PsiElement psiElement = this.myElement;
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type gdscript.psi.GdVarNmi");
        String label = string + " " + ((GdVarNmi)psiElement).getName();
        if (this.occurrences > 1) {
            label = label + ", " + this.occurrences + " occurrences";
        }
        return label;
    }

    @NotNull
    protected String getBorderTitle() {
        return "Inline Variable";
    }

    @NotNull
    protected String getInlineAllText() {
        return "Inline all references and remove the variable";
    }

    @NotNull
    protected String getInlineThisText() {
        return "Inline this reference and keep the variable";
    }

    protected boolean allowInlineAll() {
        return true;
    }

    protected boolean isInlineThis() {
        return true;
    }

    protected boolean ignoreOccurrence(@Nullable PsiReference reference) {
        return true;
    }

    protected void doAction() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiElement psiElement = this.myElement;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"myElement");
        this.invokeRefactoring(new GdInlineVariableProcessor(project, psiElement, this.myRef, this.isInlineThisOnly(), !this.isKeepTheDeclaration()));
    }

    public final void inlineAndRemove() {
        this.myRbInlineAll.setSelected(true);
        this.doAction();
    }
}

