/*
 * Decompiled with CFR 0.152.
 */
package gdscript.psi.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import gdscript.index.impl.GdClassIdIndex;
import gdscript.index.impl.GdFileResIndex;
import gdscript.psi.GdClassDeclTl;
import gdscript.psi.GdClassNameNmi;
import gdscript.psi.GdClassNaming;
import gdscript.psi.GdFile;
import gdscript.psi.GdInheritance;
import gdscript.psi.utils.GdClassUtil;
import gdscript.psi.utils.PsiGdClassUtil;
import gdscript.utils.VirtualFileUtil;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005J \u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000f"}, d2={"Lgdscript/psi/utils/GdInheritanceUtil;", "", "<init>", "()V", "getExtendedClassId", "", "element", "Lcom/intellij/psi/PsiElement;", "getExtendedElement", "project", "Lcom/intellij/openapi/project/Project;", "isExtending", "", "className", "classId", "intellij.rider.plugins.godot.gdscript"})
public final class GdInheritanceUtil {
    @NotNull
    public static final GdInheritanceUtil INSTANCE = new GdInheritanceUtil();

    private GdInheritanceUtil() {
    }

    @NotNull
    public final String getExtendedClassId(@NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof GdClassNaming) {
            String string2 = ((GdClassNaming)element).getParentName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getParentName(...)");
        } else if (psiElement instanceof GdClassDeclTl) {
            String string3 = ((GdClassDeclTl)element).getParentName();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getParentName(...)");
        } else if (psiElement instanceof GdFile) {
            GdInheritance gdInheritance = (GdInheritance)PsiTreeUtil.getStubChildOfType((PsiElement)element, GdInheritance.class);
            string = gdInheritance != null ? gdInheritance.getInheritancePath() : null;
            if (string == null) {
                string = "";
            }
        } else {
            string = psiElement instanceof PsiFile ? "" : this.getExtendedClassId(PsiGdClassUtil.INSTANCE.getParentClassElement(element));
        }
        return string;
    }

    @Deprecated(message="Switch to getExtendedElement(element, project) to promote efficient project reference usage", replaceWith=@ReplaceWith(expression="getExtendedElement(element, project)", imports={"gdscript.psi.utils.GdInheritanceUtil.getExtendedElement"}))
    @Nullable
    public final PsiElement getExtendedElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = this.getExtendedClassId(element);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.getExtendedElement(string, element, project);
    }

    @Nullable
    public final PsiElement getExtendedElement(@NotNull PsiElement element, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getExtendedElement(this.getExtendedClassId(element), element, project);
    }

    public final boolean isExtending(@NotNull PsiElement element, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (Intrinsics.areEqual((Object)GdClassUtil.INSTANCE.getOwningClassName(element), (Object)className)) {
            return true;
        }
        String parentId = this.getExtendedClassId(element);
        while (!StringsKt.isBlank((CharSequence)parentId)) {
            GdClassNameNmi parent;
            if (Intrinsics.areEqual((Object)parentId, (Object)className)) {
                return true;
            }
            if ((GdClassNameNmi)CollectionsKt.firstOrNull((Iterable)GdClassIdIndex.Companion.getINSTANCE().getGlobally(parentId, element)) == null) {
                return false;
            }
            parentId = this.getExtendedClassId((PsiElement)parent);
        }
        return false;
    }

    @Nullable
    public final PsiElement getExtendedElement(@NotNull String classId, @NotNull PsiElement element, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiElement classEl = GdClassUtil.INSTANCE.getClassIdElement(classId, element, project);
        if (classEl != null) {
            return classEl.getParent() instanceof GdClassDeclTl ? classEl.getParent() : (PsiElement)classEl.getContainingFile();
        }
        char[] cArray = new char[]{'\"', '\''};
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull((Iterable)GdFileResIndex.Companion.getFiles(StringsKt.trim((String)classId, (char[])cArray), project));
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        return (PsiElement)VirtualFileUtil.INSTANCE.getPsiFile(file, project);
    }
}

