/*
 * Decompiled with CFR 0.152.
 */
package gdscript.psi.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.rd.util.CollectionExKt;
import gdscript.psi.GdMethodDeclTl;
import gdscript.psi.utils.GdClassMemberUtil;
import gdscript.psi.utils.GdClassUtil;
import gdscript.psi.utils.GdInheritanceUtil;
import gdscript.utils.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"Lgdscript/psi/utils/GdExprUtil;", "", "<init>", "()V", "typeAccepts", "", "from", "", "into", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "allowedExceptions", "left", "right", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nGdExprUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdExprUtil.kt\ngdscript/psi/utils/GdExprUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,73:1\n13805#2,2:74\n*S KotlinDebug\n*F\n+ 1 GdExprUtil.kt\ngdscript/psi/utils/GdExprUtil\n*L\n44#1:74,2\n*E\n"})
public final class GdExprUtil {
    @NotNull
    public static final GdExprUtil INSTANCE = new GdExprUtil();

    private GdExprUtil() {
    }

    public final boolean typeAccepts(@NotNull String from, @NotNull String into, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.typeAccepts(from, into, project);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean typeAccepts(@NotNull String from, @NotNull String into, @NotNull Project project) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (Intrinsics.areEqual((Object)from, (Object)into)) {
            return true;
        }
        if (StringsKt.isBlank((CharSequence)from) || StringsKt.isBlank((CharSequence)into)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)into, (Object)"void")) {
            return false;
        }
        String left = into;
        String right = null;
        right = from;
        int arrays = 0;
        if (StringsKt.startsWith$default((String)from, (String)"Array", (boolean)false, (int)2, null)) {
            ++arrays;
        }
        if (StringsKt.startsWith$default((String)into, (String)"Array", (boolean)false, (int)2, null)) {
            ++arrays;
        }
        if (arrays > 1) {
            left = StringUtil.INSTANCE.parseFromSquare(left);
            right = StringUtil.INSTANCE.parseFromSquare(right);
        }
        if (this.allowedExceptions(left, right, project)) {
            return true;
        }
        PsiElement psiElement = GdClassUtil.INSTANCE.getClassIdElement(left, project);
        if (psiElement == null) {
            return true;
        }
        PsiElement classId = psiElement;
        PsiElement classElement = GdClassUtil.INSTANCE.getOwningClassElement(classId);
        GdMethodDeclTl[] gdMethodDeclTlArray = GdClassMemberUtil.INSTANCE.constructors(GdClassMemberUtil.listClassMemberDeclarations$default(GdClassMemberUtil.INSTANCE, classElement, null, null, true, false, 22, null));
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            LinkedHashMap<String, String> linkedHashMap = it.getParameters();
            Intrinsics.checkNotNullExpressionValue(linkedHashMap, (String)"getParameters(...)");
            Map.Entry entry = CollectionExKt.firstOrNull((Map)linkedHashMap);
            if (!Intrinsics.areEqual((Object)(entry != null ? (String)entry.getValue() : null), (Object)right)) continue;
            return true;
        }
        PsiElement psiElement2 = GdClassUtil.INSTANCE.getClassIdElement(right, project);
        if (psiElement2 == null) {
            return true;
        }
        PsiElement currentClassId = psiElement2;
        PsiElement currentClassElement = GdClassUtil.INSTANCE.getOwningClassElement(currentClassId);
        return GdInheritanceUtil.INSTANCE.isExtending(currentClassElement, left);
    }

    private final boolean allowedExceptions(String left, String right, Project project) {
        PsiElement currentClassId;
        Object[] objectArray = new String[]{"Variant", "RID"};
        if (ArraysKt.contains((Object[])objectArray, (Object)left) || ArraysKt.contains((Object[])(objectArray = new String[]{"Variant"}), (Object)right)) {
            return true;
        }
        objectArray = new String[]{"Node", "Resource"};
        if (ArraysKt.contains((Object[])objectArray, (Object)right) && (currentClassId = GdClassUtil.INSTANCE.getClassIdElement(left, project)) != null) {
            PsiElement currentClassElement = GdClassUtil.INSTANCE.getOwningClassElement(currentClassId);
            return GdInheritanceUtil.INSTANCE.isExtending(currentClassElement, right);
        }
        return false;
    }
}

