/*
 * Decompiled with CFR 0.152.
 */
package gdscript.psi.utils;

import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import gdscript.codeInsight.documentation.GdDocUtil;
import gdscript.codeInsight.documentation.GdGodotDocUtil;
import gdscript.lineMarker.GdTraitLineMarkerContributor;
import gdscript.model.GdCommentModel;
import gdscript.model.GdTutorial;
import gdscript.psi.GdClassNaming;
import gdscript.psi.GdTypes;
import gdscript.psi.types.GdDocumented;
import gdscript.utils.PsiElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010$\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010%\u001a\u00020&2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\"\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0 0(2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u001c\u0010)\u001a\u00020**\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0 0(J\u001c\u0010+\u001a\u00020**\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0 0(J\u001c\u0010,\u001a\u00020**\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0 0(J\u001c\u0010-\u001a\u00020\t*\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0 0(J\u001c\u0010.\u001a\u00020**\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0 0(J\u001c\u0010/\u001a\u00020**\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0 0(R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00060"}, d2={"Lgdscript/psi/utils/GdCommentUtil;", "", "<init>", "()V", "TUTORIAL_REGEX", "Lkotlin/text/Regex;", "getTUTORIAL_REGEX", "()Lkotlin/text/Regex;", "DESCRIPTION", "", "getDESCRIPTION", "()Ljava/lang/String;", "PARAMETER", "getPARAMETER", "BRIEF_DESCRIPTION", "getBRIEF_DESCRIPTION", "ENUM", "getENUM", "RETURN", "getRETURN", "TUTORIAL", "getTUTORIAL", "BREAKS_AT", "", "getBREAKS_AT", "()[Ljava/lang/String;", "[Ljava/lang/String;", "brief", "element", "Lcom/intellij/psi/PsiElement;", "description", "tutorials", "", "Lgdscript/model/GdTutorial;", "isDeprecated", "", "isExperimental", "collectComments", "Lgdscript/model/GdCommentModel;", "collectAllDescriptions", "", "briefDescriptionBlock", "Lcom/intellij/openapi/util/text/HtmlChunk;", "descriptionBlock", "tutorialBlock", "descriptionText", "parameterBlock", "returnBlock", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nGdCommentUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdCommentUtil.kt\ngdscript/psi/utils/GdCommentUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n1#2:222\n1869#3,2:223\n1563#3:225\n1634#3,3:226\n1563#3:229\n1634#3,3:230\n1563#3:233\n1634#3,3:234\n*S KotlinDebug\n*F\n+ 1 GdCommentUtil.kt\ngdscript/psi/utils/GdCommentUtil\n*L\n127#1:223,2\n199#1:225\n199#1:226,3\n209#1:229\n209#1:230,3\n215#1:233\n215#1:234,3\n*E\n"})
public final class GdCommentUtil {
    @NotNull
    public static final GdCommentUtil INSTANCE = new GdCommentUtil();
    @NotNull
    private static final Regex TUTORIAL_REGEX = new Regex("@tutorial(\\(.+\\))?:\\s+(.+)");
    @NotNull
    private static final String DESCRIPTION = "desc";
    @NotNull
    private static final String PARAMETER = "param";
    @NotNull
    private static final String BRIEF_DESCRIPTION = "brief";
    @NotNull
    private static final String ENUM = "enum";
    @NotNull
    private static final String RETURN = "return";
    @NotNull
    private static final String TUTORIAL = "tutorial";
    @NotNull
    private static final String[] BREAKS_AT;

    private GdCommentUtil() {
    }

    @NotNull
    public final Regex getTUTORIAL_REGEX() {
        return TUTORIAL_REGEX;
    }

    @NotNull
    public final String getDESCRIPTION() {
        return DESCRIPTION;
    }

    @NotNull
    public final String getPARAMETER() {
        return PARAMETER;
    }

    @NotNull
    public final String getBRIEF_DESCRIPTION() {
        return BRIEF_DESCRIPTION;
    }

    @NotNull
    public final String getENUM() {
        return ENUM;
    }

    @NotNull
    public final String getRETURN() {
        return RETURN;
    }

    @NotNull
    public final String getTUTORIAL() {
        return TUTORIAL;
    }

    @NotNull
    public final String[] getBREAKS_AT() {
        return BREAKS_AT;
    }

    @NotNull
    public final String brief(@NotNull PsiElement element) {
        CharSequence charSequence;
        StubElement stub;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof StubBasedPsiElement && element instanceof GdDocumented && (stub = ((StubBasedPsiElement)element).getStub()) != null && stub instanceof GdDocumented) {
            return ((GdDocumented)stub).brief();
        }
        GdCommentModel model = this.collectComments(element);
        CharSequence charSequence2 = model.getBrief();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = model.getDescription();
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @NotNull
    public final String description(@NotNull PsiElement element) {
        StubElement stub;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof StubBasedPsiElement && element instanceof GdDocumented && (stub = ((StubBasedPsiElement)element).getStub()) != null && stub instanceof GdDocumented) {
            return ((GdDocumented)stub).description();
        }
        GdCommentModel model = this.collectComments(element);
        return model.getDescription();
    }

    @NotNull
    public final List<GdTutorial> tutorials(@NotNull PsiElement element) {
        StubElement stub;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof StubBasedPsiElement && element instanceof GdDocumented && (stub = ((StubBasedPsiElement)element).getStub()) != null && stub instanceof GdDocumented) {
            return ((GdDocumented)stub).tutorials();
        }
        GdCommentModel model = this.collectComments(element);
        return model.getTutorials();
    }

    public final boolean isDeprecated(@NotNull PsiElement element) {
        StubElement stub;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof StubBasedPsiElement && element instanceof GdDocumented && (stub = ((StubBasedPsiElement)element).getStub()) != null && stub instanceof GdDocumented) {
            return ((GdDocumented)stub).isDeprecated();
        }
        GdCommentModel model = this.collectComments(element);
        return model.isDeprecated();
    }

    public final boolean isExperimental(@NotNull PsiElement element) {
        StubElement stub;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof StubBasedPsiElement && element instanceof GdDocumented && (stub = ((StubBasedPsiElement)element).getStub()) != null && stub instanceof GdDocumented) {
            return ((GdDocumented)stub).isExperimental();
        }
        GdCommentModel model = this.collectComments(element);
        return model.isExperimental();
    }

    @NotNull
    public final GdCommentModel collectComments(@Nullable PsiElement element) {
        List comments = new ArrayList();
        GdCommentModel model = new GdCommentModel(null, null, null, false, false, 31, null);
        if (element instanceof GdClassNaming || element instanceof PsiFile) {
            PsiElement file = element;
            if (element instanceof GdClassNaming) {
                file = ((GdClassNaming)element).getParent();
            }
            PsiElement psiElement = file;
            boolean isComment = false;
            boolean newLined = false;
            for (PsiElement child = (v100031) != null ? (v100031).getFirstChild() : null; child != null; child = child.getNextSibling()) {
                if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)child), (Object)GdTypes.COMMENT)) {
                    String string = child.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (!StringsKt.startsWith$default((String)string, (String)"##", (boolean)false, (int)2, null)) continue;
                    isComment = true;
                    String string2 = child.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    comments.add(((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)string2, (CharSequence)"##"))).toString());
                    newLined = false;
                    continue;
                }
                if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)child), (Object)TokenType.WHITE_SPACE)) {
                    if (!Intrinsics.areEqual((Object)child.getText(), (Object)"\n")) continue;
                    if (newLined) break;
                    newLined = true;
                    continue;
                }
                if (isComment) break;
            }
            CollectionsKt.reverse((List)comments);
        } else {
            PsiElement previous = element;
            while (true) {
                PsiElement psiElement = previous;
                PsiElement psiElement2 = previous = psiElement != null ? PsiElementUtil.INSTANCE.prevCommentBlock(psiElement) : null;
                if (previous == null) break;
                String txt = previous.getText();
                Intrinsics.checkNotNull((Object)txt);
                if (!StringsKt.startsWith$default((String)txt, (String)"##", (boolean)false, (int)2, null)) break;
                comments.add(((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)txt, (CharSequence)"##"))).toString());
            }
        }
        boolean brief = false;
        Iterable $this$forEach$iv = comments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            char[] cArray;
            String it = (String)element$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it, (String)"@description", (boolean)false, (int)2, null)) {
                model.setDeprecated(true);
                continue;
            }
            if (StringsKt.startsWith$default((String)it, (String)"@tutorial", (boolean)false, (int)2, null)) {
                MatchResult matchResult = Regex.find$default((Regex)TUTORIAL_REGEX, (CharSequence)it, (int)0, (int)2, null);
                MatchGroupCollection groups = matchResult != null ? matchResult.getGroups() : null;
                GdTutorial tutorial = new GdTutorial(null, null, 3, null);
                MatchGroupCollection matchGroupCollection = groups;
                if ((matchGroupCollection != null ? matchGroupCollection.get(2) : null) == null) continue;
                MatchGroup matchGroup = groups.get(2);
                Intrinsics.checkNotNull((Object)matchGroup);
                tutorial.setUrl(matchGroup.getValue());
                Object object = groups.get(1);
                if (object == null || (object = object.getValue()) == null) {
                    MatchGroup matchGroup2 = groups.get(2);
                    Intrinsics.checkNotNull((Object)matchGroup2);
                    object = matchGroup2.getValue();
                }
                tutorial.setName((String)object);
                model.getTutorials().add(0, tutorial);
                continue;
            }
            if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)it)).toString(), (Object)"") && !Intrinsics.areEqual((Object)model.getDescription(), (Object)"")) {
                brief = true;
                continue;
            }
            if (brief) {
                cArray = new char[]{'\n'};
                model.setBrief(StringsKt.trim((String)(it + "\n" + model.getBrief()), (char[])cArray));
                continue;
            }
            cArray = new char[]{'\n'};
            model.setDescription(StringsKt.trim((String)(it + "\n" + model.getDescription()), (char[])cArray));
        }
        return model;
    }

    @NotNull
    public final Map<String, List<String>> collectAllDescriptions(@Nullable PsiElement element) {
        PsiElement el;
        Map descriptions = new LinkedHashMap();
        descriptions.put(DESCRIPTION, (List)new ArrayList());
        descriptions.put(BRIEF_DESCRIPTION, (List)new ArrayList());
        descriptions.put(PARAMETER, (List)new ArrayList());
        descriptions.put(ENUM, (List)new ArrayList());
        descriptions.put(RETURN, (List)new ArrayList());
        descriptions.put(TUTORIAL, (List)new ArrayList());
        PsiElement psiElement = element;
        Object object = el = psiElement != null ? psiElement.getPrevSibling() : null;
        while (el != null) {
            IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)el);
            if (Intrinsics.areEqual((Object)iElementType, (Object)GdTypes.COMMENT)) {
                String string = el.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String text = ((Object)StringsKt.trimStart((CharSequence)StringsKt.removePrefix((String)string, (CharSequence)"#"))).toString();
                String prefix = StringsKt.substringBefore$default((String)text, (String)" ", null, (int)2, null);
                if (ArraysKt.contains((Object[])BREAKS_AT, (Object)prefix)) break;
                if (!descriptions.containsKey(prefix)) {
                    prefix = DESCRIPTION;
                } else {
                    text = StringsKt.substringAfter$default((String)text, (String)" ", null, (int)2, null);
                }
                if (!Intrinsics.areEqual((Object)prefix, (Object)TUTORIAL)) {
                    text = GdGodotDocUtil.INSTANCE.parseStyles(text);
                }
                Object v = descriptions.get(prefix);
                Intrinsics.checkNotNull(v);
                ((List)v).add(0, text);
            } else if (!Intrinsics.areEqual((Object)iElementType, (Object)TokenType.WHITE_SPACE) && !Intrinsics.areEqual((Object)iElementType, (Object)GdTypes.ANNOTATION_TL)) break;
            el = el.getPrevSibling();
        }
        return descriptions;
    }

    @NotNull
    public final HtmlChunk briefDescriptionBlock(@NotNull Map<String, ? extends List<String>> $this$briefDescriptionBlock) {
        Intrinsics.checkNotNullParameter($this$briefDescriptionBlock, (String)"<this>");
        List<String> list = $this$briefDescriptionBlock.get(BRIEF_DESCRIPTION);
        Intrinsics.checkNotNull(list);
        List<String> comments = !((Collection)list).isEmpty() ? $this$briefDescriptionBlock.get(BRIEF_DESCRIPTION) : $this$briefDescriptionBlock.get(DESCRIPTION);
        return GdDocUtil.INSTANCE.paragraph("");
    }

    @NotNull
    public final HtmlChunk descriptionBlock(@NotNull Map<String, ? extends List<String>> $this$descriptionBlock) {
        Intrinsics.checkNotNullParameter($this$descriptionBlock, (String)"<this>");
        return GdDocUtil.INSTANCE.paragraph("");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HtmlChunk tutorialBlock(@NotNull Map<String, ? extends List<String>> $this$tutorialBlock) {
        Collection<HtmlChunk.Element> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter($this$tutorialBlock, (String)"<this>");
        List<String> list = $this$tutorialBlock.get(TUTORIAL);
        Intrinsics.checkNotNull(list);
        Iterable iterable = list;
        String string = "tutorials";
        GdDocUtil gdDocUtil = GdDocUtil.INSTANCE;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(HtmlChunk.link((String)((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)it, (String)"]", null, (int)2, null))).toString(), (String)((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)StringsKt.substringBefore$default((String)it, (String)"]", null, (int)2, null), (CharSequence)"["))).toString()));
        }
        collection = (List)destination$iv$iv;
        return gdDocUtil.listTable(string, (List<? extends HtmlChunk>)collection);
    }

    @NotNull
    public final String descriptionText(@NotNull Map<String, ? extends List<String>> $this$descriptionText) {
        Intrinsics.checkNotNullParameter($this$descriptionText, (String)"<this>");
        List<String> list = $this$descriptionText.get(DESCRIPTION);
        Intrinsics.checkNotNull(list);
        return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"<br/>", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HtmlChunk parameterBlock(@NotNull Map<String, ? extends List<String>> $this$parameterBlock) {
        Collection<HtmlChunk> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter($this$parameterBlock, (String)"<this>");
        List<String> list = $this$parameterBlock.get(PARAMETER);
        Intrinsics.checkNotNull(list);
        Iterable iterable = list;
        String string = "params";
        GdDocUtil gdDocUtil = GdDocUtil.INSTANCE;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            HtmlChunk htmlChunk = HtmlChunk.raw((String)StringsKt.replaceFirst$default((String)it, (String)" ", (String)" - ", (boolean)false, (int)4, null));
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"raw(...)");
            collection.add(htmlChunk);
        }
        collection = (List)destination$iv$iv;
        return gdDocUtil.listTable(string, (List<? extends HtmlChunk>)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HtmlChunk returnBlock(@NotNull Map<String, ? extends List<String>> $this$returnBlock) {
        Collection<HtmlChunk> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter($this$returnBlock, (String)"<this>");
        List<String> list = $this$returnBlock.get(RETURN);
        Intrinsics.checkNotNull(list);
        Iterable iterable = list;
        String string = "return";
        GdDocUtil gdDocUtil = GdDocUtil.INSTANCE;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            HtmlChunk htmlChunk = HtmlChunk.raw((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"raw(...)");
            collection.add(htmlChunk);
        }
        collection = (List)destination$iv$iv;
        return gdDocUtil.listTable(string, (List<? extends HtmlChunk>)collection);
    }

    static {
        String[] stringArray = new String[2];
        char[] cArray = new char[]{'#'};
        stringArray[0] = StringsKt.trimStart((String)GdTraitLineMarkerContributor.Companion.getPREFIX(), (char[])cArray);
        cArray = new char[]{'#'};
        stringArray[1] = StringsKt.trimStart((String)GdTraitLineMarkerContributor.Companion.getSUFFIX(), (char[])cArray);
        BREAKS_AT = stringArray;
    }
}

