/*
 * Decompiled with CFR 0.152.
 */
package gdscript.library;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lgdscript/library/SdkIntegrityValidator;", "", "<init>", "()V", "getFilesFromFs", "", "", "folder", "Ljava/nio/file/Path;", "writeStamp", "", "Ljava/io/File;", "hasValidStamp", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nSdkIntegrityValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkIntegrityValidator.kt\ngdscript/library/SdkIntegrityValidator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,48:1\n23#2:49\n23#2:50\n23#2:51\n*S KotlinDebug\n*F\n+ 1 SdkIntegrityValidator.kt\ngdscript/library/SdkIntegrityValidator\n*L\n32#1:49\n39#1:50\n42#1:51\n*E\n"})
public final class SdkIntegrityValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String STAMP_FILE_NAME = "_gd-sdk-file-stamp.txt";

    @NotNull
    public final List<String> getFilesFromFs(@NotNull Path folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        List<String> list = Files.find(folder, 16, SdkIntegrityValidator::getFilesFromFs$lambda$0, new FileVisitOption[0]).map(arg_0 -> SdkIntegrityValidator.getFilesFromFs$lambda$2(arg_0 -> SdkIntegrityValidator.getFilesFromFs$lambda$1(folder, arg_0), arg_0)).sorted().collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    public final void writeStamp(@NotNull File folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Path path = folder.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        int stamp = ((Collection)this.getFilesFromFs(path)).size();
        FilesKt.writeText((File)FilesKt.resolve((File)folder, (String)STAMP_FILE_NAME), (String)String.valueOf(stamp), (Charset)Charsets.UTF_8);
    }

    public final boolean hasValidStamp(@NotNull VirtualFile folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        VirtualFile stampFile = VirtualFileUtil.findFile((VirtualFile)folder, (String)STAMP_FILE_NAME);
        if (stampFile == null) {
            SdkIntegrityValidator $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SdkIntegrityValidator.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Stamp file does not exist at \u201c" + stampFile + "\u201d.");
            return false;
        }
        String stampCount = ((Object)StringsKt.trim((CharSequence)VirtualFileUtil.readText((VirtualFile)stampFile))).toString();
        Path path = folder.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        String count = String.valueOf(((Collection)this.getFilesFromFs(path)).size());
        if (Intrinsics.areEqual((Object)stampCount, (Object)count)) {
            SdkIntegrityValidator $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SdkIntegrityValidator.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Stamp is valid.");
            return true;
        }
        SdkIntegrityValidator $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(SdkIntegrityValidator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Folder content were modified. Details: Stamp file=" + stampCount + ", now=" + count + ".");
        return false;
    }

    private static final boolean getFilesFromFs$lambda$0(Path path, BasicFileAttributes attr) {
        return !attr.isDirectory() && !Intrinsics.areEqual((Object)((Object)path.getFileName()).toString(), (Object)STAMP_FILE_NAME);
    }

    private static final String getFilesFromFs$lambda$1(Path $folder, Path it) {
        File file = it.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        File file2 = $folder.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        return FilesKt.relativeTo((File)file, (File)file2).getPath();
    }

    private static final String getFilesFromFs$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgdscript/library/SdkIntegrityValidator$Companion;", "", "<init>", "()V", "STAMP_FILE_NAME", "", "intellij.rider.plugins.godot.gdscript"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

